# 2020-09-28 Triage Log

Most significant changes this week came in response to regressions discussed in
last week's triage report. Curious readers may be interested in
[#77058](https://github.com/rust-lang/rust/issues/77058), in which the removal
of a single field from a struct caused a 25% decrease in wall-times for one
seemingly unrelated benchmark, or
[#76986](https://github.com/rust-lang/rust/issues/76986), an ABI change that
should be a pretty clear win but seems to have mixed results.

Triage done by **@ecstaticmorse**.
Revision range: [b01326ab033e41986d4a5c8b96ce4f40f3b38e30..6369a98ebdee8ce01510f5d4307ddb771c8cb0e5](https://perf.rust-lang.org/?start=b01326ab033e41986d4a5c8b96ce4f40f3b38e30&end=6369a98ebdee8ce01510f5d4307ddb771c8cb0e5&absolute=false&stat=instructions%3Au)

0 Regressions, 1 Improvements, 3 Mixed

0 of them in rollups

#### Improvements

[#77041](https://github.com/rust-lang/rust/issues/77041) perf: move cold path of `process_obligations` into a separate function
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=fadf0257235ddb8a464befc02e50b35652174689&end=521d8d8a2236a239e3327336844ed5948857ea31&stat=instructions:u) (up to -4.8% on `full` builds of `inflate-check`)
- Fixes a regression introduced in [#76575](https://github.com/rust-lang/rust/issues/76575).

#### Mixed

[#77006](https://github.com/rust-lang/rust/issues/77006)  Cache `eval_to_allocation_raw` on disk
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=893fadd11a52aa26fc19c67ee1b79f03d6a1bed3&end=87d262acb50200d767baa7115f30c650a13672ee&stat=instructions:u) (up to -83.9% on `incr-unchanged` builds of `ctfe-stress-4-check`)
- Large regression in [task clock](https://perf.rust-lang.org/compare.html?start=893fadd11a52aa26fc19c67ee1b79f03d6a1bed3&end=87d262acb50200d767baa7115f30c650a13672ee&stat=task-clock) (up to 14.5% on `incr-full` builds of `ctfe-stress-4-check`),
- Fixes a regression introduced in [#74949](https://github.com/rust-lang/rust/issues/74949).
- `incr-full` builds of `ctfe-stress-4` also have significantly increased [`max-rss`](https://perf.rust-lang.org/?start=b01326ab033e41986d4a5c8b96ce4f40f3b38e30&end=6369a98ebdee8ce01510f5d4307ddb771c8cb0e5&absolute=false&stat=instructions%3Au).
- Real-world benchmarks seem to have mostly improved, however.

[#76913](https://github.com/rust-lang/rust/issues/76913)  Fixing the performance regression of #76244
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f47df31ae5d7d9795399dca3a0003c1856900361&end=45198456be60a6906d24abdc3c67a31b9206188e&stat=instructions:u) (up to -3.1% on `full` builds of `unicode_normalization-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f47df31ae5d7d9795399dca3a0003c1856900361&end=45198456be60a6906d24abdc3c67a31b9206188e&stat=instructions:u) (up to 2.7% on `incr-unchanged` builds of `ctfe-stress-4-check`)
- A temporary revert of [#76244](https://github.com/rust-lang/rust/issues/76244) to fix a rather large wall time regression in `unicode-normalization`.
- Gains will reappear as part of [#77257](https://github.com/rust-lang/rust/issues/77257) with the losses mitigated.

[#76986](https://github.com/rust-lang/rust/issues/76986) Return values up to 128 bits in registers
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1ec980d225fff2346a1a631a7ffc88b37e9e18af&end=62fe055aba3ddac5e5d113920cf5fd80522104e2&stat=instructions:u) (up to 2.3% on `full` builds of `deeply-nested-debug`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1ec980d225fff2346a1a631a7ffc88b37e9e18af&end=62fe055aba3ddac5e5d113920cf5fd80522104e2&stat=instructions:u) (up to -1.9% on `full` builds of `piston-image-opt`)
- Seems to be a slight regression overall, even looking at [`task-clock`](https://perf.rust-lang.org/compare.html?start=1ec980d225fff2346a1a631a7ffc88b37e9e18af&end=62fe055aba3ddac5e5d113920cf5fd80522104e2&stat=task-clock) measurements.

#### Nags requiring follow up

- [#76986](https://github.com/rust-lang/rust/issues/76986)
