
2021-02-09 Triage Log

A week of more regressions than improvements with one fairly large regression in `incr-patched` benchmarks introduced in a rollup. Performance regressions introduced in rollups have been a source of headache lately and something the performance team is looking to improve in the future. 

Triage done by **@rylev**.
Revision range: [f6cb45ad01a4518f615926f39801996622f46179..ea098255f74923d69ea234ee526df6b9cecc3b9b](https://perf.rust-lang.org/?start=f6cb45ad01a4518f615926f39801996622f46179&end=ea098255f74923d69ea234ee526df6b9cecc3b9b&absolute=false&stat=instructions%3Au)

5 Regressions, 2 Improvements, 1 Mixed
2 of them in rollups

#### Regressions

Rollup of 11 pull requests [#81660](https://github.com/rust-lang/rust/issues/81660)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f6cb45ad01a4518f615926f39801996622f46179&end=a3ed564c130ec3f19e933a9ea31faca5a717ce91&stat=instructions:u) (up to 33.1% on `incr-patched: println` builds of `cargo-check`)
- A huge performance regression in a rollup which should not happen. This seems to be happening in `incr-patched` benchmarks in the `typeck` and `evaluate_obligation`.
- This points towards to [#80629](https://github.com/rust-lang/rust/pull/80629) as being the most likely culprit.

Add a new ABI to support cmse_nonsecure_call [#81346](https://github.com/rust-lang/rust/issues/81346)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e6a0f3cdf3801394a53ffa42683385d94b02c772&end=b593389edbaa9ea0c90f0ed419283842f534e50a&stat=instructions:u) (up to 1.9% on `full` builds of `deeply-nested-async-check`)
- Adding support for an additional ABI shouldn't have performance implications on rustc. Perhaps this just happens to be noise, but it's hard to tell.

Identify unreachable subpatterns more reliably [#80632](https://github.com/rust-lang/rust/issues/80632)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5a5f3a980c0d2afd55f2162300339471378e341f&end=36ecbc94eb6be90bc38b2d0fdd4bfac3f34d9923&stat=instructions:u) (up to 1.2% on `full` builds of `match-stress-enum-check`)
- This is a regression in a benchmark specifically for pattern match which is impacted by this change. The [`check match`](https://perf.rust-lang.org/detailed-query.html?commit=36ecbc94eb6be90bc38b2d0fdd4bfac3f34d9923&base_commit=5a5f3a980c0d2afd55f2162300339471378e341f&benchmark=match-stress-enum-check&run_name=full) query was responsible for the regression.
- Interestingly, a [performance run](https://perf.rust-lang.org/compare.html?start=fde692739576089729885b7f79aa2232cb9778c5&end=6e126cb311d93b2142d8eae09719d614926e04b7) was done on this change during review which did not show the regressions seen here.

expand/resolve: Turn `#[derive]` into a regular macro attribute [#79078](https://github.com/rust-lang/rust/issues/79078)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=36ecbc94eb6be90bc38b2d0fdd4bfac3f34d9923&end=9778068cbc1e06cc3685422323ff38a2f397de26&stat=instructions:u) (up to 1.3% on `incr-unchanged` builds of `derive-check`)
- This largely seems to be impacting `incr-unchanged` benchmarks particularly in the `expand_crate` and `late_resolve_crate` queries, and it's happening mostly in stress benchmarks. The only "real" code base impacted this is `style-servo-check` at 1.0% for `incr-unchanged`.

Use ufcs in derive(Debug) [#81294](https://github.com/rust-lang/rust/issues/81294)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6ad11e2e25919b75ebbc36d7910f2a1126a7e873&end=186f7ae5b04d31d8ccd1746ac63cdf1ab4bc2354&stat=instructions:u) (up to -3.3% on `incr-patched: println` builds of `cargo-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6ad11e2e25919b75ebbc36d7910f2a1126a7e873&end=186f7ae5b04d31d8ccd1746ac63cdf1ab4bc2354&stat=instructions:u) (up to 3.3% on `full` builds of `style-servo-check`)
- This was originally labeled as a "mixed" result, but this is largely a perf regression with only a few improvements. 
- This is a correctness fix so it's possible that we'll need to eat any performance regressions.
- There is a PR [open](https://github.com/rust-lang/rust/pull/81760) to try to address the fact that more MIR is produced, but this doesn't seem to have a positive impact on [perf](https://perf.rust-lang.org/compare.html?start=822ebfd2c43fbe466da8ae34ffe3ce6cba2e8336&end=d589fc7d554c7ecdab26eb7ae07fd6dc7e8280f7).

#### Improvements

Rollup of 14 pull requests [#81678](https://github.com/rust-lang/rust/issues/81678)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=368275062fb655c1f36e0398f88b15379a1f3c93&end=d95d4f0189e02ac2cd9056a0b39b0d5ab94fe69e&stat=instructions:u) (up to -1.8% on `full` builds of `deeply-nested-async-check`)

Revert 78373 ("dont leak return value after panic in drop") [#81257](https://github.com/rust-lang/rust/issues/81257)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f9435f4c92651d67d5dbaba13c5606c4c4fc1327&end=5605b5d693ac0aba5b506923e3e99ec927969d04&stat=instructions:u) (up to -8.6% on `incr-patched: println` builds of `regression-31157-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f9435f4c92651d67d5dbaba13c5606c4c4fc1327&end=5605b5d693ac0aba5b506923e3e99ec927969d04&stat=instructions:u) (up to 1.8% on `full` builds of `cranelift-codegen-opt`)
- This was originally labeled as "mixed", but it is largely a performance gain.
- The change is to fix [a bug](https://github.com/rust-lang/rust/issues/80949) discovered in the beta crater run.

#### Mixed

Fix derived PartialOrd operators  [#81384](https://github.com/rust-lang/rust/issues/81384)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f4008fe94935d05ffb3a48fc5b7149070bb45550&end=c648bd55580a918d6f26f39bc167913a9da5ae3d&stat=instructions:u) (up to -34.0% on `full` builds of `derive-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f4008fe94935d05ffb3a48fc5b7149070bb45550&end=c648bd55580a918d6f26f39bc167913a9da5ae3d&stat=instructions:u) (up to 2.3% on `incr-unchanged` builds of `clap-rs-check`)
- Huge gains in the derive stress benchmark but unfortunately some non-trivial regressions in `clap-rs-check`. This seems to be impacting type checking.

#### Nags requiring follow up

- Waiting on more investigation in [#81476](https://github.com/rust-lang/rust/issues/81476).
- Need to follow up on the regressions reported this week.
