# 2021-12-21 Triage Log

Unfortunately a change introduced in [rust-lang/rust#89836](https://github.com/rust-lang/rust/pull/89836) has made performance across different compiler artifacts much more variable by embedding compiler version information (including a git commit hash) in demangled symbol names. This means that even if two compiler artifacts are built from the same exact source code (with only the git commit changed), the compiler will have slightly different performance characteristics. This makes comparisons across pull requests virtually impossible. 

The compiler team is still deciding what to do to handle this, but in the mean time, performance testing is largely broken. This issue is currently being tracked in[rust-lang/rustc-perf#1126](https://github.com/rust-lang/rustc-perf/issues/1126).

Triage done by **@rylev**.
Revision range: [404c8471aba60c2d837fa728e7c729a0f52d5830..3d57c61a9e04dcd3df633f41142009d6dcad4399](https://perf.rust-lang.org/?start=404c8471aba60c2d837fa728e7c729a0f52d5830&end=3d57c61a9e04dcd3df633f41142009d6dcad4399&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 23 Mixed; 9 of them in rollups
38 comparisons made in total

#### Regressions

Update Clippy [#92036](https://github.com/rust-lang/rust/issues/92036)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2595d038273a4c7746320efd06200764f99bd760&end=34dc0d0f249a33fda18755991b4e73ad786d2b19&stat=instructions:u) (up to 133.5% on `incr-unchanged` builds of `ctfe-stress-4`)
- Largely caused by a [change in how we're doing benchmarking](https://github.com/rust-lang/rustc-perf/pull/1123) that should not impact any other PRs other than this one. 
- Luckily we can generally rely on updating Clippy as having no effect whatsoever on compiler performance.


Rollup of 7 pull requests [#92059](https://github.com/rust-lang/rust/issues/92059)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=dde825db464b08d6f572766579dfb629b837368c&end=208ced64db20bd947a2ba5c90f37936fd3ab352b&stat=instructions:u) (up to 20.0% on `incr-unchanged` builds of `encoding`)


#### Improvements

Rollup of 7 pull requests [#91962](https://github.com/rust-lang/rust/issues/91962)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3ee016ae4d4c6ee4a34faa2eb7fdae2ffa7c9b46&end=c5ecc157043ba413568b09292001a4a74b541a4e&stat=instructions:u) (up to -5.9% on `incr-unchanged` builds of `inflate`)


Rollup of 7 pull requests [#92099](https://github.com/rust-lang/rust/issues/92099)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a41a6925badac7508d7a72cc1fc20f43dc6ad75e&end=41c3017c82bbc16842cc3bc1afa904e6910e293c&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `externs`)


#### Mixed

Stabilize asm! and global_asm! [#91728](https://github.com/rust-lang/rust/issues/91728)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=404c8471aba60c2d837fa728e7c729a0f52d5830&end=2f4da6243f817b26c5c8156408911a01b39f9759&stat=instructions:u) (up to -3.9% on `incr-unchanged` builds of `deep-vector`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=404c8471aba60c2d837fa728e7c729a0f52d5830&end=2f4da6243f817b26c5c8156408911a01b39f9759&stat=instructions:u) (up to 1.4% on `incr-unchanged` builds of `html5ever`)


Rollup of 7 pull requests [#91959](https://github.com/rust-lang/rust/issues/91959)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=df89fd2063aaa060c72c81254db0b930ff379e9a&end=3ee016ae4d4c6ee4a34faa2eb7fdae2ffa7c9b46&stat=instructions:u) (up to -0.5% on `incr-unchanged` builds of `helloworld`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=df89fd2063aaa060c72c81254db0b930ff379e9a&end=3ee016ae4d4c6ee4a34faa2eb7fdae2ffa7c9b46&stat=instructions:u) (up to 6.2% on `incr-unchanged` builds of `inflate`)


extend `simplify_type` [#86986](https://github.com/rust-lang/rust/issues/86986)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c5ecc157043ba413568b09292001a4a74b541a4e&end=69ac533527025fffa37ad1bc4d82b3bc65f90264&stat=instructions:u) (up to -4.7% on `full` builds of `hyper-2`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c5ecc157043ba413568b09292001a4a74b541a4e&end=69ac533527025fffa37ad1bc4d82b3bc65f90264&stat=instructions:u) (up to 8.4% on `incr-patched: sparse set` builds of `regex`)


Include rustc version in `rustc_span::StableCrateId` [#89836](https://github.com/rust-lang/rust/issues/89836)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=69ac533527025fffa37ad1bc4d82b3bc65f90264&end=9e1aff82e696c0edb568656ae6b509a9ab4d6c92&stat=instructions:u) (up to -11.6% on `incr-unchanged` builds of `tuple-stress`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=69ac533527025fffa37ad1bc4d82b3bc65f90264&end=9e1aff82e696c0edb568656ae6b509a9ab4d6c92&stat=instructions:u) (up to 4.7% on `incr-unchanged` builds of `unicode_normalization`)


Optimize `vec::retain` performance  [#91527](https://github.com/rust-lang/rust/issues/91527)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9e1aff82e696c0edb568656ae6b509a9ab4d6c92&end=a090c8659c3be0cbc7dc93c4b2c11a9cdbf8b980&stat=instructions:u) (up to -4.4% on `incr-unchanged` builds of `unicode_normalization`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9e1aff82e696c0edb568656ae6b509a9ab4d6c92&end=a090c8659c3be0cbc7dc93c4b2c11a9cdbf8b980&stat=instructions:u) (up to 4.1% on `incr-patched: println` builds of `regression-31157`)


Rollup of 6 pull requests [#91996](https://github.com/rust-lang/rust/issues/91996)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a090c8659c3be0cbc7dc93c4b2c11a9cdbf8b980&end=f8402169aaa12e7bbb9630796a8caec90a3055ca&stat=instructions:u) (up to -2.4% on `incr-patched: println` builds of `regression-31157`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a090c8659c3be0cbc7dc93c4b2c11a9cdbf8b980&end=f8402169aaa12e7bbb9630796a8caec90a3055ca&stat=instructions:u) (up to 46.9% on `incr-unchanged` builds of `clap-rs`)


rustdoc: don't clone already owned `Path` and modify it inplace [#91833](https://github.com/rust-lang/rust/issues/91833)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f8402169aaa12e7bbb9630796a8caec90a3055ca&end=1d01550f7ea9fce1cf625128fefc73b9da3c1508&stat=instructions:u) (up to -31.9% on `incr-unchanged` builds of `clap-rs`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f8402169aaa12e7bbb9630796a8caec90a3055ca&end=1d01550f7ea9fce1cf625128fefc73b9da3c1508&stat=instructions:u) (up to 4.9% on `incr-patched: println` builds of `regression-31157`)


Fix #91306 by deriving all access from a single *mut T [#91616](https://github.com/rust-lang/rust/issues/91616)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1d01550f7ea9fce1cf625128fefc73b9da3c1508&end=5531927e8af9b99ad923af4c827c91038bca51ee&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `regression-31157`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1d01550f7ea9fce1cf625128fefc73b9da3c1508&end=5531927e8af9b99ad923af4c827c91038bca51ee&stat=instructions:u) (up to 7.3% on `incr-unchanged` builds of `ctfe-stress-4`)


Rollup of 7 pull requests [#92003](https://github.com/rust-lang/rust/issues/92003)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5531927e8af9b99ad923af4c827c91038bca51ee&end=23c2723269e14c3b037feb2c4865a82053403649&stat=instructions:u) (up to -6.8% on `incr-unchanged` builds of `ctfe-stress-4`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5531927e8af9b99ad923af4c827c91038bca51ee&end=23c2723269e14c3b037feb2c4865a82053403649&stat=instructions:u) (up to 13.0% on `incr-unchanged` builds of `tuple-stress`)


Implement normalize_erasing_regions queries in terms of 'try' version [#91672](https://github.com/rust-lang/rust/issues/91672)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=23c2723269e14c3b037feb2c4865a82053403649&end=9b45f04414f3e4006fc2ed3d8e1fa7708efe0e53&stat=instructions:u) (up to -11.6% on `incr-unchanged` builds of `tuple-stress`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=23c2723269e14c3b037feb2c4865a82053403649&end=9b45f04414f3e4006fc2ed3d8e1fa7708efe0e53&stat=instructions:u) (up to 7.4% on `incr-unchanged` builds of `ctfe-stress-4`)


rustdoc: Pretty-print assoc const defaults on-demand [#91812](https://github.com/rust-lang/rust/issues/91812)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9b45f04414f3e4006fc2ed3d8e1fa7708efe0e53&end=16d8a91d511b0e90391bcb20b8c67036071d9392&stat=instructions:u) (up to -6.8% on `incr-unchanged` builds of `ctfe-stress-4`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9b45f04414f3e4006fc2ed3d8e1fa7708efe0e53&end=16d8a91d511b0e90391bcb20b8c67036071d9392&stat=instructions:u) (up to 14.3% on `incr-unchanged` builds of `tuple-stress`)


Update cargo [#92023](https://github.com/rust-lang/rust/issues/92023)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=16d8a91d511b0e90391bcb20b8c67036071d9392&end=2595d038273a4c7746320efd06200764f99bd760&stat=instructions:u) (up to -12.5% on `incr-unchanged` builds of `tuple-stress`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=16d8a91d511b0e90391bcb20b8c67036071d9392&end=2595d038273a4c7746320efd06200764f99bd760&stat=instructions:u) (up to 8.3% on `incr-unchanged` builds of `wg-grammar`)


Do array-slice equality via array equality, rather than always via slices [#91838](https://github.com/rust-lang/rust/issues/91838)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=34dc0d0f249a33fda18755991b4e73ad786d2b19&end=7abab1efb21617ba6845fa86328dffa16cfcf1dc&stat=instructions:u) (up to -1.7% on `full` builds of `piston-image`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=34dc0d0f249a33fda18755991b4e73ad786d2b19&end=7abab1efb21617ba6845fa86328dffa16cfcf1dc&stat=instructions:u) (up to 1.7% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)


Rollup of 7 pull requests [#92062](https://github.com/rust-lang/rust/issues/92062)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=208ced64db20bd947a2ba5c90f37936fd3ab352b&end=d3f300477b89e70dd42379ba53c0e8ff74e9c694&stat=instructions:u) (up to -4.7% on `incr-patched: println` builds of `regression-31157`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=208ced64db20bd947a2ba5c90f37936fd3ab352b&end=d3f300477b89e70dd42379ba53c0e8ff74e9c694&stat=instructions:u) (up to 1.0% on `full` builds of `webrender`)


Rollup of 7 pull requests [#92064](https://github.com/rust-lang/rust/issues/92064)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d3f300477b89e70dd42379ba53c0e8ff74e9c694&end=d3848cb659105d8384c00ba384ec2f6f39c47238&stat=instructions:u) (up to -1.2% on `full` builds of `keccak`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d3f300477b89e70dd42379ba53c0e8ff74e9c694&end=d3848cb659105d8384c00ba384ec2f6f39c47238&stat=instructions:u) (up to 3.5% on `incr-patched: println` builds of `regression-31157`)


Avoid sorting in hash map stable hashing [#91837](https://github.com/rust-lang/rust/issues/91837)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=91a0600a5c22b9d159e3c57526af83e71d1120f8&end=daf2204aa4954a9426cee93eb1baa2b26eb69070&stat=instructions:u) (up to -4.9% on `incr-full` builds of `clap-rs`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=91a0600a5c22b9d159e3c57526af83e71d1120f8&end=daf2204aa4954a9426cee93eb1baa2b26eb69070&stat=instructions:u) (up to 2.8% on `incr-patched: println` builds of `regression-31157`)


rustdoc: Add `UrlPartsBuilder` [#91871](https://github.com/rust-lang/rust/issues/91871)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d6cffe41b59feaab5fb92bb320e60586202c9950&end=8f540619007c1aa62dfc915409d881f52f21dc84&stat=instructions:u) (up to -3.6% on `incr-patched: println` builds of `regression-31157`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d6cffe41b59feaab5fb92bb320e60586202c9950&end=8f540619007c1aa62dfc915409d881f52f21dc84&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)


Remove `SymbolStr` [#91957](https://github.com/rust-lang/rust/issues/91957)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8f540619007c1aa62dfc915409d881f52f21dc84&end=a41a6925badac7508d7a72cc1fc20f43dc6ad75e&stat=instructions:u) (up to -0.2% on `full` builds of `externs`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=8f540619007c1aa62dfc915409d881f52f21dc84&end=a41a6925badac7508d7a72cc1fc20f43dc6ad75e&stat=instructions:u) (up to 3.1% on `incr-patched: println` builds of `regression-31157`)


Rollup of 4 pull requests [#92106](https://github.com/rust-lang/rust/issues/92106)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=41c3017c82bbc16842cc3bc1afa904e6910e293c&end=e95e084a14870a718c712936ab5a8f8cd0159485&stat=instructions:u) (up to -0.3% on `incr-unchanged` builds of `helloworld`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=41c3017c82bbc16842cc3bc1afa904e6910e293c&end=e95e084a14870a718c712936ab5a8f8cd0159485&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `externs`)


Eliminate `ObligationCauseData` [#91844](https://github.com/rust-lang/rust/issues/91844)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e95e084a14870a718c712936ab5a8f8cd0159485&end=ed7a2068432b62880bca89cd69546682a2e192cd&stat=instructions:u) (up to -0.9% on `full` builds of `coercions`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e95e084a14870a718c712936ab5a8f8cd0159485&end=ed7a2068432b62880bca89cd69546682a2e192cd&stat=instructions:u) (up to 0.9% on `full` builds of `wg-grammar`)


rustdoc: make `--passes` and `--no-defaults` have no effect [#91900](https://github.com/rust-lang/rust/issues/91900)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ed7a2068432b62880bca89cd69546682a2e192cd&end=940a97a91023d1817b33d0ababc985793c9ed780&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `externs`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ed7a2068432b62880bca89cd69546682a2e192cd&end=940a97a91023d1817b33d0ababc985793c9ed780&stat=instructions:u) (up to 1.1% on `incr-patched: println` builds of `regression-31157`)


Remove 'speculative evaluation' of predicates [#92041](https://github.com/rust-lang/rust/issues/92041)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=940a97a91023d1817b33d0ababc985793c9ed780&end=60f3bd78eeac87ad474916d36d29ed7e5084b25b&stat=instructions:u) (up to -5.8% on `incr-unchanged` builds of `regression-31157`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=940a97a91023d1817b33d0ababc985793c9ed780&end=60f3bd78eeac87ad474916d36d29ed7e5084b25b&stat=instructions:u) (up to 8.8% on `incr-unchanged` builds of `deeply-nested`)


Fully serialize AdtDef [#91924](https://github.com/rust-lang/rust/issues/91924)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=60f3bd78eeac87ad474916d36d29ed7e5084b25b&end=84f962a89bac3948ed116f1ad04c2f4793fb69ea&stat=instructions:u) (up to -25.0% on `incr-unchanged` builds of `issue-46449`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=60f3bd78eeac87ad474916d36d29ed7e5084b25b&end=84f962a89bac3948ed116f1ad04c2f4793fb69ea&stat=instructions:u) (up to 15.8% on `incr-full` builds of `webrender-wrench`)


#### Untriaged Pull Requests

- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92059 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92059)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92003 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92003)
- [#91996 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91996)
- [#91959 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91959)
- [#91924 Fully serialize AdtDef](https://github.com/rust-lang/rust/pull/91924)
- [#91844 Eliminate `ObligationCauseData`](https://github.com/rust-lang/rust/pull/91844)
- [#91841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/91841)
- [#91838 Do array-slice equality via array equality, rather than always via slices](https://github.com/rust-lang/rust/pull/91838)
- [#91812 rustdoc: Pretty-print assoc const defaults on-demand](https://github.com/rust-lang/rust/pull/91812)
- [#91799 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91799)
- [#91766 Allow `memcmp` for more array comparisons](https://github.com/rust-lang/rust/pull/91766)
- [#91616 Fix #91306 by deriving all access from a single *mut T](https://github.com/rust-lang/rust/pull/91616)
- [#91527 Optimize `vec::retain` performance ](https://github.com/rust-lang/rust/pull/91527)
- [#91406 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/91406)
- [#91354 Cleanup: Eliminate ConstnessAnd](https://github.com/rust-lang/rust/pull/91354)
- [#91318 Reduce boilerplate around infallible folders](https://github.com/rust-lang/rust/pull/91318)
- [#91288 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91288)
- [#91269 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91269)
- [#91255 Implement version of normalize_erasing_regions that allows for normalization failure](https://github.com/rust-lang/rust/pull/91255)

