# 2023-09-05 Triage Log

A lot of spurious noise this week from a few benchmarks (bitmaps-3.1.0, libc,
and even cargo-0.60.0 at a few points). Beyond that, we had a few small
improvements associated with the trait system and with parallel-rustc.

Triage done by **@pnkfelix**.
Revision range: [cedbe5c7..15e52b05](https://perf.rust-lang.org/?start=cedbe5c715c1fa9359683c5f108bed2054ac258b&end=15e52b05ca8f63e0da27c808680388717e5b997e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 1.2%]    | 11    |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 2.0%]    | 40    |
| Improvements ✅ <br /> (primary)   | -1.9% | [-10.2%, -0.3%] | 69    |
| Improvements ✅ <br /> (secondary) | -1.5% | [-3.7%, -0.4%]  | 26    |
| All ❌✅ (primary)                 | -1.5% | [-10.2%, 1.2%]  | 80    |


4 Regressions, 7 Improvements, 8 Mixed; 2 of them in rollups
66 artifact comparisons made in total

#### Regressions

Adapt table sizes to the contents, accommodating u64 rmeta offsets [#113542](https://github.com/rust-lang/rust/pull/113542) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6e8f677c6a20bee7025f6c0a93a7dc9daced92bc&end=d64c84562f634efde5eb5506942b6af293d8358d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.2%, 1.2%] | 11    |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.2%, 1.3%] | 26    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.2%, 1.2%] | 11    |

* already marked as triaged.

Use conditional synchronization for Lock [#111713](https://github.com/rust-lang/rust/pull/111713) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7659abc63d33223fa366c8781c81698e28a21e6c&end=61efe9d2981b87ec7f2800d62f98c594de151713&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.3% | [2.3%, 2.3%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.3% | [2.3%, 2.3%] | 1     |

* the measured regression appears spurious
* marked as triaged

update Miri [#115496](https://github.com/rust-lang/rust/pull/115496) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7cc5ac267f536ee2cf2f38961d9db8304a419d5a&end=b89d7d6882532686fd90a89cec1a0fd386f0ade3&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.6%] | 5     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 4     |

* believe to be spurious, marking as triaged


Rollup of 5 pull requests [#115553](https://github.com/rust-lang/rust/pull/115553) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=626a6ab93fafd01b37b1e26c96cb6eec0d39f3eb&end=8cfaf70c320297dd1831a12351fcfeab7a231328&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.8%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.8%] | 6     |

* believe to be spurious, marking as triaged

#### Improvements

Don't record spans for predicates in coherence [#115392](https://github.com/rust-lang/rust/pull/115392) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b1b244da6527cf2ba36e88d02275f4c64a0c90d8&end=e51c5ea16f84ef811bf0aecbdc0ac48821d52cc9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-2.5%, -0.3%] | 18    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.0%, -0.2%] | 8     |
| All ❌✅ (primary)                 | -1.1% | [-2.5%, -0.3%] | 18    |

* undoes regression introduced by [PR 115392](https://github.com/rust-lang/rust/pull/115392)

Use `OnceLock` for `SingleCache` [#115422](https://github.com/rust-lang/rust/pull/115422) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f9ba43ce147707fb90d038983789d8e57451eb6d&end=9dc11a13fa848c1b09b7248c540528190dcb79c5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 2     |


Fall through when resolving elided assoc const lifetimes [#115429](https://github.com/rust-lang/rust/pull/115429) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=585bb5e68d85c1e4f32da3e2499343372626a436&end=9229b1eab44046253971445be47423ef779b178f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.5%, -0.6%] | 7     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.0% | [-1.5%, -0.6%] | 7     |


Don't manually compute param indices when adding implicit `Sized` and `ConstParamHasTy` [#115361](https://github.com/rust-lang/rust/pull/115361) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b89d7d6882532686fd90a89cec1a0fd386f0ade3&end=53a03978a7402d20ce8254fa1493929d67e01d07&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 2     |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 5     |


Encode DepKind as u16 [#115391](https://github.com/rust-lang/rust/pull/115391) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=abfc6c44381fb033c6b3b0a6bfb804a799f39afd&end=b14b0745ad4913a21f00795738c047d0107dff4a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 5     |


Move RawOsError defination to sys [#115493](https://github.com/rust-lang/rust/pull/115493) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b14b0745ad4913a21f00795738c047d0107dff4a&end=ce798a52c30528366764a5993783b4e9ccfa46ee&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-0.6%, -0.6%] | 3     |

* (I suspect this is spurious)

read_via_copy: don't prematurely optimize away the read [#115531](https://github.com/rust-lang/rust/pull/115531) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c609ae158aab27f1e7df446de6f2c09414012a9&end=626a6ab93fafd01b37b1e26c96cb6eec0d39f3eb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.7%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.7%] | 5     |

* (I suspect this is spurious)

#### Mixed

interpret: fix projecting into an unsized field of a local [#114483](https://github.com/rust-lang/rust/pull/114483) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=61efe9d2981b87ec7f2800d62f98c594de151713&end=26089ba0a2d9dab8381ccb0d7b99e704bc5cb3ed&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [1.9%, 2.1%]   | 6     |
| Improvements ✅ <br /> (primary)   | -2.2% | [-2.2%, -2.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 3     |
| All ❌✅ (primary)                 | -2.2% | [-2.2%, -2.2%] | 1     |

* Ralf notes: "Regressions only affect our ctfe stress test, so it's likely some exaggerated consequence of a tiny change."
* marked as triaged

Lower `Or` pattern without allocating place [#111752](https://github.com/rust-lang/rust/pull/111752) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d6b4d35d5e94f6a1577e0e645fb23afc84615a6c&end=f4555ef5e14e8f0630fc5ad4e8efaef56d4acd4b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.5%, 1.6%]   | 21    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.7%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-3.7%, 1.0%]  | 18    |

* nnethercote notes: "Performance-wise, icounts/cycles/wall-times have a mix of wins and losses that more or less balance out. But binary size has lots of wins, which is nice."
* marked as triaged

Skip rendering metadata strings from include_str!/include_bytes! [#115286](https://github.com/rust-lang/rust/pull/115286) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9dc11a13fa848c1b09b7248c540528190dcb79c5&end=1fb6947abc68683db05f837f07531a2f7d7ed8b3&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.7%]    | 6     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-10.3%, -0.3%] | 28    |
| Improvements ✅ <br /> (secondary) | -2.6% | [-3.7%, -1.7%]  | 9     |
| All ❌✅ (primary)                 | -2.8% | [-10.3%, 0.3%]  | 29    |

* saethlin notes: "Regressions look like recovery from a spurious improvement in the previous run, and are way less significant than the improvements."
* already marked as triaged

bootstrap: use git merge-base for LLVM CI download logic [#115409](https://github.com/rust-lang/rust/pull/115409) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ad8f601ca2ba6186de6e1b2b5f46f47e18013961&end=585bb5e68d85c1e4f32da3e2499343372626a436&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.6%, 1.5%]   | 7     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.8%  | [-0.4%, 1.5%]  | 8     |


* this is a collection of spurious regressions to bitmaps-3.1.0
    * see e.g. [this graph](https://perf.rust-lang.org/index.html?start=2023-08-31&end=2023-09-05&benchmark=bitmaps-3.1.0&profile=check&scenario=full&stat=instructions%3Au&kind=raw) and note the blip.
* marked as triaged

Add note on non-exhaustiveness when matching on str and nested non-exhaustive enums [#115270](https://github.com/rust-lang/rust/pull/115270) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2a1af898b2cb535a45cefe67acf9d023eff16b27&end=21305f4d5f32bcbc97f3b8e66dc23b03f3d948c4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.8%, 1.4%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | 1.1%  | [0.8%, 1.4%]   | 6     |

* seems like continued spurious noise on bitmaps-3.1.0
* marked as triaged

Rollup of 5 pull requests [#115518](https://github.com/rust-lang/rust/pull/115518) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=21305f4d5f32bcbc97f3b8e66dc23b03f3d948c4&end=58e967a9cc3bd39122e8cb728e8cec6e3a4eeef2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 7.1%  | [0.7%, 13.6%]  | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.5%, -0.7%] | 7     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.8%  | [-1.5%, 13.6%] | 9     |

* 13.6% regression to cargo-0.60.0 seems spurious (!), since it immediately returned to normal in #115491
* marked as triaged

Outline panicking code for `RefCell::borrow` and `RefCell::borrow_mut` [#115491](https://github.com/rust-lang/rust/pull/115491) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=58e967a9cc3bd39122e8cb728e8cec6e3a4eeef2&end=abfc6c44381fb033c6b3b0a6bfb804a799f39afd&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.6%, 1.5%]    | 8     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -6.3% | [-12.0%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.5%]  | 4     |
| All ❌✅ (primary)                 | -0.4% | [-12.0%, 1.5%]  | 10    |

* as lqd notes: "bitmaps and cargo opt incr-unchanged kinda look noisy atm"
* marked as triaged

Do not require associated types with Self: Sized to uphold bounds when confirming object candidate [#115467](https://github.com/rust-lang/rust/pull/115467) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=04374cd74264b9d3b7d2d3df08ae38df8af4d020&end=9c609ae158aab27f1e7df446de6f2c09414012a9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.2%, -0.8%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-1.2%, 0.6%]  | 7     |

* all these changes (for better or for worse) look like yet more spurious noise.
* marked as triaged
