# 2025-03-11 Triage Log

This week we had to merge a lot of large rollups due to many problems with our CI infrastructure,
which made analysis harder. Even though the aggregated stats look like there were a lot of regressions,
it is skewed by two large regressions happening on an uncommon optimized incremental build and a
documentation build of a single crate. The documentation regression is being tracked, and fixes to
some other regressions are already in progress.

Triage done by **@kobzol**.
Revision range: [daf59857..9fb94b32](https://perf.rust-lang.org/?start=daf59857d6d2b87af4b846316bf1561a6083ed51&end=9fb94b32df38073bf63d009df77ed10cb1c989d0&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.2%, 58.8%]   | 149   |
| Regressions ❌ <br /> (secondary)  | 4.2%  | [0.2%, 165.8%]  | 127   |
| Improvements ✅ <br /> (primary)   | -1.1% | [-14.0%, -0.3%] | 31    |
| Improvements ✅ <br /> (secondary) | -2.9% | [-38.4%, -0.1%] | 43    |
| All ❌✅ (primary)                 | 0.8%  | [-14.0%, 58.8%] | 180   |


2 Regressions, 2 Improvements, 5 Mixed; 4 of them in rollups
37 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#138021](https://github.com/rust-lang/rust/pull/138021) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=08db600e8e276b548e986abe7239c2a85d2f425f&end=ac951d379913c667a1fb73a0830e81d65d2007cf&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.2%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 1     |

- Tiny doc regressions on the smallest benchmarks, probably caused by [#137722](https://github.com/rust-lang/rust/pull/137722). I don't think we need to investigate more here.
- Marked as triaged.

Rollup of 12 pull requests [#138267](https://github.com/rust-lang/rust/pull/138267) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4f521991945886709a875ba2aeaa859574126c0e&end=ed897d5f85d61d56a7d52b180e34c8ca62b59e30&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.1%, 1.6%]  | 105   |
| Regressions ❌ <br /> (secondary)  | 3.5% | [0.1%, 12.5%] | 94    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.1%, 1.6%]  | 105   |

- The regression was caused by [#136127](https://github.com/rust-lang/rust/pull/136127).
- A fix is in progress in [#138292](https://github.com/rust-lang/rust/pull/138292).
- Not marking as triaged yet.

#### Improvements

Change TaskDeps to start preallocated with 128 capacity [#137563](https://github.com/rust-lang/rust/pull/137563) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a96fa317d78c78a9de996afd317603c6970efc0d&end=4f521991945886709a875ba2aeaa859574126c0e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.8%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-0.8%, -0.5%] | 6     |


Split the `Edges` iterator. [#137655](https://github.com/rust-lang/rust/pull/137655) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ed897d5f85d61d56a7d52b180e34c8ca62b59e30&end=385970f0c1fd0c09bac426b02f38300c0b1ba9a2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.1% | [-5.6%, -4.8%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Rollup of 20 pull requests [#138058](https://github.com/rust-lang/rust/pull/138058) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4559163ccb500affc424fb9228dae5003672ffc7&end=07b5eeebc948743eaadb32a83d23931fd8854fe8&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 1.6%]    | 29    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.0%]    | 16    |
| Improvements ✅ <br /> (primary)   | -1.7% | [-13.7%, -0.1%] | 11    |
| Improvements ✅ <br /> (secondary) | -7.8% | [-38.3%, -0.3%] | 10    |
| All ❌✅ (primary)                 | -0.0% | [-13.7%, 1.6%]  | 40    |

- Most of the perf. changes were likely caused by [#137298](https://github.com/rust-lang/rust/pull/137298). The wins and losses kind of balanced themselves.
- Marked as triaged.

Inline `FnOnce`/`FnMut`/`Fn` shims once again [#137907](https://github.com/rust-lang/rust/pull/137907) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07b5eeebc948743eaadb32a83d23931fd8854fe8&end=30f168ef811aec63124eac677e14699baa9395bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 13.6% | [0.4%, 59.2%]  | 5     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.4%, 1.9%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.1%] | 25    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-3.4%, -0.1%] | 41    |
| All ❌✅ (primary)                 | 2.0%  | [-0.9%, 59.2%] | 30    |

- Overall there are more wins than regressions, and this change should help optimizations. The single large regression is unlucky CGU scheduling on an optimized incremental build, which is not very common.
- Marked as triaged.

Rollup of 25 pull requests [#138114](https://github.com/rust-lang/rust/pull/138114) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b74da9613a8cb5ba67a985f71325be0b7b16c0dd&end=98a48781feb1220c0cf2feea23f9ef92cdfa7437&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 42.1% | [0.2%, 167.8%] | 4     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -     | -              | 0     |

- The large regression in rustdoc was caused by [#137534](https://github.com/rust-lang/rust/pull/137534). The regression hasn't been fixed yet, it is being tracked in [#138168](https://github.com/rust-lang/rust/issues/138168).
- Not marking as triaged yet.

Use `trunc nuw`+`br` for 0/1 branches even in optimized builds [#137500](https://github.com/rust-lang/rust/pull/137500) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=07292ccccde8b64d87036b2f90b70bc54ab68456&end=efea9896f506baa08f40444e07774e827646d57a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.8%]   | 37    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 1.2%]   | 61    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.9%, -0.3%] | 5     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.4%, -0.4%] | 4     |
| All ❌✅ (primary)                 | 0.2%  | [-0.9%, 0.8%]  | 42    |

- The regressions were expected and deemed acceptable, this should help optimizations.
- Marked as triaged.

Always inline `query_get_at`. [#137695](https://github.com/rust-lang/rust/pull/137695) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3ea711f17e3946ac3f4df11691584e2c56b4b0cf&end=2b4694a69804f89ff9d47d1a427f72c876f7f44c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 1.5%]   | 9     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.4%, -0.2%] | 61    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.5%, -0.2%] | 56    |
| All ❌✅ (primary)                 | -0.5% | [-1.4%, 0.3%]  | 63    |

- Many more wins than regressions.
- Marked as triaged.
