A literal was used in a built-in attribute that doesn't support literals.

Erroneous code example:

```compile_fail,E0565
#[repr("C")] // error: meta item in `repr` must be an identifier
struct Repr {}

fn main() {}
```

Not all attributes support literals in their input,
and in some cases they expect an identifier instead.
That would be the solution in the case of `repr`:
```
#[repr(C)] // ok!
struct Repr {}

fn main() {}
```
