# 2023-06-27 Triage Log

Relatively quiet week outside of a large win on one incremental benchmark in a
regression test (i.e., not real world code). Bimodality in a number of
benchmarks continues to be an issue.

Triage done by **@simulacrum**.
Revision range: [b9d608c979ad3c0700f9f0237a8c12feb0ba44fb..b5e51db16dfbf5685e32dfe2d9a835a5c695afe4](https://perf.rust-lang.org/?start=b9d608c979ad3c0700f9f0237a8c12feb0ba44fb&end=b5e51db16dfbf5685e32dfe2d9a835a5c695afe4&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%   | [0.4%, 3.7%]    | 186   |
| Regressions ❌ <br /> (secondary)  | 1.1%   | [0.2%, 3.0%]    | 95    |
| Improvements ✅ <br /> (primary)   | -1.9%  | [-3.7%, -0.9%]  | 3     |
| Improvements ✅ <br /> (secondary) | -16.1% | [-78.8%, -0.3%] | 5     |
| All ❌✅ (primary)                 | 0.9%   | [-3.7%, 3.7%]   | 189   |


5 Regressions, 6 Improvements, 3 Mixed; 5 of them in rollups
44 artifact comparisons made in total

#### Regressions

proof tree nits [#112835](https://github.com/rust-lang/rust/pull/112835) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a34ceade11f62bdef20b86ef37949d3fe00944ef&end=46514218f6f31ad3a1510ecc32af47e9e486c27d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 0.9%] | 7     |
| Regressions ❌ <br /> (secondary)  | 1.2% | [0.5%, 1.7%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 0.9%] | 7     |

The regression in diesel seems to have persisted in future commits, but PR
authors note that the code changed in this PR is not expected to affect
benchmarks, so it is likely to be optimizer noise of some kind.

Disable two mir opts that are known to be unsound [#112834](https://github.com/rust-lang/rust/pull/112834) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=97bf23d26b1ffff46f071aa687945a6cf85a5914&end=38b44eb2335885844137f918c44c437f5a8da951&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.9%]   | 48    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 1.1%]   | 30    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.4%  | [0.3%, 0.9%]   | 48    |

Regression on multiple benchmarks, seems to be real, likely to be expected with
disabling of optimization passes.

Inline before merging cgus [#112695](https://github.com/rust-lang/rust/pull/112695) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0928a1f7574f5ca019b5443b3a90008588d18c8c&end=fa06a371b715f137c952577cfded4e49cb7e76c4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 3.6%]   | 98    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 2.7%]   | 37    |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.2%, -0.9%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [-1.2%, 3.6%]  | 100   |

Instruction counts (shown in this table) are not the best metric for this
change. See [comment](https://github.com/rust-lang/rust/pull/112695#issuecomment-1603381738)
on the PR with more details for why this change makes sense.

Rollup of 9 pull requests [#112957](https://github.com/rust-lang/rust/pull/112957) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fe37f37e4b764bb82fc0eb8c727842746de7c93f&end=54d6738a8df74382c439e1dfb9ce4e2382d7742e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.4%, 0.4%] | 4     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 8     |

Regressions are limited to subset of incremental benchmarks, multiple of which
are benchmarks prone to bimodality, with relatively low significance factors.
No further investigation warranted.

Rollup of 2 pull requests [#113057](https://github.com/rust-lang/rust/pull/113057) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6f8c27ae89dfd32895419d7ef5b89844bcad1bcd&end=36fb58e433c782e27dd41034284e157cf86d587f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.4%, 0.8%] | 5     |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.3%, 1.1%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.4%, 0.8%] | 5     |

See [comment](https://github.com/rust-lang/rust/pull/113057#issuecomment-1608561630) for details.

#### Improvements

Avoid `Lrc<Box<dyn CodegenBackend>>`. [#112913](https://github.com/rust-lang/rust/pull/112913) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fa06a371b715f137c952577cfded4e49cb7e76c4&end=2efe09170530fa18e42ff05b8d9dd23f00b5c430&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |


rustc_session: default to -Z plt=yes on non-x86_64 [#109982](https://github.com/rust-lang/rust/pull/109982) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=54d6738a8df74382c439e1dfb9ce4e2382d7742e&end=c79d6be6a287dcda55236fa6438286d16ec990ae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 5     |


Rollup of 5 pull requests [#113014](https://github.com/rust-lang/rust/pull/113014) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f7ca9df69549470541fbf542f87a03eb9ed024b6&end=7b9b1277009c407010298bd2f195f83af31fd06b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.2%, -0.4%] | 39    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.9%, -0.3%] | 20    |
| All ❌✅ (primary)                 | -0.7% | [-1.2%, -0.4%] | 39    |


Do not emit coerce_suggestions for expr from destructuring assignment desugaring [#112476](https://github.com/rust-lang/rust/pull/112476) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7b9b1277009c407010298bd2f195f83af31fd06b&end=3c5d71a99dd5ece7f6c87ca80b0adb1637c3b11a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.8%, -0.5%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.1%, -1.0%] | 4     |
| All ❌✅ (primary)                 | -0.6% | [-0.8%, -0.5%] | 6     |


Move windows-sys arm32 shim to c.rs [#113001](https://github.com/rust-lang/rust/pull/113001) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0d03812e2424b324d067d89852ad925d2eecb53e&end=c51fbb3dd3a75fd43d51c0c29ca645c3dac99aae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.3%, -1.1%] | 6     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.7%] | 1     |


Rollup of 6 pull requests [#113049](https://github.com/rust-lang/rust/pull/113049) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=25b5af1b3a0b9e2c0c57b223b2d0e3e203869b2c&end=27e10c5292eee22abef69aed7144f80bdea00603&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.2%, -0.5%] | 17    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.8% | [-1.2%, -0.5%] | 17    |


#### Mixed

Rollup of 6 pull requests [#112877](https://github.com/rust-lang/rust/pull/112877) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67da586efe13aa66eef576ba095e1875ba65fd20&end=97bf23d26b1ffff46f071aa687945a6cf85a5914&stat=instructions:u)

| (instructions:u)                   | mean   | range            | count |
|:----------------------------------:|:------:|:----------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%   | [0.4%, 0.4%]     | 4     |
| Regressions ❌ <br /> (secondary)  | 0.2%   | [0.2%, 0.2%]     | 2     |
| Improvements ✅ <br /> (primary)   | -2.9%  | [-2.9%, -2.9%]   | 1     |
| Improvements ✅ <br /> (secondary) | -78.9% | [-78.9%, -78.9%] | 1     |
| All ❌✅ (primary)                 | -0.3%  | [-2.9%, 0.4%]    | 5     |


Various impl trait in assoc tys cleanups [#112891](https://github.com/rust-lang/rust/pull/112891) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=22e9fe644ea710eec50cb0aabcae7fa8dd9fd675&end=1d67eba6873b1d551a259a0bbc1e2651b4443e12&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.6%, 0.7%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.4%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.3%, -0.6%] | 8     |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, 0.3%]  | 7     |

Performance is mixed, but the cleanups are useful in their own right.  Marking
as triaged.

Specialize `StepBy<Range<{integer}>>` [#111850](https://github.com/rust-lang/rust/pull/111850) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7f01f030613fb6ffe06d5f5791a273d384cd6f55&end=ae8ffa663c913551c462fd2e07705be730a4ea07&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.5%, 0.7%]   | 3     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-2.1%, -1.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 6     |
| All ❌✅ (primary)                 | -1.7% | [-2.1%, -1.4%] | 2     |
