[![Code Testing](https://github.com/scikit-rf/scikit-rf/workflows/Code%20linting%20and%20testing/badge.svg)](https://github.com/scikit-rf/scikit-rf/actions?query=workflow%3A%22Code+linting+and+testing%22)
[![Documentation Status](https://readthedocs.org/projects/scikit-rf/badge/?version=latest)](https://readthedocs.org/projects/scikit-rf/?badge=latest)
[![Coverage Status](https://coveralls.io/repos/scikit-rf/scikit-rf/badge.png)](https://coveralls.io/r/scikit-rf/scikit-rf)
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](./LICENSE.md)

![PyPI - Downloads](https://img.shields.io/pypi/dm/scikit-rf)
[![Conda Downloads](https://anaconda.org/conda-forge/scikit-rf/badges/downloads.svg)](https://anaconda.org/conda-forge/scikit-rf)

## Description

![scikit-rf_logo](doc/source/_static/scikit-rf-title-flat.png)

**scikit-rf** (aka `skrf`) is an Open Source, BSD-licensed package for RF/Microwave engineering implemented
in the Python programming language. It provides a modern, object-oriented library which is both
flexible and scalable.

* [Home Page](http://www.scikit-rf.org)
* [Documentation](http://scikit-rf.readthedocs.org/)

## Install

[![PyPI version](https://img.shields.io/pypi/v/scikit-rf?style=flat&logo=pypi)](https://pypi.org/project/scikit-rf/)
[![Conda-forge version](https://img.shields.io/conda/v/conda-forge/scikit-rf?style=flat&logo=anaconda)](https://img.shields.io/conda/v/conda-forge/scikit-rf)
[![Conda version](https://anaconda.org/conda-forge/scikit-rf/badges/latest_release_date.svg)](https://anaconda.org/conda-forge/scikit-rf)

If you have [installed Python](https://wiki.python.org/moin/BeginnersGuide/Download), you can install scikit-rf from [pip](https://pypi.org/project/pip/) via
```Shell
python -m pip install scikit-rf
```

If you have [installed conda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html), then you can also get scikit-rf from
```Shell
conda install -c conda-forge scikit-rf
```

**scikit-rf** includes standalone gui applications which can be installed and used like this
```Shell
# Install the additional dependencies for the gui applications
python -m pip install scikit-rf[plot,visa]
# Run the apps
data-grabber # Run the data-grabber application
multiline-trl # Run the multiline-trl application
```

## Questions or comments? Ask the Community

[![Slack](https://img.shields.io/badge/Slack-join%20chat-blueviolet?style=flat&logo=slack)](https://join.slack.com/t/scikit-rf/shared_invite/zt-d82b62wg-0bdSJjZVhHBKf6687V80Jg)
[![Matrix](https://img.shields.io/badge/Matrix-join%20chat-blueviolet?style=flat&logo=matrix)](https://app.element.io/#/room/#scikit-rf:matrix.org)
[![LinkedIn](https://img.shields.io/badge/LinkedIn_scikit_rf_group-orange?style=flat)](https://www.linkedin.com/groups/12462155/)

* [LinkedIn scikit-rf Users Group](https://www.linkedin.com/groups/12462155/): User group to ask and answer questions and to received scikit-rf announcements.
* Chat: scikit-rf have channels on both [Slack](https://join.slack.com/t/scikit-rf/shared_invite/zt-d82b62wg-0bdSJjZVhHBKf6687V80Jg) and [Matrix](https://app.element.io/#/room/#scikit-rf:matrix.org)
* [Suggestion box](https://docs.google.com/forms/d/e/1FAIpQLSfkSNy8KzoHwdDxYGCmHHiA3GsHgN6zKTFI2NrcUR29U7Xx6A/viewform?usp=sf_link): if you would like to suggest a feature/topic for consideration (optionally anonymous).

## Contributing to the scikit-rf project

There is multiple ways to contribute to an open-source project like scikit-rf!

* [Sponsoring the project](https://scikit-rf.readthedocs.io/en/latest/contributing/index.html#sponsoring-the-project)
* [Contributing to the code](https://scikit-rf.readthedocs.io/en/latest/contributing/index.html#contributing-to-the-code)
* [Contributing to the Documentation](https://scikit-rf.readthedocs.io/en/latest/contributing/index.html#contributing-to-the-documentation)
* [Getting some merchandise to express your love](https://scikit-rf.org/merch.html)

![skrfshirt](https://raw.githubusercontent.com/scikit-rf/scikit-rf/master/logo/skrfshirtwhite.png)

## Authors
The list of the developers of scikit-rf is available on the [contributors page](https://github.com/scikit-rf/scikit-rf/graphs/contributors/).

## License

scikit-rf is permissively licensed under a [3-clause BSD license](LICENSE.txt).
