use test;
use parser;

Str check(Result<Array<Str>> r) {
	if (x = r.value) {
		x.toS;
	} else if (e = r.error) {
		"Error at ${e.pos}, ${e.message}";
	} else {
		"<invalid>";
	}
}

Str check(Result<Str> r) {
	if (x = r.value) {
		x;
	} else if (e = r.error) {
		"Error at ${e.pos}, ${e.message}";
	} else {
		"<invalid>";
	}
}

Str check(Result<Maybe<Str>> r) {
	if (x = r.value) {
		x.toS;
	} else if (e = r.error) {
		"Error at ${e.pos}, ${e.message}";
	} else {
		"<invalid>";
	}
}

parseList : parser(recursive descent) {
	start = List;
}

test SimpleRecursive {
	// TODO: Test with true/false in them, so we can skip "== true".
	check check(parseList("A, B, C")) == "[A, B, C]";

	Str x = ",A, B, C";
	check check(parseList(x, x.begin + 1)) == "[A, B, C]";
}

parseRepList : parser(recursive descent) {
	start = RepList;
}

test RepRecursive {
	check check(parseRepList("[A, B,]")) == "[A, B]";
	check check(parseRepList("{A, B,}")) == "[A, B]";
	check check(parseRepList("[]")) == "[]";
	check check(parseRepList("{}")) == "Error at Iterator: {|>}, Expected one of:\n\"[A-Z]+\"";
}

parseOptional : parser(recursive descent) {
	start = Optional;
}

test OptionalRecursive {
	check check(parseOptional("=")) == "null";
	check check(parseOptional("=ZA")) == "ZA";
}

parseCapture : parser(recursive descent) {
	start = Capture;
}

test CaptureRecursive {
	check check(parseCapture("[A,   C]")) == "A,   C";
	check check(parseCapture("zA,  D")) == "A,  D";
}
