% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_depletion_test.R
\name{enrichment_depletion_test}
\alias{enrichment_depletion_test}
\title{Test for enrichment or depletion of mutations in genomic regions}
\usage{
enrichment_depletion_test(x, by = NA, p_cutoffs = 0.05, fdr_cutoffs = 0.1)
}
\arguments{
\item{x}{data.frame result from genomic_distribution()}

\item{by}{Optional grouping variable, e.g. tissue type}

\item{p_cutoffs}{Significance cutoff for the p value. Default: 0.05}

\item{fdr_cutoffs}{Significance cutoff for the fdr. Default: 0.1}
}
\value{
data.frame with the observed and expected number of mutations per
genomic region per group (by) or sample
}
\description{
This function aggregates mutations per group (optional) and performs an
enrichment depletion test.
}
\examples{
## See the 'genomic_distribution()' example for how we obtained the
## following data:
distr <- readRDS(system.file("states/distr_data.rds",
  package = "MutationalPatterns"
))

tissue <- c(rep("colon", 3), rep("intestine", 3), rep("liver", 3))

## Perform the enrichment/depletion test by tissue type.
distr_test <- enrichment_depletion_test(distr, by = tissue)

## Or without specifying the 'by' parameter, to pool all samples.
distr_single_sample <- enrichment_depletion_test(distr)

## Use different significance cutoffs for the pvalue and fdr
distr_strict <- enrichment_depletion_test(distr,
  by = tissue,
  p_cutoffs = 0.01, fdr_cutoffs = 0.05
)

## Use multiple (max 3) significance cutoffs.
## This will vary the number of significance stars.
distr_multistars <- enrichment_depletion_test(distr,
  by = tissue,
  p_cutoffs = c(0.05, 0.01, 0.005),
  fdr_cutoffs = c(0.1, 0.05, 0.01)
)
}
\seealso{
\code{\link{genomic_distribution}},
\code{\link{plot_enrichment_depletion}}
}
