% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_heteroscedasticity.R
\name{check_heteroscedasticity}
\alias{check_heteroscedasticity}
\alias{check_heteroskedasticity}
\title{Check model for (non-)constant error variance}
\usage{
check_heteroscedasticity(x, ...)

check_heteroskedasticity(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}
}
\value{
The p-value of the test statistics. A p-value < 0.05 indicates a
non-constant variance (heteroskedasticity).
}
\description{
Significance testing for linear regression models assumes that
the model errors (or residuals) have constant variance. If this assumption
is violated the p-values from the model are no longer reliable.
}
\details{
This test of the hypothesis of (non-)constant error is also called
\emph{Breusch-Pagan test} (\cite{1979}).
}
\note{
There is also a \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
m <<- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_heteroscedasticity(m)

# plot results
if (require("see")) {
  x <- check_heteroscedasticity(m)
  plot(x)
}
}
\references{
Breusch, T. S., and Pagan, A. R. (1979) A simple test for heteroscedasticity and random coefficient variation. Econometrica 47, 1287-1294.
}
