% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{plotlyProxy}
\alias{plotlyProxy}
\alias{plotlyProxyInvoke}
\title{Modify a plotly object inside a shiny app}
\usage{
plotlyProxy(
  outputId,
  session = shiny::getDefaultReactiveDomain(),
  deferUntilFlush = TRUE
)

plotlyProxyInvoke(p, method, ...)
}
\arguments{
\item{outputId}{single-element character vector indicating the output ID
map to modify (if invoked from a Shiny module, the namespace will be added
automatically)}

\item{session}{the Shiny session object to which the map belongs; usually the
default value will suffice.}

\item{deferUntilFlush}{indicates whether actions performed against this
instance should be carried out right away, or whether they should be held
until after the next time all of the outputs are updated.}

\item{p}{a plotly proxy object (created with \code{plotlyProxy})}

\item{method}{a plotlyjs method to invoke. For a list of options,
visit \url{https://plotly.com/javascript/plotlyjs-function-reference/}}

\item{...}{unnamed arguments passed onto the plotly.js method}
}
\description{
Modify a plotly object inside a shiny app
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}


if (require("shiny") && interactive()) {
  plotly_example("shiny", "proxy_relayout")
  plotly_example("shiny", "proxy_mapbox")
}
\dontshow{\}) # examplesIf}
}
