% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes.R
\name{simple_shapes}
\alias{simple_shapes}
\alias{poly_circle}
\alias{poly_circles}
\alias{poly_star}
\alias{poly_star_hole}
\alias{path_spiral}
\alias{path_waves}
\alias{point_random}
\alias{point_grid}
\title{Some different geometries to play with}
\usage{
poly_circle(st = FALSE, detail = 360)

poly_circles(st = FALSE, n = 3, r = 0.25, detail = 360)

poly_star(st = FALSE, n = 5, r1 = 0.5)

poly_star_hole(st = FALSE, n = 5, r1 = 0.5)

path_spiral(st = FALSE, windings = 5)

path_waves(st = FALSE, w1 = 7, w2 = 11)

point_random(st = FALSE, n = 10)

point_grid(st = FALSE, dim = 5)
}
\arguments{
\item{st}{Logical. Should the geometry be returned as an \code{sf} feature?}

\item{detail}{The number of points defining the shape}

\item{n}{For \code{poly_circles} the number of circles, for \code{poly_star} and
\code{poly_star_hole} the number of 'arms', and for \code{point_random} the number of
points}

\item{r, r1}{The radius of the geometry. \code{r} gives the radius of the circles
in \code{poly_circles} and \code{r1} gives the inner radius for
\code{poly_star}/\code{poly_star_hole}, thus determining how pointy it is}

\item{windings}{The number of revolutions in the spiral}

\item{w1, w2}{The frequency for the two sine waves}

\item{dim}{the number of rows and columns in the grid}
}
\value{
Either a data.frame or an sf feature depending on the value of \code{st}
}
\description{
These functions are provided to allow you to play with somee simple shapes as
you explore \code{transformr} and are also used in the examples for the different
tween functions. All geometries can be returned as either a standard
\code{data.frame} with \code{x}, \code{y}, and \code{id} column, or as an sf geometry of the
appropriate type.
}
\examples{
# Create a 7-pointed star
poly_star(n = 7)

}
