### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class GoalsBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Add a collaborator to a goal
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def add_followers(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}/addFollowers"
          path["{goal_gid}"] = goal_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Create a goal
        #

        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def create_goal(client, options: {}, **data)
          path = "/goals"
          parse(client.post(path, body: data, options: options)).first
        end

        # Create a goal metric
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def create_goal_metric(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}/setMetric"
          path["{goal_gid}"] = goal_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Delete a goal
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def delete_goal(client, goal_gid: required("goal_gid"), options: {})
          path = "/goals/{goal_gid}"
          path["{goal_gid}"] = goal_gid
          parse(client.delete(path, options: options)).first
        end

        # Get a goal
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_goal(client, goal_gid: required("goal_gid"), options: {})
          path = "/goals/{goal_gid}"
          path["{goal_gid}"] = goal_gid
          parse(client.get(path, options: options)).first
        end

        # Get goals
        #

        # portfolio - [str]  Globally unique identifier for supporting portfolio.
        # project - [str]  Globally unique identifier for supporting project.
        # is_workspace_level - [bool]  Filter to goals with is_workspace_level set to query value. Must be used with the workspace parameter.
        # team - [str]  Globally unique identifier for the team.
        # workspace - [str]  Globally unique identifier for the workspace.
        # time_periods - [list[str]]  Globally unique identifiers for the time periods.
        # options - [Hash] the request I/O options
        # > offset - [str]  Offset token. An offset to the next page returned by the API. A pagination request will return an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will return the first page of results. 'Note: You can only pass in an offset that was returned to you via a previously paginated request.'
        # > limit - [int]  Results per page. The number of objects to return per page. The value must be between 1 and 100.
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_goals(client, portfolio: nil, project: nil, is_workspace_level: nil, team: nil, workspace: nil, time_periods: nil, options: {})
          path = "/goals"
          params = { portfolio: portfolio, project: project, is_workspace_level: is_workspace_level, team: team, workspace: workspace, time_periods: time_periods }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Resource, client: client)
        end

        # Get parent goals from a goal
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def get_parent_goals_for_goal(client, goal_gid: required("goal_gid"), options: {})
          path = "/goals/{goal_gid}/parentGoals"
          path["{goal_gid}"] = goal_gid
          Collection.new(parse(client.get(path, options: options)), type: Resource, client: client)
        end

        # Remove a collaborator from a goal
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def remove_followers(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}/removeFollowers"
          path["{goal_gid}"] = goal_gid
          parse(client.post(path, body: data, options: options)).first
        end

        # Update a goal
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to PUT
        def update_goal(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}"
          path["{goal_gid}"] = goal_gid
          parse(client.put(path, body: data, options: options)).first
        end

        # Update a goal metric
        #
        # goal_gid - [str]  (required) Globally unique identifier for the goal.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        # data - [Hash] the attributes to POST
        def update_goal_metric(client, goal_gid: required("goal_gid"), options: {}, **data)
          path = "/goals/{goal_gid}/setMetricCurrentValue"
          path["{goal_gid}"] = goal_gid
          parse(client.post(path, body: data, options: options)).first
        end

      end
    end
  end
end
