# 2024-08-13 Triage Log

A big week for compiler performance brought on mostly by statically linking the std library into `rustc_driver` instead of dynamic linking. This overshadows all other improvements and regressions that were seen this week.

Triage done by **@rylev**.
Revision range: [8c7e0e16..9cb1998e](https://perf.rust-lang.org/?start=8c7e0e160831866bc1a40691a39455aac21271c0&end=9cb1998ea15e179482504e07cad8fa121e169a32&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.3% | [-2.9%, -0.2%] | 217   |
| Improvements ✅ <br /> (secondary) | -1.4% | [-4.9%, -0.2%] | 196   |
| All ❌✅ (primary)                 | -1.3% | [-2.9%, -0.2%] | 217   |


2 Regressions, 2 Improvements, 2 Mixed; 1 of them in rollups
35 artifact comparisons made in total

#### Regressions

Rollup of 7 pull requests [#128768](https://github.com/rust-lang/rust/pull/128768) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f3dc46465c04d10cb74d34b1bd80c3ebfdc05bf&end=6a2cd0d50c9b7e1243d948641758c76d1f22e25e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.4%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.4%] | 1     |
- All docs regressions caused by [#128417](https://github.com/rust-lang/rust/pull/128417) which is simply just documenting more.


Stabilize `min_exhaustive_patterns` [#122792](https://github.com/rust-lang/rust/pull/122792) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=48090b11b52bd841fa89082cdaa4c139f11995f7&end=8291d68d926cedcdc77973e4c68f0828156d5bd8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.3%, 1.5%] | 13    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.3%, 1.5%] | 13    |
- Seems this has a negative impact on the performance of coherence checking which I imagine is expected.
- Confirming with the author/reviewer.


#### Improvements

Cache supertrait outlives of impl header for soundness check [#128746](https://github.com/rust-lang/rust/pull/128746) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7347f8e4e007fbb3712364bc174476f5f55a6da4&end=48090b11b52bd841fa89082cdaa4c139f11995f7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.0%  | [0.0%, 0.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.3%, -0.2%] | 69    |
| Improvements ✅ <br /> (secondary) | -1.8% | [-3.8%, -0.2%] | 30    |
| All ❌✅ (primary)                 | -0.5% | [-1.3%, 0.2%]  | 70    |


Link `std` statically in `rustc_driver` [#122362](https://github.com/rust-lang/rust/pull/122362) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5e5ec8af1b34a71fbf0063586a70bae7460a892a&end=9cb1998ea15e179482504e07cad8fa121e169a32&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-2.0%, -0.2%] | 229   |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.0%, -0.2%] | 222   |
| All ❌✅ (primary)                 | -1.0% | [-2.0%, -0.2%] | 229   |


#### Mixed

Only walk ribs to collect possibly shadowed params if we are adding params in our new rib [#128550](https://github.com/rust-lang/rust/pull/128550) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=86e7875c13f048ed03d413aa83215df94f0467e8&end=0d65e5a1806db2662ba6a34d89c3b4bc506fb59a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [2.2%, 2.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-2.0%, -0.2%] | 31    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 6     |
| All ❌✅ (primary)                 | -0.6% | [-2.0%, -0.2%] | 31    |
- Regression seems to be noise.


Apply "polymorphization at home" to RawVec [#126793](https://github.com/rust-lang/rust/pull/126793) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9cb1998ea15e179482504e07cad8fa121e169a32&end=ba33d7b0ae7e8081a59ca8f768202290c6903405&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.6%]   | 98    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 1.2%]   | 125   |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.5%, -0.2%] | 51    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.9%, -0.3%] | 13    |
| All ❌✅ (primary)                 | -0.0% | [-3.5%, 1.6%]  | 149   |
- "there's a bunch of instruction regressions -- improvements too, but fewer of those -- but looking at cycles, wall time, bootstrap, and binary size it looks consistently great. And the overall approach is good, so there should be space to get smaller improvements with tweaks to things like mir inlining"

