# SLIM jest AWK-owym przekodownikiem pomi/edzy r/o/znymi systemami
# reprezentowania polskich liter.

# Poniedzia/lek, 3 marca 2008 r., wersja 0.600, UTF-8 OK?

BEGIN {
  print TBL > "CON"
  V["s"]=1;  V["S"]=1; V["/"]=1 # notacja ciachowa (,,slaszowa'')
  V["l"]=2;  V["L"]=2           # CP852 (Latin 2)
  V["i"]=3;  V["I"]=3           # ISO-8859-2 (ISO Latin2)
  V["m"]=4;  V["M"]=4           # Mazovia
  V["w"]=5;  V["W"]=5           # Windows CP1250
  V["c"]=6;  V["C"]=6           # CSK
  V["d"]=7;  V["D"]=7           # DHN
  V["e"]=8;  V["E"]=8           # EC (Cork Encoding)
  V["a"]=9;  V["A"]=9           # Apple Macintosh
  V["b"]=10; V["B"]=10          # belkot
  V["o"]=11; V["O"]=11          # TeX-ohida
  V["x"]=12; V["X"]=12          # Windows ,,extra''
  V["y"]=13; V["Y"]=13          # Cyfronet
  V["v"]=14; V["V"]=14          # MIME Autoconverted
  V["p"]=15; V["P"]=15          # Pablo Jacko/s; same k/lopoty:
                                # * wredna reprezentacja ,,/z''
                                #   (jedyna dwuznakowa, a do tego jeszcze ^)
                                # *  -->  --> 
  V["r"]=16; V["R"]=16          # RTF2LaTeX (TeX-ohida II), te kopoty z \.:
                                #   chyba poprzednio TeX-Ohida nie dziaa...
                                # Moe trzeba definiowa ,,znaki ochronne''
                                # w pliku TBL (stamtd na pewno powinny by
                                # brane literki okrelajce konwersj),
                                # a take cig znakw oznaczajcy ,,pusty
                                # element tabeli'' -- do konwersji czego
                                # oprcz polskich znakw diakrytycznych...
                                # czy numery kolumn s lepsze?
  V["u"]=17; V["U"]=17          # UCS2-ENTITIES
  V["8"]=18;                    # UTF-8
  jest_robota=(V[S]!=V[R])
  while (getline < TBL > 0) if (/^[^ ]/) {
   konwersja_wieloznakowa=konwersja_wieloznakowa ||
     ((length($V[S])>1) && (S!="8")) ||
     ((length($V[R])>1) && (R!="8"))
   VS=$V[S]; VR=$V[R]
   gsub(/\\/,"\\\\", VS); gsub(/\\/,"\\\\", VR) # specyfika AWK-a
   gsub(/\^/,"\001", VS); gsub(/\^/,"\001", VR)
   gsub(/\./,"\002", VS); gsub(/\./,"\002", VR)
   TRANS[VS]=VR
  }
}
 
/\000/ {print $0; N0++}

{
  if (jest_robota) {
    if (konwersja_wieloznakowa) { # notacja ciachowa jest nieco specyficzna
      if (V[R]==1) {gsub("\\\\/","\000"); gsub("/","//")} # ,,ukrycie'' \/
      if (V[S]==1) gsub("//","\000")                      # ,,ukrycie'' //
      gsub(/\^/,"\001")                                   # ,,ukrycie'' ^
      gsub(/\./,"\002")                                   # ,,ukrycie'' .
      for (i in TRANS) gsub(i,TRANS[i])
      if (V[R]==1) {gsub("\000","\\/")}                   # odtworzenie \/
      if (V[S]==1) gsub("\000","/")                       # odtworzenie //
      gsub("\001","^")                                    # odtworzenie ^
      gsub("\002",".")                                    # odtworzenie .
    } else {
      s=""
      if (S=="8") 
        for (i=1; i<=length($0); ++i) {
          c=substr($0,i,2);
          if (c in TRANS) {s=s TRANS[c]; i++} else s=s substr(c,1,1)
        }
      else
        for (i=1; i<=length($0); ++i) {
          c=substr($0,i,1);
          s=s (c in TRANS ? TRANS[c] : c)
        }
      $0=s
    }
  }
  if (OFI!="") {print > OFI} else print
}

END {
 if (N0>0) print "UWAGA: znak(i) o kodzie zero (" N0 ")"
# for (i in TRANS) print i, ":", TRANS[i]
}
