#ifndef TIME_FREQUENCY_WIDGET_H
#define TIME_FREQUENCY_WIDGET_H

#include "../rfigui/maskedheatmap.h"

#include "../plot/plotwidget.h"
#include "../plot/xyplot.h"

#include <gtkmm/box.h>

class TimeFrequencyWidget : public Gtk::Box {
 public:
  explicit TimeFrequencyWidget(MaskedHeatMap& plot)
      : Gtk::Box(Gtk::Orientation::VERTICAL), _heatMap() {
    _heatMap.SetPlot(plot);
    _timePlotWidget.SetPlot(_timePlot);
    _timePlotWidget.set_size_request(200, 60);
    _timePlot.XAxis().SetShow(false);
    append(_timePlotWidget);
    _timePlotWidget.set_expand(true);
    EnableTimePlot();

    GetMaskedHeatMap().SetShowTitle(true);
    _heatMap.set_size_request(200, 200);
    append(_heatMap);
    _heatMap.set_expand(true);
    _heatMap.show();
  }

  void Update() {
    _heatMap.Update();
    _timePlotWidget.Update();
  }

  bool HasImage() const { return GetMaskedHeatMap().HasImage(); }

  PlotWidget& GetHeatMapWidget() { return _heatMap; }
  MaskedHeatMap& GetMaskedHeatMap() {
    return static_cast<MaskedHeatMap&>(_heatMap.Plot());
  }
  const MaskedHeatMap& GetMaskedHeatMap() const {
    return static_cast<const MaskedHeatMap&>(_heatMap.Plot());
  }

  void EnableTimePlot() {
    _timePlot.LinkHorizontally(_heatMap.Plot());
    _timePlotWidget.show();
    Update();
  }

  void DisableTimePlot() {
    _timePlotWidget.hide();
    _timePlot.UnlinkHorizontally();
  }

  XYPlot& TimePlot() { return _timePlot; }

 private:
  PlotWidget _heatMap;
  PlotWidget _timePlotWidget;
  XYPlot _timePlot;
};

#endif
