"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.traceGlyphDependents = void 0;
const Ot = require("@ot-builder/ot");
const TraceImpl_Glyph = require("./trace-impl/glyph");
function traceGlyphDependents(g) {
    return tracer => {
        if (!tracer.has(g))
            return;
        if (!g.geometry)
            return;
        return new TraceGlyphsAlg().process(g.geometry)(tracer);
    };
}
exports.traceGlyphDependents = traceGlyphDependents;
class TraceGlyphsAlg {
    process(geom) {
        switch (geom.type) {
            case Ot.Glyph.GeometryType.ContourSet:
                return this.contourSet(geom);
            case Ot.Glyph.GeometryType.GeometryList:
                return this.geometryList(geom.items.map(item => this.process(item)));
            case Ot.Glyph.GeometryType.TtReference:
                return this.ttReference(geom);
        }
    }
    contourSet(geom) {
        return TraceImpl_Glyph.Nop();
    }
    geometryList(children) {
        return TraceImpl_Glyph.Seq(children);
    }
    ttReference(ref) {
        return RefProc(ref.to);
    }
}
function RefProc(target) {
    return (tracer) => {
        if (tracer.has(target))
            return;
        tracer.add(target);
        if (target.geometry) {
            new TraceGlyphsAlg().process(target.geometry)(tracer);
        }
    };
}
//# sourceMappingURL=glyphs.js.map