/// <reference types="node" />
import * as util from "util";
import { VarianceDim } from "../interface/dimension";
import { VarianceInstance } from "../interface/instance";
import { VarianceMasterSet } from "../interface/master";
import { OtVarMaster } from "./master";
export type OtVarValue = number | OtVarValueC;
export declare class OtVarValueC {
    private readonly masterSet;
    readonly origin: number;
    /** delta values */
    private deltaValues;
    private constructor();
    private getVarianceByIndex;
    private inPlaceSetVarianceByIndex;
    private inPlaceAddVarianceByIndex;
    getDelta(master: OtVarMaster): number;
    private setDelta;
    private addDelta;
    variance(): IterableIterator<[OtVarMaster, number]>;
    evaluate(instance: VarianceInstance<VarianceDim>): number;
    scaleAddNumber(thisScale: number, other: number): OtVarValueC;
    scaleAddScaleVariable(thisScale: number, otherScale: number, other: OtVarValueC): OtVarValueC;
    toString(): string;
    [util.inspect.custom](): string;
    static Create(masterSet: VarianceMasterSet<VarianceDim, OtVarMaster>, origin: number, variance: Iterable<[OtVarMaster, number]>): OtVarValueC;
}
//# sourceMappingURL=value.d.ts.map