/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2024-2025 Brett A C Sheffield <bacs@librecast.net> */

#include "test.h"
#include <key.h>

/* see https://doc.libsodium.org/public-key_cryptography/public-key_signatures */
#define MESSAGE (const unsigned char *) "test"
#define MESSAGE_LEN 4
#define CIPHERTEXT_LEN (crypto_box_MACBYTES + MESSAGE_LEN)
int verify_signing_key(unsigned char *public, unsigned char *secret)
{
	unsigned char signed_message[crypto_sign_BYTES + MESSAGE_LEN];
	unsigned long long signed_message_len;
	int rc;

	rc = crypto_sign(signed_message, &signed_message_len, MESSAGE, MESSAGE_LEN, secret);
	if (!test_assert(rc == 0, "crypto_secretbox_easy()")) return test_status;

	unsigned char unsigned_message[MESSAGE_LEN];
	unsigned long long unsigned_message_len;
	rc = crypto_sign_open(unsigned_message, &unsigned_message_len, signed_message,
			signed_message_len, public);
	test_assert(rc == 0, "verify signature");
	return test_status;
}

int main(void)
{
	key_combo_t keyring;
	char name[] = "key_gen_keys() - verify signing key";
	int rc;

	test_name(name);

	rc = key_gen_keys(&keyring);
	test_assert(rc == 0, "key_gen_keys()");

	/* verify signing key */
	if (verify_signing_key(keyring.s.pk, keyring.s.sk)) return test_status;

	return 0;
}
