; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -O0 -frame-pointer=all -mtriple=powerpc-unknown-linux-gnu -mcpu=g5 < %s | FileCheck %s -check-prefix=PPC32
; RUN: llc -O0 -mtriple=powerpc64-unknown-linux-gnu -mcpu=g5 < %s | FileCheck %s -check-prefix=PPC64
; RUN: llc -O0 -mtriple=powerpc64le-unknown-linux-gnu -verify-machineinstrs < %s | FileCheck %s -check-prefix=PPC64-ELFv2

declare void @foo()

define i32 @test_cr2() nounwind uwtable {
; PPC32-LABEL: test_cr2:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr 0
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stw 31, 28(1)
; PPC32-NEXT:    stw 0, 36(1)
; PPC32-NEXT:    .cfi_def_cfa_offset 32
; PPC32-NEXT:    .cfi_offset r31, -4
; PPC32-NEXT:    .cfi_offset lr, 4
; PPC32-NEXT:    mr 31, 1
; PPC32-NEXT:    .cfi_def_cfa_register r31
; PPC32-NEXT:    .cfi_offset cr2, -8
; PPC32-NEXT:    mfcr 12
; PPC32-NEXT:    stw 12, 24(31)
; PPC32-NEXT:    li 3, 1
; PPC32-NEXT:    li 4, 2
; PPC32-NEXT:    li 5, 3
; PPC32-NEXT:    li 6, 0
; PPC32-NEXT:    #APP
; PPC32-EMPTY:
; PPC32-NEXT:    mtcr 6
; PPC32-NEXT:    cmpw 2, 4, 3
; PPC32-NEXT:    mfcr 3
; PPC32-NEXT:    #NO_APP
; PPC32-NEXT:    stw 3, 20(31)
; PPC32-NEXT:    bl foo
; PPC32-NEXT:    lwz 3, 20(31)
; PPC32-NEXT:    lwz 12, 24(31)
; PPC32-NEXT:    mtocrf 32, 12
; PPC32-NEXT:    lwz 0, 36(1)
; PPC32-NEXT:    lwz 31, 28(1)
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    mtlr 0
; PPC32-NEXT:    blr
;
; PPC64-LABEL: test_cr2:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mflr 0
; PPC64-NEXT:    mfcr 12
; PPC64-NEXT:    stw 12, 8(1)
; PPC64-NEXT:    stdu 1, -128(1)
; PPC64-NEXT:    std 0, 144(1)
; PPC64-NEXT:    .cfi_def_cfa_offset 128
; PPC64-NEXT:    .cfi_offset lr, 16
; PPC64-NEXT:    .cfi_offset cr2, 8
; PPC64-NEXT:    li 3, 1
; PPC64-NEXT:    li 4, 2
; PPC64-NEXT:    li 5, 3
; PPC64-NEXT:    li 6, 0
; PPC64-NEXT:    #APP
; PPC64-EMPTY:
; PPC64-NEXT:    mtcr 6
; PPC64-NEXT:    cmpw 2, 4, 3
; PPC64-NEXT:    mfcr 3
; PPC64-NEXT:    #NO_APP
; PPC64-NEXT:    stw 3, 124(1)
; PPC64-NEXT:    bl foo
; PPC64-NEXT:    nop
; PPC64-NEXT:    lwz 3, 124(1)
; PPC64-NEXT:    addi 1, 1, 128
; PPC64-NEXT:    ld 0, 16(1)
; PPC64-NEXT:    lwz 12, 8(1)
; PPC64-NEXT:    mtocrf 32, 12
; PPC64-NEXT:    mtlr 0
; PPC64-NEXT:    blr
;
; PPC64-ELFv2-LABEL: test_cr2:
; PPC64-ELFv2:       # %bb.0: # %entry
; PPC64-ELFv2-NEXT:    mflr 0
; PPC64-ELFv2-NEXT:    mfocrf 12, 32
; PPC64-ELFv2-NEXT:    stw 12, 8(1)
; PPC64-ELFv2-NEXT:    stdu 1, -112(1)
; PPC64-ELFv2-NEXT:    std 0, 128(1)
; PPC64-ELFv2-NEXT:    .cfi_def_cfa_offset 112
; PPC64-ELFv2-NEXT:    .cfi_offset lr, 16
; PPC64-ELFv2-NEXT:    .cfi_offset cr2, 8
; PPC64-ELFv2-NEXT:    li 3, 1
; PPC64-ELFv2-NEXT:    li 4, 2
; PPC64-ELFv2-NEXT:    li 5, 3
; PPC64-ELFv2-NEXT:    li 6, 0
; PPC64-ELFv2-NEXT:    #APP
; PPC64-ELFv2-EMPTY:
; PPC64-ELFv2-NEXT:    mtcr 6
; PPC64-ELFv2-NEXT:    cmpw 2, 4, 3
; PPC64-ELFv2-NEXT:    mfcr 3
; PPC64-ELFv2-NEXT:    #NO_APP
; PPC64-ELFv2-NEXT:    stw 3, 108(1)
; PPC64-ELFv2-NEXT:    bl foo
; PPC64-ELFv2-NEXT:    nop
; PPC64-ELFv2-NEXT:    lwz 3, 108(1)
; PPC64-ELFv2-NEXT:    addi 1, 1, 112
; PPC64-ELFv2-NEXT:    ld 0, 16(1)
; PPC64-ELFv2-NEXT:    lwz 12, 8(1)
; PPC64-ELFv2-NEXT:    mtocrf 32, 12
; PPC64-ELFv2-NEXT:    mtlr 0
; PPC64-ELFv2-NEXT:    blr
entry:
  %ret = alloca i32, align 4
  %0 = call i32 asm sideeffect "\0A\09mtcr $4\0A\09cmpw 2,$2,$1\0A\09mfcr $0", "=r,r,r,r,r,~{cr2}"(i32 1, i32 2, i32 3, i32 0) nounwind
  store i32 %0, ptr %ret, align 4
  call void @foo()
  %1 = load i32, ptr %ret, align 4
  ret i32 %1
}

define i32 @test_cr234() nounwind {
; PPC32-LABEL: test_cr234:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr 0
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stw 31, 28(1)
; PPC32-NEXT:    stw 0, 36(1)
; PPC32-NEXT:    mr 31, 1
; PPC32-NEXT:    mfcr 12
; PPC32-NEXT:    stw 12, 24(31)
; PPC32-NEXT:    li 3, 1
; PPC32-NEXT:    li 4, 2
; PPC32-NEXT:    li 5, 3
; PPC32-NEXT:    li 6, 0
; PPC32-NEXT:    #APP
; PPC32-EMPTY:
; PPC32-NEXT:    mtcr 6
; PPC32-NEXT:    cmpw 2, 4, 3
; PPC32-NEXT:    cmpw 3, 4, 4
; PPC32-NEXT:    cmpw 4, 4, 5
; PPC32-NEXT:    mfcr 3
; PPC32-NEXT:    #NO_APP
; PPC32-NEXT:    stw 3, 20(31)
; PPC32-NEXT:    bl foo
; PPC32-NEXT:    lwz 3, 20(31)
; PPC32-NEXT:    lwz 12, 24(31)
; PPC32-NEXT:    mtocrf 32, 12
; PPC32-NEXT:    mtocrf 16, 12
; PPC32-NEXT:    mtocrf 8, 12
; PPC32-NEXT:    lwz 0, 36(1)
; PPC32-NEXT:    lwz 31, 28(1)
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    mtlr 0
; PPC32-NEXT:    blr
;
; PPC64-LABEL: test_cr234:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mflr 0
; PPC64-NEXT:    mfcr 12
; PPC64-NEXT:    stw 12, 8(1)
; PPC64-NEXT:    stdu 1, -128(1)
; PPC64-NEXT:    std 0, 144(1)
; PPC64-NEXT:    li 3, 1
; PPC64-NEXT:    li 4, 2
; PPC64-NEXT:    li 5, 3
; PPC64-NEXT:    li 6, 0
; PPC64-NEXT:    #APP
; PPC64-EMPTY:
; PPC64-NEXT:    mtcr 6
; PPC64-NEXT:    cmpw 2, 4, 3
; PPC64-NEXT:    cmpw 3, 4, 4
; PPC64-NEXT:    cmpw 4, 4, 5
; PPC64-NEXT:    mfcr 3
; PPC64-NEXT:    #NO_APP
; PPC64-NEXT:    stw 3, 124(1)
; PPC64-NEXT:    bl foo
; PPC64-NEXT:    nop
; PPC64-NEXT:    lwz 3, 124(1)
; PPC64-NEXT:    addi 1, 1, 128
; PPC64-NEXT:    ld 0, 16(1)
; PPC64-NEXT:    lwz 12, 8(1)
; PPC64-NEXT:    mtocrf 32, 12
; PPC64-NEXT:    mtocrf 16, 12
; PPC64-NEXT:    mtocrf 8, 12
; PPC64-NEXT:    mtlr 0
; PPC64-NEXT:    blr
;
; PPC64-ELFv2-LABEL: test_cr234:
; PPC64-ELFv2:       # %bb.0: # %entry
; PPC64-ELFv2-NEXT:    mflr 0
; PPC64-ELFv2-NEXT:    mfcr 12
; PPC64-ELFv2-NEXT:    stw 12, 8(1)
; PPC64-ELFv2-NEXT:    stdu 1, -112(1)
; PPC64-ELFv2-NEXT:    std 0, 128(1)
; PPC64-ELFv2-NEXT:    li 3, 1
; PPC64-ELFv2-NEXT:    li 4, 2
; PPC64-ELFv2-NEXT:    li 5, 3
; PPC64-ELFv2-NEXT:    li 6, 0
; PPC64-ELFv2-NEXT:    #APP
; PPC64-ELFv2-EMPTY:
; PPC64-ELFv2-NEXT:    mtcr 6
; PPC64-ELFv2-NEXT:    cmpw 2, 4, 3
; PPC64-ELFv2-NEXT:    cmpw 3, 4, 4
; PPC64-ELFv2-NEXT:    cmpw 4, 4, 5
; PPC64-ELFv2-NEXT:    mfcr 3
; PPC64-ELFv2-NEXT:    #NO_APP
; PPC64-ELFv2-NEXT:    stw 3, 108(1)
; PPC64-ELFv2-NEXT:    bl foo
; PPC64-ELFv2-NEXT:    nop
; PPC64-ELFv2-NEXT:    lwz 3, 108(1)
; PPC64-ELFv2-NEXT:    addi 1, 1, 112
; PPC64-ELFv2-NEXT:    ld 0, 16(1)
; PPC64-ELFv2-NEXT:    lwz 12, 8(1)
; PPC64-ELFv2-NEXT:    mtocrf 32, 12
; PPC64-ELFv2-NEXT:    mtocrf 16, 12
; PPC64-ELFv2-NEXT:    mtocrf 8, 12
; PPC64-ELFv2-NEXT:    mtlr 0
; PPC64-ELFv2-NEXT:    blr
entry:
  %ret = alloca i32, align 4
  %0 = call i32 asm sideeffect "\0A\09mtcr $4\0A\09cmpw 2,$2,$1\0A\09cmpw 3,$2,$2\0A\09cmpw 4,$2,$3\0A\09mfcr $0", "=r,r,r,r,r,~{cr2},~{cr3},~{cr4}"(i32 1, i32 2, i32 3, i32 0) nounwind
  store i32 %0, ptr %ret, align 4
  call void @foo()
  %1 = load i32, ptr %ret, align 4
  ret i32 %1
}

; Generate mfocrf in prologue when we need to save 1 nonvolatile CR field
define void @cloberOneNvCrField() {
; PPC32-LABEL: cloberOneNvCrField:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stw 31, 28(1)
; PPC32-NEXT:    .cfi_def_cfa_offset 32
; PPC32-NEXT:    .cfi_offset r31, -4
; PPC32-NEXT:    mr 31, 1
; PPC32-NEXT:    .cfi_def_cfa_register r31
; PPC32-NEXT:    .cfi_offset cr2, -8
; PPC32-NEXT:    mfcr 12
; PPC32-NEXT:    stw 12, 24(31)
; PPC32-NEXT:    #APP
; PPC32-NEXT:    # clobbers
; PPC32-NEXT:    #NO_APP
; PPC32-NEXT:    lwz 12, 24(31)
; PPC32-NEXT:    mtocrf 32, 12
; PPC32-NEXT:    lwz 31, 28(1)
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    blr
;
; PPC64-LABEL: cloberOneNvCrField:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mfcr 12
; PPC64-NEXT:    stw 12, 8(1)
; PPC64-NEXT:    #APP
; PPC64-NEXT:    # clobbers
; PPC64-NEXT:    #NO_APP
; PPC64-NEXT:    lwz 12, 8(1)
; PPC64-NEXT:    mtocrf 32, 12
; PPC64-NEXT:    blr
;
; PPC64-ELFv2-LABEL: cloberOneNvCrField:
; PPC64-ELFv2:       # %bb.0: # %entry
; PPC64-ELFv2-NEXT:    mfocrf 12, 32
; PPC64-ELFv2-NEXT:    stw 12, 8(1)
; PPC64-ELFv2-NEXT:    #APP
; PPC64-ELFv2-NEXT:    # clobbers
; PPC64-ELFv2-NEXT:    #NO_APP
; PPC64-ELFv2-NEXT:    lwz 12, 8(1)
; PPC64-ELFv2-NEXT:    mtocrf 32, 12
; PPC64-ELFv2-NEXT:    blr
entry:
  tail call void asm sideeffect "# clobbers", "~{cr2}"()
  ret void
}

; Generate mfcr in prologue when we need to save all nonvolatile CR field
define void @cloberAllNvCrField() {
; PPC32-LABEL: cloberAllNvCrField:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stw 31, 28(1)
; PPC32-NEXT:    .cfi_def_cfa_offset 32
; PPC32-NEXT:    .cfi_offset r31, -4
; PPC32-NEXT:    mr 31, 1
; PPC32-NEXT:    .cfi_def_cfa_register r31
; PPC32-NEXT:    .cfi_offset cr2, -8
; PPC32-NEXT:    .cfi_offset cr3, -8
; PPC32-NEXT:    .cfi_offset cr4, -8
; PPC32-NEXT:    mfcr 12
; PPC32-NEXT:    stw 12, 24(31)
; PPC32-NEXT:    #APP
; PPC32-NEXT:    # clobbers
; PPC32-NEXT:    #NO_APP
; PPC32-NEXT:    lwz 12, 24(31)
; PPC32-NEXT:    mtocrf 32, 12
; PPC32-NEXT:    mtocrf 16, 12
; PPC32-NEXT:    mtocrf 8, 12
; PPC32-NEXT:    lwz 31, 28(1)
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    blr
;
; PPC64-LABEL: cloberAllNvCrField:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    mfcr 12
; PPC64-NEXT:    stw 12, 8(1)
; PPC64-NEXT:    #APP
; PPC64-NEXT:    # clobbers
; PPC64-NEXT:    #NO_APP
; PPC64-NEXT:    lwz 12, 8(1)
; PPC64-NEXT:    mtocrf 32, 12
; PPC64-NEXT:    mtocrf 16, 12
; PPC64-NEXT:    mtocrf 8, 12
; PPC64-NEXT:    blr
;
; PPC64-ELFv2-LABEL: cloberAllNvCrField:
; PPC64-ELFv2:       # %bb.0: # %entry
; PPC64-ELFv2-NEXT:    mfcr 12
; PPC64-ELFv2-NEXT:    stw 12, 8(1)
; PPC64-ELFv2-NEXT:    #APP
; PPC64-ELFv2-NEXT:    # clobbers
; PPC64-ELFv2-NEXT:    #NO_APP
; PPC64-ELFv2-NEXT:    lwz 12, 8(1)
; PPC64-ELFv2-NEXT:    mtocrf 32, 12
; PPC64-ELFv2-NEXT:    mtocrf 16, 12
; PPC64-ELFv2-NEXT:    mtocrf 8, 12
; PPC64-ELFv2-NEXT:    blr
entry:
  tail call void asm sideeffect "# clobbers", "~{cr2},~{cr3},~{cr4}"()
  ret void
}
