; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=armv8-unknown-none-eabi < %s | FileCheck %s --check-prefixes=CHECK,HARD
; RUN: llc -mtriple=armv8-unknown-none-eabi -mattr=+soft-float < %s | FileCheck %s --check-prefixes=CHECK,SOFT

define nofpclass(nan inf) half @f1(half returned nofpclass(nan inf) %x) {
; CHECK-LABEL: f1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  ret half %x
}

define noundef half @f2(half nofpclass(nan) %a) {
; HARD-LABEL: f2:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vmov.f32 s0, #1.000000e+00
; HARD-NEXT:    vmov s2, r0
; HARD-NEXT:    vcvtb.f32.f16 s2, s2
; HARD-NEXT:    vadd.f32 s0, s2, s0
; HARD-NEXT:    vcvtb.f16.f32 s0, s0
; HARD-NEXT:    vmov r0, s0
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: f2:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r11, lr}
; SOFT-NEXT:    push {r11, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r1, #1065353216
; SOFT-NEXT:    bl __aeabi_fadd
; SOFT-NEXT:    bl __aeabi_f2h
; SOFT-NEXT:    pop {r11, pc}
entry:
  %0 = fadd half %a, 0xH3C00
  ret half %0
}
