; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc %s -o - -verify-machineinstrs \
; RUN:   -stop-after=finalize-isel -start-before=ppc-isel | FileCheck %s

target datalayout = "e-m:e-i64:64-n32:64-S128-v256:256:256-v512:512:512"
target triple = "powerpc64le-unknown-linux-gnu"

define void @strncpy_from_kernel_nofault_count() {
  ; CHECK-LABEL: name: strncpy_from_kernel_nofault_count
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   successors: %bb.1(0x80000000), %bb.3(0x00000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   INLINEASM_BR &"", 0 /* attdialect */, 131082 /* regdef:GPRC */, def %1, 13 /* imm */, %bb.3
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gprc = COPY %1
  ; CHECK-NEXT:   B %bb.1
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.1.asm.fallthrough:
  ; CHECK-NEXT:   successors: %bb.2(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   STB [[COPY]], 0, $zero8 :: (store (s8) into `ptr null`)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.Efault:
  ; CHECK-NEXT:   BLR8 implicit $lr8, implicit $rm
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.Efault.split (inlineasm-br-indirect-target):
  ; CHECK-NEXT:   successors: %bb.2(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   STB %1, 0, $zero8 :: (store (s8) into `ptr null`)
  ; CHECK-NEXT:   B %bb.2
entry:
  %0 = callbr i8 asm "", "=r,!i"()
          to label %asm.fallthrough [label %Efault.split]

asm.fallthrough:
  store i8 %0, ptr null, align 1
  br label %Efault

Efault:
  ret void

Efault.split:
  %1 = call i8 @llvm.callbr.landingpad.i8(i8 %0)
  store i8 %1, ptr null, align 1
  br label %Efault
}
declare i8 @llvm.callbr.landingpad.i8(i8)
