/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QRect>
#include <QGraphicsRectItem>
#include <QPointF>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Monomer.hpp>
#include <MsXpS/libXpertMassCore/IndexRangeCollection.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


namespace MsXpS
{

namespace MassXpert
{


class SequenceEditorGraphicsView;

class RegionSelection
{
  public:
  RegionSelection(SequenceEditorGraphicsView *);

  ~RegionSelection(void);

  SequenceEditorGraphicsView *view();

  const libXpertMassCore::MonomerCstSPtr getStartMonomer() const;
  const libXpertMassCore::MonomerCstSPtr getStopMonomer() const;

  int getStartIndex() const;
  int getStopIndex() const;

  int redrawMark();
  int drawMark(int, int);
  int drawMark(const QPointF &start_point, const QPointF &stop_point);

  bool encompassing(int = -1, int = -1);

  libXpertMassCore::IndexRange getIndexRange();

  QString getIndicesAsText() const;

  protected:
  SequenceEditorGraphicsView *mp_view;

  QList<QRectF *> m_rectangleList;
  QList<QGraphicsRectItem *> m_markList;

  libXpertMassCore::MonomerCstSPtr mcsp_startMonomer;
  libXpertMassCore::MonomerCstSPtr mcsp_stopMonomer;

  QPointF m_startPoint;
  QPointF m_stopPoint;

  int m_startIndex = -1;
  int m_stopIndex  = -1;

  void setIndexRange(int start_index, int stop_index);
  void setIndexRange(const QPointF &start_point, const QPointF &stop_point);
  int drawMark();
  int eraseMark();
};

typedef std::shared_ptr<RegionSelection> RegionSelectionSPtr;
typedef std::shared_ptr<const RegionSelection> RegionSelectionCstSPtr;

} // namespace MassXpert
} // namespace MsXpS
