% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_int_linter.R
\name{sample_int_linter}
\alias{sample_int_linter}
\title{Require usage of sample.int(n, m, ...) over sample(1:n, m, ...)}
\usage{
sample_int_linter()
}
\description{
\code{\link[=sample.int]{sample.int()}} is preferable to \code{sample()} for the case of sampling numbers
between 1 and \code{n}. \code{sample} calls \code{sample.int()} "under the hood".
}
\examples{
# will produce lints
lint(
  text = "sample(1:10, 2)",
  linters = sample_int_linter()
)

lint(
  text = "sample(seq(4), 2)",
  linters = sample_int_linter()
)

lint(
  text = "sample(seq_len(8), 2)",
  linters = sample_int_linter()
)

# okay
lint(
  text = "sample(seq(1, 5, by = 2), 2)",
  linters = sample_int_linter()
)

lint(
  text = "sample(letters, 2)",
  linters = sample_int_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}, \link[=robustness_linters]{robustness}
}
