/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. SEE devtools/client/webconsole/test/README.md.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers.js");
const { prepareMessage } = require("resource://devtools/client/webconsole/utils/messages.js");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("resource://devtools/client/webconsole/types.js");

const rawPackets = new Map();
rawPackets.set(`Unknown property ‘such-unknown-property’.  Declaration dropped.`, {
  "pageError": {
    "errorMessage": "Unknown property ‘such-unknown-property’.  Declaration dropped.",
    "sourceName": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-css-message.html",
    "sourceId": null,
    "lineNumber": 3,
    "columnNumber": 27,
    "category": "CSS Parser",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": true,
    "error": false,
    "info": false,
    "private": false,
    "stacktrace": null,
    "notes": null,
    "chromeContext": false,
    "isForwardedFromContentProcess": false
  },
  "cssSelectors": "p",
  "resourceType": "css-message",
  "isAlreadyExistingResource": false
});

rawPackets.set(`Error in parsing value for ‘padding-top’.  Declaration dropped.`, {
  "pageError": {
    "errorMessage": "Error in parsing value for ‘padding-top’.  Declaration dropped.",
    "sourceName": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-css-message.html",
    "sourceId": null,
    "lineNumber": 3,
    "columnNumber": 18,
    "category": "CSS Parser",
    "innerWindowID": 8589934593,
    "timeStamp": 1572867483805,
    "warning": true,
    "error": false,
    "info": false,
    "private": false,
    "stacktrace": null,
    "notes": null,
    "chromeContext": false,
    "isForwardedFromContentProcess": false
  },
  "cssSelectors": "p",
  "resourceType": "css-message",
  "isAlreadyExistingResource": false
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
