#include <pbutil.h>

#if defined (PBU_TRACE) // [
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

static int _pbu_trc_depth=0;

void pbu_trc_indent(void)
{
  int i;

  for (i=0;i<_pbu_trc_depth;++i)
    fputs("  ",stderr);
}

const char *pbu_basename(const char *path);

void pbu_trc_depth(const char *path, int line)
{
  pbu_trc_indent();
  fprintf(stderr,"%s:%d DEPTH %d\n",pbu_basename(path),line,_pbu_trc_depth);
  fflush(stderr);
}

void pbu_trc_enter_line(const char *path, int line)
{
  pbu_trc_indent();
  fprintf(stderr,"%s:%d {\n",pbu_basename(path),line);
  fflush(stderr);
  _pbu_trc_depth++;
}

void pbu_trc_enter(const char *id)
{
  pbu_trc_indent();
  fprintf(stderr,"%s {\n",id);
  fflush(stderr);
  _pbu_trc_depth++;
}

void pbu_trc_leave(void)
{
  _pbu_trc_depth--;
  pbu_trc_indent();
  fputs("}\n",stderr);
  fflush(stderr);
}

FILE *pbu_trc_line(const char *path, int line)
{

  pbu_trc_indent();
  fprintf(stderr,"%s:%d ",pbu_basename(path), line);
  fflush(stderr);

  return stderr;
}

void pbu_trc_printf(const char *format, ...)
{
  va_list ap;

  pbu_trc_indent();
  va_start (ap,format);
  vfprintf(stderr,format,ap);
  va_end (ap);
  fflush(stderr);
}

void pbu_trc_puts(const char *path, int line, const char *s)
{
  pbu_trc_indent();
  fprintf(stderr,"%s:%d %s\n",pbu_basename(path), line, s);
  fflush(stderr);
}

int pbu_trc_return_int(const char *path, int line, int ret)
{
  pbu_trc_indent();
  fprintf(stderr,"%s:%d return %d;\n",pbu_basename(path), line, ret);
  --_pbu_trc_depth;
  pbu_trc_indent();
  fputs("}\n",stderr);
  fflush(stderr);

  return ret;
}
#endif // ]
