%feature("docstring") OT::Box
R"RAW(Box design of experiments.

Parameters
----------
levels : sequence of int or float
    Sequence specifying the number of intermediate points in each direction
    which regularly discretizes a pavement. In direction :math:`i`, the
    points number is :math:`levels[i]+2`.
bounds : :class:`~openturns.Interval`, optional
    The bounds of the pavement
    If not specified, the bounds are set to the unit pavement :math:`[0,1]^n`.

Notes
-----
Box is a stratified design of experiments enabling to create
a points grid by regularly discretizing a pavement with
the number of intermediate points specified in each direction. The number of
points generated is :math:`\prod_{i=1}^n (2+levels[i])`.

See also
--------
StratifiedExperiment

Examples
--------
>>> import openturns as ot
>>> # direction 1 will be discretized in with 4 intermediate points
>>> # and direction 2 with 2 intermediate points
>>> levels = [4, 2]
>>> # first component in [5,7], second in [6,9]
>>> bounds = ot.Interval([5.0, 6.0], [7.0, 9.0])
>>> myGrid = ot.Box(levels, bounds)
>>> mySample = myGrid.generate()
)RAW"

