//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementRestoreWithAccessKey.json
func ExampleServiceClient_BeginRestore() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginRestore(ctx, "rg1", "apimService1", armapimanagement.ServiceBackupRestoreParameters{
		AccessKey:      to.Ptr("**************************************************"),
		AccessType:     to.Ptr(armapimanagement.AccessTypeAccessKey),
		BackupName:     to.Ptr("apimService1backup_2017_03_19"),
		ContainerName:  to.Ptr("backupContainer"),
		StorageAccount: to.Ptr("teststorageaccount"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAACXok="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(true),
	// 				GatewayRegionalURL: to.Ptr("https://apimService1-eastus-01.regional.azure-api.net"),
	// 				Location: to.Ptr("East US"),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("23.101.138.153")},
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](1),
	// 					},
	// 			}},
	// 			APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 				MinAPIVersion: to.Ptr("2019-01-01"),
	// 			},
	// 			CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-18T06:26:20.334Z"); return t}()),
	// 			CustomProperties: map[string]*string{
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 			},
	// 			DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 			DisableGateway: to.Ptr(false),
	// 			GatewayRegionalURL: to.Ptr("https://apimService1-westus-01.regional.azure-api.net"),
	// 			GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 			HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("apimService1.azure-api.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXB9C2C91F1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(true),
	// 					HostName: to.Ptr("gateway1.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeManagement),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXB9C2C91F1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("mgmt.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypePortal),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXB9C2C91F1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("portal1.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 			}},
	// 			ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 			NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 			PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			PublicIPAddresses: []*string{
	// 				to.Ptr("13.91.32.113")},
	// 				ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 				TargetProvisioningState: to.Ptr(""),
	// 				VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 				PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 				PublisherName: to.Ptr("autorestsdk"),
	// 			},
	// 			SKU: &armapimanagement.ServiceSKUProperties{
	// 				Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 				Capacity: to.Ptr[int32](1),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementBackupWithAccessKey.json
func ExampleServiceClient_BeginBackup_apiManagementBackupWithAccessKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginBackup(ctx, "rg1", "apimService1", armapimanagement.ServiceBackupRestoreParameters{
		AccessKey:      to.Ptr("**************************************************"),
		AccessType:     to.Ptr(armapimanagement.AccessTypeAccessKey),
		BackupName:     to.Ptr("apimService1backup_2017_03_19"),
		ContainerName:  to.Ptr("backupContainer"),
		StorageAccount: to.Ptr("teststorageaccount"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAACXok="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(true),
	// 				GatewayRegionalURL: to.Ptr("https://apimService1-eastus-01.regional.azure-api.net"),
	// 				Location: to.Ptr("East US"),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("23.101.138.153")},
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](1),
	// 					},
	// 			}},
	// 			APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 				MinAPIVersion: to.Ptr("2019-01-01"),
	// 			},
	// 			CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-18T06:26:20.334Z"); return t}()),
	// 			CustomProperties: map[string]*string{
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 			},
	// 			DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 			DisableGateway: to.Ptr(false),
	// 			GatewayRegionalURL: to.Ptr("https://apimService1-westus-01.regional.azure-api.net"),
	// 			GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 			HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("apimService1.azure-api.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXB9C2C91F1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(true),
	// 					HostName: to.Ptr("gateway1.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeManagement),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXB9C2C91F1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("mgmt.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypePortal),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXB9C2C91F1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("portal1.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 			}},
	// 			ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 			NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 			PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			PublicIPAddresses: []*string{
	// 				to.Ptr("13.91.32.113")},
	// 				ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 				TargetProvisioningState: to.Ptr(""),
	// 				VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 				PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 				PublisherName: to.Ptr("autorestsdk"),
	// 			},
	// 			SKU: &armapimanagement.ServiceSKUProperties{
	// 				Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 				Capacity: to.Ptr[int32](1),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementBackupWithSystemManagedIdentity.json
func ExampleServiceClient_BeginBackup_apiManagementBackupWithSystemManagedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginBackup(ctx, "rg1", "apimService1", armapimanagement.ServiceBackupRestoreParameters{
		AccessType:     to.Ptr(armapimanagement.AccessTypeSystemAssignedManagedIdentity),
		BackupName:     to.Ptr("backup5"),
		ContainerName:  to.Ptr("apim-backups"),
		StorageAccount: to.Ptr("contosorpstorage"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"Owner": to.Ptr("apimService1"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAQM8o="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("00000000-5fb4-4916-95d4-64b306f9d924"),
	// 		TenantID: to.Ptr("00000000-86f1-0000-91ab-2d7cd011db47"),
	// 		UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/rg1UserIdentity": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("00000000-a154-4830-0000-46a12da1a1e2"),
	// 				PrincipalID: to.Ptr("00000000-a100-4478-0000-d65d98118ba0"),
	// 			},
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/vpnpremium": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("00000000-6328-4db2-0000-ab0e3e7806cf"),
	// 				PrincipalID: to.Ptr("00000000-9208-4128-af2d-a10d2af9b5a3"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("Central US EUAP"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-23T16:26:47.863Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-centraluseuap-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv1),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("52.XXXX.160.66")},
	// 			PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("apimService1@corp.microsoft.com"),
	// 			PublisherName: to.Ptr("MS"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-30T06:24:57.000Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("contoso@microsoft.com"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementBackupWithUserAssignedManagedIdentity.json
func ExampleServiceClient_BeginBackup_apiManagementBackupWithUserAssignedManagedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginBackup(ctx, "rg1", "apimService1", armapimanagement.ServiceBackupRestoreParameters{
		AccessType:     to.Ptr(armapimanagement.AccessTypeUserAssignedManagedIdentity),
		BackupName:     to.Ptr("backup5"),
		ClientID:       to.Ptr("XXXXX-a154-4830-XXXX-46a12da1a1e2"),
		ContainerName:  to.Ptr("apim-backups"),
		StorageAccount: to.Ptr("contosorpstorage"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"Owner": to.Ptr("apimService1"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAQM8o="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("00000000-5fb4-4916-95d4-64b306f9d924"),
	// 		TenantID: to.Ptr("00000000-86f1-0000-91ab-2d7cd011db47"),
	// 		UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/rg1UserIdentity": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("00000000-a154-4830-0000-46a12da1a1e2"),
	// 				PrincipalID: to.Ptr("00000000-a100-4478-0000-d65d98118ba0"),
	// 			},
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/vpnpremium": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("00000000-6328-4db2-0000-ab0e3e7806cf"),
	// 				PrincipalID: to.Ptr("00000000-9208-4128-af2d-a10d2af9b5a3"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("Central US EUAP"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-04-23T16:26:47.863Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-centraluseuap-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv1),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("52.XXXX.160.66")},
	// 			PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("apimService1@corp.microsoft.com"),
	// 			PublisherName: to.Ptr("MS"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-30T06:24:57.000Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("contoso@microsoft.com"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateMultiRegionServiceWithCustomHostname.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateMultiRegionServiceWithCustomHostname() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Location: to.Ptr("West US"),
		Properties: &armapimanagement.ServiceProperties{
			AdditionalLocations: []*armapimanagement.AdditionalLocation{
				{
					DisableGateway: to.Ptr(true),
					Location:       to.Ptr("East US"),
					SKU: &armapimanagement.ServiceSKUProperties{
						Name:     to.Ptr(armapimanagement.SKUTypePremium),
						Capacity: to.Ptr[int32](1),
					},
				}},
			APIVersionConstraint: &armapimanagement.APIVersionConstraint{
				MinAPIVersion: to.Ptr("2019-01-01"),
			},
			HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
				{
					Type:                to.Ptr(armapimanagement.HostnameTypeProxy),
					CertificatePassword: to.Ptr("Password"),
					DefaultSSLBinding:   to.Ptr(true),
					EncodedCertificate:  to.Ptr("****** Base 64 Encoded Certificate ************"),
					HostName:            to.Ptr("gateway1.msitesting.net"),
				},
				{
					Type:                to.Ptr(armapimanagement.HostnameTypeManagement),
					CertificatePassword: to.Ptr("Password"),
					EncodedCertificate:  to.Ptr("****** Base 64 Encoded Certificate ************"),
					HostName:            to.Ptr("mgmt.msitesting.net"),
				},
				{
					Type:                to.Ptr(armapimanagement.HostnameTypePortal),
					CertificatePassword: to.Ptr("Password"),
					EncodedCertificate:  to.Ptr("****** Base 64 Encoded Certificate ************"),
					HostName:            to.Ptr("portal1.msitesting.net"),
				}},
			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
			PublisherEmail:     to.Ptr("apim@autorestsdk.com"),
			PublisherName:      to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypePremium),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAACXok="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(true),
	// 				GatewayRegionalURL: to.Ptr("https://apimService1-eastus-01.regional.azure-api.net"),
	// 				Location: to.Ptr("East US"),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("23.101.138.153")},
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](1),
	// 					},
	// 			}},
	// 			APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 				MinAPIVersion: to.Ptr("2019-01-01"),
	// 			},
	// 			CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-18T06:26:20.334Z"); return t}()),
	// 			CustomProperties: map[string]*string{
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 			},
	// 			DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 			DisableGateway: to.Ptr(false),
	// 			GatewayRegionalURL: to.Ptr("https://apimService1-westus-01.regional.azure-api.net"),
	// 			GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 			HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("apimService1.azure-api.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXF1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(true),
	// 					HostName: to.Ptr("gateway1.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeManagement),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXF1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("mgmt.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypePortal),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.msitesting.net"),
	// 						Thumbprint: to.Ptr("8E989XXXXXXXXXXXXXXXXF1D174FDB3A2"),
	// 					},
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("portal1.msitesting.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 			}},
	// 			ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 			NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 			PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			PublicIPAddresses: []*string{
	// 				to.Ptr("13.91.32.113")},
	// 				ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 				TargetProvisioningState: to.Ptr(""),
	// 				VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 				PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 				PublisherName: to.Ptr("autorestsdk"),
	// 			},
	// 			SKU: &armapimanagement.ServiceSKUProperties{
	// 				Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 				Capacity: to.Ptr[int32](1),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateService.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateService() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"Name": to.Ptr("Contoso"),
			"Test": to.Ptr("User"),
		},
		Location: to.Ptr("South Central US"),
		Properties: &armapimanagement.ServiceProperties{
			PublisherEmail: to.Ptr("foo@contoso.com"),
			PublisherName:  to.Ptr("foo"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeDeveloper),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"api-version": to.Ptr("2022-08-01"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAmREI="),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-11T18:41:01.250Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-eastus-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv1),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("13.90.229.33")},
	// 			PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("samir@microsoft.com"),
	// 			PublisherName: to.Ptr("foo"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypeStandard),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-11T18:41:00.939Z"); return t}()),
	// 			CreatedBy: to.Ptr("user@contoso.com"),
	// 			CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-11T18:41:00.939Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("user@contoso.com"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceHavingMsi.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceHavingMsi() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Identity: &armapimanagement.ServiceIdentity{
			Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssigned),
		},
		Location: to.Ptr("West US"),
		Properties: &armapimanagement.ServiceProperties{
			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
			PublisherName:  to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeConsumption),
			Capacity: to.Ptr[int32](0),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAAWiU="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("dfb9a757-df69-4966-a8d0-711a9cd8ffb4"),
	// 		TenantID: to.Ptr("00000000-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-11T16:29:29.971Z"); return t}()),
	// 		EnableClientCertificate: to.Ptr(false),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionMtv1),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		TargetProvisioningState: to.Ptr(""),
	// 		VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 		PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 		PublisherName: to.Ptr("autorestsdk"),
	// 	},
	// 	SKU: &armapimanagement.ServiceSKUProperties{
	// 		Name: to.Ptr(armapimanagement.SKUTypeConsumption),
	// 		Capacity: to.Ptr[int32](0),
	// 	},
	// 	SystemData: &armapimanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceInVnetWithPublicIP.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceInVnetWithPublicIp() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Location: to.Ptr("East US 2 EUAP"),
		Properties: &armapimanagement.ServiceProperties{
			PublicIPAddressID: to.Ptr("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet"),
			VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
				SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant"),
			},
			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeExternal),
			PublisherEmail:     to.Ptr("apim@autorestsdk.com"),
			PublisherName:      to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypePremium),
			Capacity: to.Ptr[int32](2),
		},
		Zones: []*string{
			to.Ptr("1"),
			to.Ptr("2")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAGTAs="),
	// 	Location: to.Ptr("East US 2 EUAP"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-22T06:53:46.640Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-eastus2euap-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("20.47.137.XXX")},
	// 			PublicIPAddressID: to.Ptr("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/publicIPAddresses/apimazvnet"),
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 				SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rgName/providers/Microsoft.Network/virtualNetworks/apimcus/subnets/tenant"),
	// 			},
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeExternal),
	// 			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 			PublisherName: to.Ptr("autorestsdk"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](2),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 		},
	// 		Zones: []*string{
	// 			to.Ptr("1"),
	// 			to.Ptr("2")},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceInZones.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceInZones() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Location: to.Ptr("North europe"),
		Properties: &armapimanagement.ServiceProperties{
			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
			PublisherName:  to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypePremium),
			Capacity: to.Ptr[int32](2),
		},
		Zones: []*string{
			to.Ptr("1"),
			to.Ptr("2")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAiXvE="),
	// 	Location: to.Ptr("North Europe"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-07-28T23:18:14.656Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-northeurope-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("20.54.34.66")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 			PublisherName: to.Ptr("autorestsdk"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](2),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 		},
	// 		Zones: []*string{
	// 			to.Ptr("1"),
	// 			to.Ptr("2")},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceWithCustomHostnameKeyVault.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceWithCustomHostnameKeyVault() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Identity: &armapimanagement.ServiceIdentity{
			Type: to.Ptr(armapimanagement.ApimIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
				"/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Location: to.Ptr("North Europe"),
		Properties: &armapimanagement.ServiceProperties{
			APIVersionConstraint: &armapimanagement.APIVersionConstraint{
				MinAPIVersion: to.Ptr("2019-01-01"),
			},
			HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
				{
					Type:              to.Ptr(armapimanagement.HostnameTypeProxy),
					DefaultSSLBinding: to.Ptr(true),
					HostName:          to.Ptr("gateway1.msitesting.net"),
					IdentityClientID:  to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
					KeyVaultID:        to.Ptr("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
				},
				{
					Type:             to.Ptr(armapimanagement.HostnameTypeManagement),
					HostName:         to.Ptr("mgmt.msitesting.net"),
					IdentityClientID: to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
					KeyVaultID:       to.Ptr("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
				},
				{
					Type:             to.Ptr(armapimanagement.HostnameTypePortal),
					HostName:         to.Ptr("portal1.msitesting.net"),
					IdentityClientID: to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
					KeyVaultID:       to.Ptr("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
				}},
			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
			PublisherEmail:     to.Ptr("apim@autorestsdk.com"),
			PublisherName:      to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypePremium),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAigjU="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeUserAssigned),
	// 		TenantID: to.Ptr("f686d426-8d16-0000-0000-ab578e110ccd"),
	// 		UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
	// 				PrincipalID: to.Ptr("15e769b2-0000-0000-0000-3fd9a923ac3a"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("North Europe"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 			MinAPIVersion: to.Ptr("2019-01-01"),
	// 		},
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-13T22:30:20.775Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-northeurope-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(false),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 			},
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				Certificate: &armapimanagement.CertificateInformation{
	// 					Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2037-01-01T07:00:00.000Z"); return t}()),
	// 					Subject: to.Ptr("CN=*.msitesting.net"),
	// 					Thumbprint: to.Ptr("EA276907917CB5XXXXXXXXXXX690"),
	// 				},
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceKeyVault),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("gateway1.msitesting.net"),
	// 				IdentityClientID: to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
	// 				KeyVaultID: to.Ptr("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 			},
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeManagement),
	// 				Certificate: &armapimanagement.CertificateInformation{
	// 					Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2037-01-01T07:00:00.000Z"); return t}()),
	// 					Subject: to.Ptr("CN=*.msitesting.net"),
	// 					Thumbprint: to.Ptr("EA276907917CB5XXXXXXXXXXX690"),
	// 				},
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceKeyVault),
	// 				DefaultSSLBinding: to.Ptr(false),
	// 				HostName: to.Ptr("mgmt.msitesting.net"),
	// 				IdentityClientID: to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
	// 				KeyVaultID: to.Ptr("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 			},
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypePortal),
	// 				Certificate: &armapimanagement.CertificateInformation{
	// 					Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2037-01-01T07:00:00.000Z"); return t}()),
	// 					Subject: to.Ptr("CN=*.msitesting.net"),
	// 					Thumbprint: to.Ptr("EA276907917CB5XXXXXXXXXXX690"),
	// 				},
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceKeyVault),
	// 				DefaultSSLBinding: to.Ptr(false),
	// 				HostName: to.Ptr("portal1.msitesting.net"),
	// 				IdentityClientID: to.Ptr("329419bc-adec-4dce-9568-25a6d486e468"),
	// 				KeyVaultID: to.Ptr("https://rpbvtkeyvaultintegration.vault.azure.net/secrets/msitestingCert"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("40.112.74.192")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 			PublisherName: to.Ptr("autorestsdk"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceWithNatGatewayEnabled.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceWithNatGatewayEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Location: to.Ptr("East US"),
		Properties: &armapimanagement.ServiceProperties{
			NatGatewayState: to.Ptr(armapimanagement.NatGatewayStateEnabled),
			PublisherEmail:  to.Ptr("apim@autorestsdk.com"),
			PublisherName:   to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypePremium),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"api-version": to.Ptr("2022-08-01"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAmREI="),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 		},
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-26T18:41:01.250Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-eastus-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NatGatewayState: to.Ptr(armapimanagement.NatGatewayStateEnabled),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		OutboundPublicIPAddresses: []*string{
	// 			to.Ptr("60.0.0.0/31")},
	// 			PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 			PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			PublicIPAddresses: []*string{
	// 				to.Ptr("13.90.229.33")},
	// 				PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
	// 				ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 				TargetProvisioningState: to.Ptr(""),
	// 				VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 				PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 				PublisherName: to.Ptr("autorestsdk"),
	// 			},
	// 			SKU: &armapimanagement.ServiceSKUProperties{
	// 				Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 				Capacity: to.Ptr[int32](1),
	// 			},
	// 			SystemData: &armapimanagement.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-11T18:41:00.939Z"); return t}()),
	// 				CreatedBy: to.Ptr("user@contoso.com"),
	// 				CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-07-11T18:41:00.939Z"); return t}()),
	// 				LastModifiedBy: to.Ptr("user@contoso.com"),
	// 				LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceWithSystemCertificates.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceWithSystemCertificates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Location: to.Ptr("Central US"),
		Properties: &armapimanagement.ServiceProperties{
			Certificates: []*armapimanagement.CertificateConfiguration{
				{
					CertificatePassword: to.Ptr("Password"),
					EncodedCertificate:  to.Ptr("*******Base64 encoded Certificate******************"),
					StoreName:           to.Ptr(armapimanagement.CertificateConfigurationStoreNameCertificateAuthority),
				}},
			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
			PublisherName:  to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeBasic),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAp3UM="),
	// 	Location: to.Ptr("Central US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 		},
	// 		Certificates: []*armapimanagement.CertificateConfiguration{
	// 			{
	// 				Certificate: &armapimanagement.CertificateInformation{
	// 					Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2036-01-01T07:00:00.000Z"); return t}()),
	// 					Subject: to.Ptr("CN=*.msitesting.net"),
	// 					Thumbprint: to.Ptr("8E989652CABCF585ACBFCB9C2C91F1D174FDB3A2"),
	// 				},
	// 				StoreName: to.Ptr(armapimanagement.CertificateConfigurationStoreNameCertificateAuthority),
	// 		}},
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-18T06:33:28.090Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-centralus-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("40.113.223.117")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 			PublisherName: to.Ptr("autorestsdk"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypeBasic),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 		SystemData: &armapimanagement.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateServiceWithUserAssignedIdentity.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementCreateServiceWithUserAssignedIdentity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
			"tag3": to.Ptr("value3"),
		},
		Identity: &armapimanagement.ServiceIdentity{
			Type: to.Ptr(armapimanagement.ApimIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
				"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1": {},
			},
		},
		Location: to.Ptr("West US"),
		Properties: &armapimanagement.ServiceProperties{
			PublisherEmail: to.Ptr("apim@autorestsdk.com"),
			PublisherName:  to.Ptr("autorestsdk"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeConsumption),
			Capacity: to.Ptr[int32](0),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 		"tag3": to.Ptr("value3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAFzyk="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeUserAssigned),
	// 		TenantID: to.Ptr("00000000-86f1-41af-0000-2d7cd011db47"),
	// 		UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("5a2c6b8e-0905-0000-a772-993c9418137f"),
	// 				PrincipalID: to.Ptr("00000000-6e62-4649-9f54-a119fc1ba85e"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-03-12T01:05:33.457Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PlatformVersion: to.Ptr(armapimanagement.PlatformVersionMtv1),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		TargetProvisioningState: to.Ptr(""),
	// 		VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 		PublisherEmail: to.Ptr("apim@autorestsdk.com"),
	// 		PublisherName: to.Ptr("autorestsdk"),
	// 	},
	// 	SKU: &armapimanagement.ServiceSKUProperties{
	// 		Name: to.Ptr(armapimanagement.SKUTypeConsumption),
	// 		Capacity: to.Ptr[int32](0),
	// 	},
	// 	SystemData: &armapimanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUndelete.json
func ExampleServiceClient_BeginCreateOrUpdate_apiManagementUndelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginCreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceResource{
		Location: to.Ptr("South Central US"),
		Properties: &armapimanagement.ServiceProperties{
			Restore:        to.Ptr(true),
			PublisherEmail: to.Ptr("foo@contoso.com"),
			PublisherName:  to.Ptr("foo"),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypeDeveloper),
			Capacity: to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Etag: to.Ptr("AAAAAAAp3T4="),
	// 	Location: to.Ptr("South Central US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 		},
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-18T06:10:56.032Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-southcentralus-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("23.102.171.124")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("foo@contoso.com"),
	// 			PublisherName: to.Ptr("foo"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypeDeveloper),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUpdateServiceDisableTls10.json
func ExampleServiceClient_BeginUpdate_apiManagementUpdateServiceDisableTls10() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceUpdateParameters{
		Properties: &armapimanagement.ServiceUpdateProperties{
			CustomProperties: map[string]*string{
				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"Owner": to.Ptr("sasolank"),
	// 		"Pool": to.Ptr("Manual"),
	// 		"Reserved": to.Ptr(""),
	// 		"TestExpiration": to.Ptr("Thu, 29 Jun 2017 18:50:40 GMT"),
	// 		"TestSuiteExpiration": to.Ptr("Thu, 29 Jun 2017 18:51:46 GMT"),
	// 		"UID": to.Ptr("4f5025fe-0669-4e2e-8320-5199466e5eb3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAYRPs="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-29T17:50:42.319Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 		},
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 		},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("40.86.176.232")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("admin@live.com"),
	// 			PublisherName: to.Ptr("Contoso"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypeStandard),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUpdateServicePublisherDetails.json
func ExampleServiceClient_BeginUpdate_apiManagementUpdateServicePublisherDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceUpdateParameters{
		Properties: &armapimanagement.ServiceUpdateProperties{
			PublisherEmail: to.Ptr("foobar@live.com"),
			PublisherName:  to.Ptr("Contoso Vnext"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"Owner": to.Ptr("sasolank"),
	// 		"Pool": to.Ptr("Manual"),
	// 		"Reserved": to.Ptr(""),
	// 		"TestExpiration": to.Ptr("Thu, 29 Jun 2017 18:50:40 GMT"),
	// 		"TestSuiteExpiration": to.Ptr("Thu, 29 Jun 2017 18:51:46 GMT"),
	// 		"UID": to.Ptr("4f5025fe-0669-4e2e-8320-5199466e5eb3"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAYRPs="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-29T17:50:42.319Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
	// 		},
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 		},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("40.86.176.232")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 			PublisherEmail: to.Ptr("foobar@live.com"),
	// 			PublisherName: to.Ptr("Contoso Vnext"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypeStandard),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUpdateServiceToNewVnetAndAZs.json
func ExampleServiceClient_BeginUpdate_apiManagementUpdateServiceToNewVnetAndAvailabilityZones() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginUpdate(ctx, "rg1", "apimService1", armapimanagement.ServiceUpdateParameters{
		Properties: &armapimanagement.ServiceUpdateProperties{
			AdditionalLocations: []*armapimanagement.AdditionalLocation{
				{
					Location:          to.Ptr("Australia East"),
					PublicIPAddressID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/apim-australia-east-publicip"),
					SKU: &armapimanagement.ServiceSKUProperties{
						Name:     to.Ptr(armapimanagement.SKUTypePremium),
						Capacity: to.Ptr[int32](3),
					},
					VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
						SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/apimaeavnet/subnets/default"),
					},
					Zones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
				}},
			PublicIPAddressID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/publicip-apim-japan-east"),
			VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
				SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-apim-japaneast/subnets/apim2"),
			},
			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeExternal),
		},
		SKU: &armapimanagement.ServiceSKUProperties{
			Name:     to.Ptr(armapimanagement.SKUTypePremium),
			Capacity: to.Ptr[int32](3),
		},
		Zones: []*string{
			to.Ptr("1"),
			to.Ptr("2"),
			to.Ptr("3")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Etag: to.Ptr("AAAAAAAWBIU="),
	// 	Location: to.Ptr("Japan East"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://apimService1-australiaeast-01.regional.azure-api.net"),
	// 				Location: to.Ptr("Australia East"),
	// 				PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("20.213.1.35")},
	// 					PublicIPAddressID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/apim-australia-east-publicip"),
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](3),
	// 					},
	// 					VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 						SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/apimaeavnet/subnets/default"),
	// 					},
	// 					Zones: []*string{
	// 						to.Ptr("1"),
	// 						to.Ptr("2"),
	// 						to.Ptr("3")},
	// 				}},
	// 				CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-08T23:41:35.644Z"); return t}()),
	// 				CustomProperties: map[string]*string{
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_GCM_SHA256": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_CBC_SHA": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_256_CBC_SHA256": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
	// 				},
	// 				DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://apimService1-japaneast-01.regional.azure-api.net"),
	// 				GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 				HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 					{
	// 						Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 						CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 						DefaultSSLBinding: to.Ptr(false),
	// 						HostName: to.Ptr("apimService1.azure-api.net"),
	// 						NegotiateClientCertificate: to.Ptr(false),
	// 					},
	// 					{
	// 						Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 						Certificate: &armapimanagement.CertificateInformation{
	// 							Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-06-09T23:59:59.000Z"); return t}()),
	// 							Subject: to.Ptr("CN=mycustomdomain.int-azure-api.net"),
	// 							Thumbprint: to.Ptr("2994B5FFB8F76B3C687D324A8DEE0432C1ED18CD"),
	// 						},
	// 						CertificateSource: to.Ptr(armapimanagement.CertificateSourceManaged),
	// 						DefaultSSLBinding: to.Ptr(true),
	// 						HostName: to.Ptr("mycustomdomain.int-azure-api.net"),
	// 						NegotiateClientCertificate: to.Ptr(false),
	// 				}},
	// 				ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 				NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 				PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 				PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("20.78.248.217")},
	// 					PublicIPAddressID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/publicip-apim-japan-east"),
	// 					PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
	// 					ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 					TargetProvisioningState: to.Ptr(""),
	// 					VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 						SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet-apim-japaneast/subnets/apim2"),
	// 					},
	// 					VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeInternal),
	// 					PublisherEmail: to.Ptr("contoso@microsoft.com"),
	// 					PublisherName: to.Ptr("apimPublisher"),
	// 				},
	// 				SKU: &armapimanagement.ServiceSKUProperties{
	// 					Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 					Capacity: to.Ptr[int32](3),
	// 				},
	// 				SystemData: &armapimanagement.SystemData{
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-21T20:04:21.610Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("contoso@microsoft.com"),
	// 					LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 				},
	// 				Zones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceGetMultiRegionInternalVnet.json
func ExampleServiceClient_Get_apiManagementServiceGetMultiRegionInternalVnet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServiceClient().Get(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimservice1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimservice1"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAADqC0c="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://apimservice1-westus2-01.regional.azure-api.net"),
	// 				Location: to.Ptr("West US 2"),
	// 				PrivateIPAddresses: []*string{
	// 					to.Ptr("10.0.X.6")},
	// 					PublicIPAddresses: []*string{
	// 						to.Ptr("40.XXX.79.187")},
	// 						SKU: &armapimanagement.ServiceSKUProperties{
	// 							Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 							Capacity: to.Ptr[int32](1),
	// 						},
	// 						VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 							SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/APIMVNet/subnets/apim-internal-sub"),
	// 						},
	// 				}},
	// 				APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 				},
	// 				CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-02T01:42:09.126Z"); return t}()),
	// 				CustomProperties: map[string]*string{
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("True"),
	// 				},
	// 				DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://apimservice1-westus-01.regional.azure-api.net"),
	// 				GatewayURL: to.Ptr("https://apimservice1.azure-api.net"),
	// 				HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 					{
	// 						Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 						CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 						DefaultSSLBinding: to.Ptr(false),
	// 						HostName: to.Ptr("apimService1.azure-api.net"),
	// 						NegotiateClientCertificate: to.Ptr(false),
	// 					},
	// 					{
	// 						Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 						Certificate: &armapimanagement.CertificateInformation{
	// 							Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-16T16:51:34.000Z"); return t}()),
	// 							Subject: to.Ptr("CN=*.preview.net"),
	// 							Thumbprint: to.Ptr("B4330123DBAXXXXXXXXX1F35E84493476"),
	// 						},
	// 						CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
	// 						DefaultSSLBinding: to.Ptr(true),
	// 						HostName: to.Ptr("apimgatewaytest.preview.net"),
	// 						NegotiateClientCertificate: to.Ptr(false),
	// 				}},
	// 				ManagementAPIURL: to.Ptr("https://apimservice1.management.azure-api.net"),
	// 				NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 				PortalURL: to.Ptr("https://apimservice1.portal.azure-api.net"),
	// 				PrivateIPAddresses: []*string{
	// 					to.Ptr("172.XX.0.5")},
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					PublicIPAddresses: []*string{
	// 						to.Ptr("137.XXX.11.74")},
	// 						ScmURL: to.Ptr("https://apimservice1.scm.azure-api.net"),
	// 						TargetProvisioningState: to.Ptr(""),
	// 						VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 							SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/apim-appGateway-vnet/subnets/apim-subnet"),
	// 						},
	// 						VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeInternal),
	// 						PublisherEmail: to.Ptr("abcs@contoso.com"),
	// 						PublisherName: to.Ptr("contoso publisher"),
	// 					},
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](1),
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceGetService.json
func ExampleServiceClient_Get_apiManagementServiceGetService() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServiceClient().Get(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("OGF-Z3-06162021-Premium"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/OGF-Z3-06162021-Premium"),
	// 	Tags: map[string]*string{
	// 		"ReleaseName": to.Ptr("Z3"),
	// 		"owner": to.Ptr("v-aswmoh"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAWN/4="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("306205e7-b21a-41bf-92e2-3e28af30041e"),
	// 		TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
	// 		UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ogf-identity": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("8d9791f2-0cdf-41f4-9e66-cdc39b496789"),
	// 				PrincipalID: to.Ptr("713784d2-ee37-412a-95f0-3768f397f82d"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-premium-eastus2-01.regional.azure-api.net"),
	// 				Location: to.Ptr("East US 2"),
	// 				PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("40.70.24.106")},
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](1),
	// 					},
	// 					Zones: []*string{
	// 					},
	// 			}},
	// 			APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 				MinAPIVersion: to.Ptr("2019-12-01"),
	// 			},
	// 			Certificates: []*armapimanagement.CertificateConfiguration{
	// 			},
	// 			CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:40:00.945Z"); return t}()),
	// 			CustomProperties: map[string]*string{
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
	// 				"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
	// 			},
	// 			DeveloperPortalURL: to.Ptr("https://ogf-z3-06162021-premium.developer.azure-api.net"),
	// 			DisableGateway: to.Ptr(false),
	// 			GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-premium-eastus-01.regional.azure-api.net"),
	// 			GatewayURL: to.Ptr("https://ogf-z3-06162021-premium.azure-api.net"),
	// 			HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("ogf-z3-06162021-premium.azure-api.net"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
	// 						Thumbprint: to.Ptr("BA0C286XXXXXXXX58A4A507E3DBD51"),
	// 					},
	// 					CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
	// 					DefaultSSLBinding: to.Ptr(true),
	// 					HostName: to.Ptr("gateway.current.int-azure-api.net"),
	// 					KeyVaultID: to.Ptr("https://ogf-testing.vault.azure.net/secrets/current-ssl"),
	// 					NegotiateClientCertificate: to.Ptr(true),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeDeveloperPortal),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
	// 						Thumbprint: to.Ptr("BA0C286XXXXXXXX58A4A507E3DBD51"),
	// 					},
	// 					CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("developer.current.int-azure-api.net"),
	// 					KeyVaultID: to.Ptr("https://ogf-testing.vault.azure.net/secrets/current-ssl"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 				},
	// 				{
	// 					Type: to.Ptr(armapimanagement.HostnameTypeManagement),
	// 					Certificate: &armapimanagement.CertificateInformation{
	// 						Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
	// 						Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
	// 						Thumbprint: to.Ptr("BA0C286XXXXXXXX58A4A507E3DBD51"),
	// 					},
	// 					CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
	// 					DefaultSSLBinding: to.Ptr(false),
	// 					HostName: to.Ptr("mgmt.current.int-azure-api.net"),
	// 					KeyVaultID: to.Ptr("https://ogf-testing.vault.azure.net/secrets/current-ssl"),
	// 					NegotiateClientCertificate: to.Ptr(false),
	// 			}},
	// 			ManagementAPIURL: to.Ptr("https://ogf-z3-06162021-premium.management.azure-api.net"),
	// 			NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 			PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv2),
	// 			PortalURL: to.Ptr("https://ogf-z3-06162021-premium.portal.azure-api.net"),
	// 			PrivateEndpointConnections: []*armapimanagement.RemotePrivateEndpointConnectionWrapper{
	// 				{
	// 					Name: to.Ptr("privateEndpointProxyName"),
	// 					Type: to.Ptr("Microsoft.ApiManagement/service/privateEndpointConnections"),
	// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/privateEndpointConnections/privateEndpointProxyName"),
	// 					Properties: &armapimanagement.PrivateEndpointConnectionWrapperProperties{
	// 						GroupIDs: []*string{
	// 							to.Ptr("Gateway")},
	// 							PrivateEndpoint: &armapimanagement.ArmIDWrapper{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/privateEndpoints/privateEndpointName"),
	// 							},
	// 							PrivateLinkServiceConnectionState: &armapimanagement.PrivateLinkServiceConnectionState{
	// 								Description: to.Ptr("Please approve my request, thanks"),
	// 								ActionsRequired: to.Ptr("None"),
	// 								Status: to.Ptr(armapimanagement.PrivateEndpointServiceConnectionStatusPending),
	// 							},
	// 							ProvisioningState: to.Ptr("Succeeded"),
	// 						},
	// 				}},
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				PublicIPAddresses: []*string{
	// 					to.Ptr("13.92.130.49")},
	// 					PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
	// 					ScmURL: to.Ptr("https://ogf-z3-06162021-premium.scm.azure-api.net"),
	// 					TargetProvisioningState: to.Ptr(""),
	// 					VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
	// 					PublisherEmail: to.Ptr("string"),
	// 					PublisherName: to.Ptr("Test Premium"),
	// 				},
	// 				SKU: &armapimanagement.ServiceSKUProperties{
	// 					Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 					Capacity: to.Ptr[int32](1),
	// 				},
	// 				SystemData: &armapimanagement.SystemData{
	// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:40:00.710Z"); return t}()),
	// 					CreatedBy: to.Ptr("string"),
	// 					CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-20T06:33:09.615Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("foo@contoso.com"),
	// 					LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceGetServiceHavingMsi.json
func ExampleServiceClient_Get_apiManagementServiceGetServiceHavingMsi() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServiceClient().Get(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAAAENfI="),
	// 	Identity: &armapimanagement.ServiceIdentity{
	// 		Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("ca1d33f7-0000-42ec-0000-d526a1ee953a"),
	// 		TenantID: to.Ptr("72f988bf-0000-41af-0000-2d7cd011db47"),
	// 		UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
	// 			"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/apimService1": &armapimanagement.UserIdentityProperties{
	// 				ClientID: to.Ptr("aaff9c7d-0000-4db2-0000-ab0e3e7806cf"),
	// 				PrincipalID: to.Ptr("95194df2-9208-0000-0000-a10d2af9b5a3"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("West Europe"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2016-04-12T00:20:15.601Z"); return t}()),
	// 		CustomProperties: map[string]*string{
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("True"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("True"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("True"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("True"),
	// 			"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("True"),
	// 		},
	// 		DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 		DisableGateway: to.Ptr(false),
	// 		GatewayRegionalURL: to.Ptr("https://apimService1-westeurope-01.regional.azure-api.net"),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 				DefaultSSLBinding: to.Ptr(false),
	// 				HostName: to.Ptr("apimService1.azure-api.net"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 			},
	// 			{
	// 				Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 				Certificate: &armapimanagement.CertificateInformation{
	// 					Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-18T11:11:47.000Z"); return t}()),
	// 					Subject: to.Ptr("CN=*.msitesting.net"),
	// 					Thumbprint: to.Ptr("9833D531D7A45XXXXXA85908BD3692E0BD3F"),
	// 				},
	// 				CertificateSource: to.Ptr(armapimanagement.CertificateSourceKeyVault),
	// 				DefaultSSLBinding: to.Ptr(true),
	// 				HostName: to.Ptr("proxy.msitesting.net"),
	// 				KeyVaultID: to.Ptr("https://samir-msi-keyvault.vault.azure.net/secrets/msicertificate"),
	// 				NegotiateClientCertificate: to.Ptr(false),
	// 		}},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("13.94.xxx.188")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 				SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/dfVirtualNetwork/subnets/backendSubnet"),
	// 			},
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeExternal),
	// 			PublisherEmail: to.Ptr("foo@contoso.com"),
	// 			PublisherName: to.Ptr("Contoso"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceDeleteService.json
func ExampleServiceClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginDelete(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceMigrateToStv2.json
func ExampleServiceClient_BeginMigrateToStv2() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginMigrateToStv2(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimservice1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimservice1"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Etag: to.Ptr("AAAAAADqC0c="),
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		AdditionalLocations: []*armapimanagement.AdditionalLocation{
	// 			{
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://apimservice1-westus2-01.regional.azure-api.net"),
	// 				Location: to.Ptr("West US 2"),
	// 				PrivateIPAddresses: []*string{
	// 					to.Ptr("10.0.X.6")},
	// 					PublicIPAddresses: []*string{
	// 						to.Ptr("40.XXX.79.187")},
	// 						SKU: &armapimanagement.ServiceSKUProperties{
	// 							Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 							Capacity: to.Ptr[int32](1),
	// 						},
	// 						VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 							SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/APIMVNet/subnets/apim-internal-sub"),
	// 						},
	// 				}},
	// 				APIVersionConstraint: &armapimanagement.APIVersionConstraint{
	// 				},
	// 				CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-12-02T01:42:09.126Z"); return t}()),
	// 				CustomProperties: map[string]*string{
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("True"),
	// 					"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("True"),
	// 				},
	// 				DeveloperPortalURL: to.Ptr("https://apimService1.developer.azure-api.net"),
	// 				DisableGateway: to.Ptr(false),
	// 				GatewayRegionalURL: to.Ptr("https://apimservice1-westus-01.regional.azure-api.net"),
	// 				GatewayURL: to.Ptr("https://apimservice1.azure-api.net"),
	// 				HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 					{
	// 						Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 						CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
	// 						DefaultSSLBinding: to.Ptr(false),
	// 						HostName: to.Ptr("apimService1.azure-api.net"),
	// 						NegotiateClientCertificate: to.Ptr(false),
	// 					},
	// 					{
	// 						Type: to.Ptr(armapimanagement.HostnameTypeProxy),
	// 						Certificate: &armapimanagement.CertificateInformation{
	// 							Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-16T16:51:34.000Z"); return t}()),
	// 							Subject: to.Ptr("CN=*.preview.net"),
	// 							Thumbprint: to.Ptr("B4330123DBAXXXXXXXXX1F35E84493476"),
	// 						},
	// 						CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
	// 						DefaultSSLBinding: to.Ptr(true),
	// 						HostName: to.Ptr("apimgatewaytest.preview.net"),
	// 						NegotiateClientCertificate: to.Ptr(false),
	// 				}},
	// 				ManagementAPIURL: to.Ptr("https://apimservice1.management.azure-api.net"),
	// 				NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
	// 				PlatformVersion: to.Ptr(armapimanagement.PlatformVersionStv1),
	// 				PortalURL: to.Ptr("https://apimservice1.portal.azure-api.net"),
	// 				PrivateIPAddresses: []*string{
	// 					to.Ptr("172.XX.0.5")},
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					PublicIPAddresses: []*string{
	// 						to.Ptr("137.XXX.11.74")},
	// 						ScmURL: to.Ptr("https://apimservice1.scm.azure-api.net"),
	// 						TargetProvisioningState: to.Ptr(""),
	// 						VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 							SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/apim-appGateway-vnet/subnets/apim-subnet"),
	// 						},
	// 						VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeInternal),
	// 						PublisherEmail: to.Ptr("abcs@contoso.com"),
	// 						PublisherName: to.Ptr("contoso publisher"),
	// 					},
	// 					SKU: &armapimanagement.ServiceSKUProperties{
	// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 						Capacity: to.Ptr[int32](1),
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListServiceBySubscriptionAndResourceGroup.json
func ExampleServiceClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServiceClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceListResult = armapimanagement.ServiceListResult{
		// 	Value: []*armapimanagement.ServiceResource{
		// 		{
		// 			Name: to.Ptr("OGF-Z3-06162021-Premium"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/OGF-Z3-06162021-Premium"),
		// 			Tags: map[string]*string{
		// 				"ReleaseName": to.Ptr("Z3"),
		// 				"owner": to.Ptr("v-aswmoh"),
		// 			},
		// 			Etag: to.Ptr("AAAAAAAWN/4="),
		// 			Identity: &armapimanagement.ServiceIdentity{
		// 				Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("306205e7-b21a-41bf-92e2-3e28af30041e"),
		// 				TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 				UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
		// 					"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ogf-identity": &armapimanagement.UserIdentityProperties{
		// 						ClientID: to.Ptr("8d9791f2-0cdf-41f4-9e66-cdc39b496789"),
		// 						PrincipalID: to.Ptr("713784d2-ee37-412a-95f0-3768f397f82d"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armapimanagement.ServiceProperties{
		// 				AdditionalLocations: []*armapimanagement.AdditionalLocation{
		// 					{
		// 						DisableGateway: to.Ptr(false),
		// 						GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-premium-eastus2-01.regional.azure-api.net"),
		// 						Location: to.Ptr("East US 2"),
		// 						PublicIPAddresses: []*string{
		// 							to.Ptr("40.70.24.106")},
		// 							SKU: &armapimanagement.ServiceSKUProperties{
		// 								Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 								Capacity: to.Ptr[int32](1),
		// 							},
		// 							Zones: []*string{
		// 							},
		// 					}},
		// 					APIVersionConstraint: &armapimanagement.APIVersionConstraint{
		// 						MinAPIVersion: to.Ptr("2019-12-01"),
		// 					},
		// 					Certificates: []*armapimanagement.CertificateConfiguration{
		// 					},
		// 					CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:40:00.945Z"); return t}()),
		// 					CustomProperties: map[string]*string{
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
		// 					},
		// 					DeveloperPortalURL: to.Ptr("https://ogf-z3-06162021-premium.developer.azure-api.net"),
		// 					DisableGateway: to.Ptr(false),
		// 					GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-premium-eastus-01.regional.azure-api.net"),
		// 					GatewayURL: to.Ptr("https://ogf-z3-06162021-premium.azure-api.net"),
		// 					HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 							DefaultSSLBinding: to.Ptr(false),
		// 							HostName: to.Ptr("ogf-z3-06162021-premium.azure-api.net"),
		// 							NegotiateClientCertificate: to.Ptr(false),
		// 						},
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 							Certificate: &armapimanagement.CertificateInformation{
		// 								Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
		// 								Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
		// 								Thumbprint: to.Ptr("BA0C286F71AF3B6A01BDB240C58A4A507E3DBD51"),
		// 							},
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
		// 							DefaultSSLBinding: to.Ptr(true),
		// 							HostName: to.Ptr("gateway.current.int-azure-api.net"),
		// 							KeyVaultID: to.Ptr("https://ogf-testing.vault-int.azure-int.net/secrets/current-ssl"),
		// 							NegotiateClientCertificate: to.Ptr(true),
		// 						},
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeDeveloperPortal),
		// 							Certificate: &armapimanagement.CertificateInformation{
		// 								Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
		// 								Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
		// 								Thumbprint: to.Ptr("BA0C286F71AF3B6A01BDB240C58A4A507E3DBD51"),
		// 							},
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
		// 							DefaultSSLBinding: to.Ptr(false),
		// 							HostName: to.Ptr("developer.current.int-azure-api.net"),
		// 							KeyVaultID: to.Ptr("https://ogf-testing.vault-int.azure-int.net/secrets/current-ssl"),
		// 							NegotiateClientCertificate: to.Ptr(false),
		// 						},
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeManagement),
		// 							Certificate: &armapimanagement.CertificateInformation{
		// 								Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
		// 								Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
		// 								Thumbprint: to.Ptr("BA0C286F71AF3B6A01BDB240C58A4A507E3DBD51"),
		// 							},
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
		// 							DefaultSSLBinding: to.Ptr(false),
		// 							HostName: to.Ptr("mgmt.current.int-azure-api.net"),
		// 							KeyVaultID: to.Ptr("https://ogf-testing.vault-int.azure-int.net/secrets/current-ssl"),
		// 							NegotiateClientCertificate: to.Ptr(false),
		// 					}},
		// 					ManagementAPIURL: to.Ptr("https://ogf-z3-06162021-premium.management.azure-api.net"),
		// 					NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 					PortalURL: to.Ptr("https://ogf-z3-06162021-premium.portal.azure-api.net"),
		// 					ProvisioningState: to.Ptr("Succeeded"),
		// 					PublicIPAddresses: []*string{
		// 						to.Ptr("13.92.130.49")},
		// 						PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 						ScmURL: to.Ptr("https://ogf-z3-06162021-premium.scm.azure-api.net"),
		// 						TargetProvisioningState: to.Ptr(""),
		// 						VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 						PublisherEmail: to.Ptr("bar@contoso.com"),
		// 						PublisherName: to.Ptr("Test Premium"),
		// 					},
		// 					SKU: &armapimanagement.ServiceSKUProperties{
		// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 						Capacity: to.Ptr[int32](1),
		// 					},
		// 					SystemData: &armapimanagement.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:40:00.710Z"); return t}()),
		// 						CreatedBy: to.Ptr("bar@contoso.com"),
		// 						CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-20T06:33:09.615Z"); return t}()),
		// 						LastModifiedBy: to.Ptr("foo@contoso.com"),
		// 						LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("vvktestcons"),
		// 					Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/vvktestcons"),
		// 					Tags: map[string]*string{
		// 						"Owner": to.Ptr("vitaliik"),
		// 					},
		// 					Etag: to.Ptr("AAAAAAAWKwo="),
		// 					Location: to.Ptr("East US"),
		// 					Properties: &armapimanagement.ServiceProperties{
		// 						CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-10T18:07:23.456Z"); return t}()),
		// 						CustomProperties: map[string]*string{
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
		// 						},
		// 						DisableGateway: to.Ptr(false),
		// 						EnableClientCertificate: to.Ptr(false),
		// 						GatewayURL: to.Ptr("https://vvktestcons.azure-api.net"),
		// 						HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 							{
		// 								Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 								CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 								DefaultSSLBinding: to.Ptr(true),
		// 								HostName: to.Ptr("vvktestcons.azure-api.net"),
		// 								NegotiateClientCertificate: to.Ptr(false),
		// 						}},
		// 						NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 						TargetProvisioningState: to.Ptr(""),
		// 						VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 						PublisherEmail: to.Ptr("bar@contoso.com"),
		// 						PublisherName: to.Ptr("vvktestcons"),
		// 					},
		// 					SKU: &armapimanagement.ServiceSKUProperties{
		// 						Name: to.Ptr(armapimanagement.SKUTypeConsumption),
		// 						Capacity: to.Ptr[int32](0),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("OGF-Z3-06162021-Standard"),
		// 					Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/OGF-Z3-06162021-Standard"),
		// 					Tags: map[string]*string{
		// 					},
		// 					Etag: to.Ptr("AAAAAAAWF7M="),
		// 					Identity: &armapimanagement.ServiceIdentity{
		// 						Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
		// 						PrincipalID: to.Ptr("347a5800-ca99-475a-9202-fe38ca79ee41"),
		// 						TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 						UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
		// 							"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ogf-identity": &armapimanagement.UserIdentityProperties{
		// 								ClientID: to.Ptr("8d9791f2-0cdf-41f4-9e66-cdc39b496789"),
		// 								PrincipalID: to.Ptr("713784d2-ee37-412a-95f0-3768f397f82d"),
		// 							},
		// 						},
		// 					},
		// 					Location: to.Ptr("East US"),
		// 					Properties: &armapimanagement.ServiceProperties{
		// 						APIVersionConstraint: &armapimanagement.APIVersionConstraint{
		// 							MinAPIVersion: to.Ptr("2019-12-01"),
		// 						},
		// 						CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:39:58.655Z"); return t}()),
		// 						CustomProperties: map[string]*string{
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA": to.Ptr("true"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
		// 						},
		// 						DeveloperPortalURL: to.Ptr("https://ogf-z3-06162021-standard.developer.azure-api.net"),
		// 						DisableGateway: to.Ptr(false),
		// 						GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-standard-eastus-01.regional.azure-api.net"),
		// 						GatewayURL: to.Ptr("https://ogf-z3-06162021-standard.azure-api.net"),
		// 						HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 							{
		// 								Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 								CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 								DefaultSSLBinding: to.Ptr(true),
		// 								HostName: to.Ptr("ogf-z3-06162021-standard.azure-api.net"),
		// 								NegotiateClientCertificate: to.Ptr(false),
		// 						}},
		// 						ManagementAPIURL: to.Ptr("https://ogf-z3-06162021-standard.management.azure-api.net"),
		// 						NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 						PortalURL: to.Ptr("https://ogf-z3-06162021-standard.portal.azure-api.net"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						PublicIPAddresses: []*string{
		// 							to.Ptr("13.82.208.32")},
		// 							PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 							ScmURL: to.Ptr("https://ogf-z3-06162021-standard.scm.azure-api.net"),
		// 							TargetProvisioningState: to.Ptr(""),
		// 							VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 							PublisherEmail: to.Ptr("bar@contoso.com"),
		// 							PublisherName: to.Ptr("Test Standard"),
		// 						},
		// 						SKU: &armapimanagement.ServiceSKUProperties{
		// 							Name: to.Ptr(armapimanagement.SKUTypeStandard),
		// 							Capacity: to.Ptr[int32](2),
		// 						},
		// 						SystemData: &armapimanagement.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:39:58.459Z"); return t}()),
		// 							CreatedBy: to.Ptr("bar@contoso.com"),
		// 							CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-17T15:05:13.549Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("bar@contoso.com"),
		// 							LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("ogf-dev-060921"),
		// 						Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/ogf-dev-060921"),
		// 						Tags: map[string]*string{
		// 						},
		// 						Etag: to.Ptr("AAAAAAAWEFg="),
		// 						Identity: &armapimanagement.ServiceIdentity{
		// 							Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssigned),
		// 							PrincipalID: to.Ptr("c9bd4c05-205e-4431-b232-112cf2e9e0aa"),
		// 							TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 						},
		// 						Location: to.Ptr("East US"),
		// 						Properties: &armapimanagement.ServiceProperties{
		// 							AdditionalLocations: []*armapimanagement.AdditionalLocation{
		// 								{
		// 									DisableGateway: to.Ptr(false),
		// 									GatewayRegionalURL: to.Ptr("https://ogf-dev-060921-southcentralus-01.regional.azure-api.net"),
		// 									Location: to.Ptr("South Central US"),
		// 									PublicIPAddresses: []*string{
		// 										to.Ptr("13.84.208.29")},
		// 										SKU: &armapimanagement.ServiceSKUProperties{
		// 											Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 											Capacity: to.Ptr[int32](9),
		// 										},
		// 										Zones: []*string{
		// 										},
		// 								}},
		// 								APIVersionConstraint: &armapimanagement.APIVersionConstraint{
		// 									MinAPIVersion: to.Ptr("2019-12-01"),
		// 								},
		// 								Certificates: []*armapimanagement.CertificateConfiguration{
		// 									{
		// 										Certificate: &armapimanagement.CertificateInformation{
		// 											Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-25T22:51:47.000Z"); return t}()),
		// 											Subject: to.Ptr("CN=*.apim.net"),
		// 											Thumbprint: to.Ptr("4E8234312EC69245D1AE296C4882D46FB84076A3"),
		// 										},
		// 										StoreName: to.Ptr(armapimanagement.CertificateConfigurationStoreNameRoot),
		// 								}},
		// 								CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T10:06:22.213Z"); return t}()),
		// 								CustomProperties: map[string]*string{
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
		// 								},
		// 								DeveloperPortalURL: to.Ptr("https://ogf-dev-060921.developer.azure-api.net"),
		// 								DisableGateway: to.Ptr(false),
		// 								GatewayRegionalURL: to.Ptr("https://ogf-dev-060921-eastus-01.regional.azure-api.net"),
		// 								GatewayURL: to.Ptr("https://ogf-dev-060921.azure-api.net"),
		// 								HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 									{
		// 										Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 										CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 										DefaultSSLBinding: to.Ptr(true),
		// 										HostName: to.Ptr("ogf-dev-060921.azure-api.net"),
		// 										NegotiateClientCertificate: to.Ptr(false),
		// 								}},
		// 								ManagementAPIURL: to.Ptr("https://ogf-dev-060921.management.azure-api.net"),
		// 								NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 								PortalURL: to.Ptr("https://ogf-dev-060921.portal.azure-api.net"),
		// 								ProvisioningState: to.Ptr("Succeeded"),
		// 								PublicIPAddresses: []*string{
		// 									to.Ptr("168.62.39.172")},
		// 									PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 									ScmURL: to.Ptr("https://ogf-dev-060921.scm.azure-api.net"),
		// 									TargetProvisioningState: to.Ptr(""),
		// 									VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 									PublisherEmail: to.Ptr("v-ssaiprasan@microsoft.com"),
		// 									PublisherName: to.Ptr("TechM"),
		// 								},
		// 								SKU: &armapimanagement.ServiceSKUProperties{
		// 									Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 									Capacity: to.Ptr[int32](3),
		// 								},
		// 								SystemData: &armapimanagement.SystemData{
		// 									CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T10:06:21.733Z"); return t}()),
		// 									CreatedBy: to.Ptr("v-ssaiprasan@microsoft.com"),
		// 									CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 									LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T14:27:05.546Z"); return t}()),
		// 									LastModifiedBy: to.Ptr("v-ssaiprasan@microsoft.com"),
		// 									LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 								},
		// 						}},
		// 					}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListServiceBySubscription.json
func ExampleServiceClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServiceClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceListResult = armapimanagement.ServiceListResult{
		// 	Value: []*armapimanagement.ServiceResource{
		// 		{
		// 			Name: to.Ptr("OGF-Z3-06162021-Premium"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/OGF-Z3-06162021-Premium"),
		// 			Tags: map[string]*string{
		// 				"ReleaseName": to.Ptr("Z3"),
		// 				"owner": to.Ptr("v-aswmoh"),
		// 			},
		// 			Etag: to.Ptr("AAAAAAAWN/4="),
		// 			Identity: &armapimanagement.ServiceIdentity{
		// 				Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("306205e7-b21a-41bf-92e2-3e28af30041e"),
		// 				TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 				UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
		// 					"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ogf-identity": &armapimanagement.UserIdentityProperties{
		// 						ClientID: to.Ptr("8d9791f2-0cdf-41f4-9e66-cdc39b496789"),
		// 						PrincipalID: to.Ptr("713784d2-ee37-412a-95f0-3768f397f82d"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("East US"),
		// 			Properties: &armapimanagement.ServiceProperties{
		// 				AdditionalLocations: []*armapimanagement.AdditionalLocation{
		// 					{
		// 						DisableGateway: to.Ptr(false),
		// 						GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-premium-eastus2-01.regional.azure-api.net"),
		// 						Location: to.Ptr("East US 2"),
		// 						PublicIPAddresses: []*string{
		// 							to.Ptr("40.70.24.106")},
		// 							SKU: &armapimanagement.ServiceSKUProperties{
		// 								Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 								Capacity: to.Ptr[int32](1),
		// 							},
		// 							Zones: []*string{
		// 							},
		// 					}},
		// 					APIVersionConstraint: &armapimanagement.APIVersionConstraint{
		// 						MinAPIVersion: to.Ptr("2019-12-01"),
		// 					},
		// 					Certificates: []*armapimanagement.CertificateConfiguration{
		// 					},
		// 					CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:40:00.945Z"); return t}()),
		// 					CustomProperties: map[string]*string{
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
		// 						"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
		// 					},
		// 					DeveloperPortalURL: to.Ptr("https://ogf-z3-06162021-premium.developer.azure-api.net"),
		// 					DisableGateway: to.Ptr(false),
		// 					GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-premium-eastus-01.regional.azure-api.net"),
		// 					GatewayURL: to.Ptr("https://ogf-z3-06162021-premium.azure-api.net"),
		// 					HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 							DefaultSSLBinding: to.Ptr(false),
		// 							HostName: to.Ptr("ogf-z3-06162021-premium.azure-api.net"),
		// 							NegotiateClientCertificate: to.Ptr(false),
		// 						},
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 							Certificate: &armapimanagement.CertificateInformation{
		// 								Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
		// 								Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
		// 								Thumbprint: to.Ptr("BA0C286F71AF3B6A01BDB240C58A4A507E3DBD51"),
		// 							},
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
		// 							DefaultSSLBinding: to.Ptr(true),
		// 							HostName: to.Ptr("gateway.current.int-azure-api.net"),
		// 							KeyVaultID: to.Ptr("https://ogf-testing.vault-int.azure-int.net/secrets/current-ssl"),
		// 							NegotiateClientCertificate: to.Ptr(true),
		// 						},
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeDeveloperPortal),
		// 							Certificate: &armapimanagement.CertificateInformation{
		// 								Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
		// 								Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
		// 								Thumbprint: to.Ptr("BA0C286F71AF3B6A01BDB240C58A4A507E3DBD51"),
		// 							},
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
		// 							DefaultSSLBinding: to.Ptr(false),
		// 							HostName: to.Ptr("developer.current.int-azure-api.net"),
		// 							KeyVaultID: to.Ptr("https://ogf-testing.vault-int.azure-int.net/secrets/current-ssl"),
		// 							NegotiateClientCertificate: to.Ptr(false),
		// 						},
		// 						{
		// 							Type: to.Ptr(armapimanagement.HostnameTypeManagement),
		// 							Certificate: &armapimanagement.CertificateInformation{
		// 								Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-08T22:32:32.000Z"); return t}()),
		// 								Subject: to.Ptr("CN=*.current.int-azure-api.net, O=Microsoft Corporation, L=Redmond, S=WA, C=US"),
		// 								Thumbprint: to.Ptr("BA0C286F71AF3B6A01BDB240C58A4A507E3DBD51"),
		// 							},
		// 							CertificateSource: to.Ptr(armapimanagement.CertificateSourceCustom),
		// 							DefaultSSLBinding: to.Ptr(false),
		// 							HostName: to.Ptr("mgmt.current.int-azure-api.net"),
		// 							KeyVaultID: to.Ptr("https://ogf-testing.vault-int.azure-int.net/secrets/current-ssl"),
		// 							NegotiateClientCertificate: to.Ptr(false),
		// 					}},
		// 					ManagementAPIURL: to.Ptr("https://ogf-z3-06162021-premium.management.azure-api.net"),
		// 					NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 					PortalURL: to.Ptr("https://ogf-z3-06162021-premium.portal.azure-api.net"),
		// 					ProvisioningState: to.Ptr("Succeeded"),
		// 					PublicIPAddresses: []*string{
		// 						to.Ptr("13.92.130.49")},
		// 						PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 						ScmURL: to.Ptr("https://ogf-z3-06162021-premium.scm.azure-api.net"),
		// 						TargetProvisioningState: to.Ptr(""),
		// 						VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 						PublisherEmail: to.Ptr("bar@contoso.com"),
		// 						PublisherName: to.Ptr("Test Premium"),
		// 					},
		// 					SKU: &armapimanagement.ServiceSKUProperties{
		// 						Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 						Capacity: to.Ptr[int32](1),
		// 					},
		// 					SystemData: &armapimanagement.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:40:00.710Z"); return t}()),
		// 						CreatedBy: to.Ptr("bar@contoso.com"),
		// 						CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-20T06:33:09.615Z"); return t}()),
		// 						LastModifiedBy: to.Ptr("foo@contoso.com"),
		// 						LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("vvktestcons"),
		// 					Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/vvktestcons"),
		// 					Tags: map[string]*string{
		// 						"Owner": to.Ptr("vitaliik"),
		// 					},
		// 					Etag: to.Ptr("AAAAAAAWKwo="),
		// 					Location: to.Ptr("East US"),
		// 					Properties: &armapimanagement.ServiceProperties{
		// 						CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-08-10T18:07:23.456Z"); return t}()),
		// 						CustomProperties: map[string]*string{
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
		// 						},
		// 						DisableGateway: to.Ptr(false),
		// 						EnableClientCertificate: to.Ptr(false),
		// 						GatewayURL: to.Ptr("https://vvktestcons.azure-api.net"),
		// 						HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 							{
		// 								Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 								CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 								DefaultSSLBinding: to.Ptr(true),
		// 								HostName: to.Ptr("vvktestcons.azure-api.net"),
		// 								NegotiateClientCertificate: to.Ptr(false),
		// 						}},
		// 						NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 						TargetProvisioningState: to.Ptr(""),
		// 						VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 						PublisherEmail: to.Ptr("bar@contoso.com"),
		// 						PublisherName: to.Ptr("vvktestcons"),
		// 					},
		// 					SKU: &armapimanagement.ServiceSKUProperties{
		// 						Name: to.Ptr(armapimanagement.SKUTypeConsumption),
		// 						Capacity: to.Ptr[int32](0),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("OGF-Z3-06162021-Standard"),
		// 					Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/OGF-Z3-06162021-Standard"),
		// 					Tags: map[string]*string{
		// 					},
		// 					Etag: to.Ptr("AAAAAAAWF7M="),
		// 					Identity: &armapimanagement.ServiceIdentity{
		// 						Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssignedUserAssigned),
		// 						PrincipalID: to.Ptr("347a5800-ca99-475a-9202-fe38ca79ee41"),
		// 						TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 						UserAssignedIdentities: map[string]*armapimanagement.UserIdentityProperties{
		// 							"/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/ogf-identity": &armapimanagement.UserIdentityProperties{
		// 								ClientID: to.Ptr("8d9791f2-0cdf-41f4-9e66-cdc39b496789"),
		// 								PrincipalID: to.Ptr("713784d2-ee37-412a-95f0-3768f397f82d"),
		// 							},
		// 						},
		// 					},
		// 					Location: to.Ptr("East US"),
		// 					Properties: &armapimanagement.ServiceProperties{
		// 						APIVersionConstraint: &armapimanagement.APIVersionConstraint{
		// 							MinAPIVersion: to.Ptr("2019-12-01"),
		// 						},
		// 						CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:39:58.655Z"); return t}()),
		// 						CustomProperties: map[string]*string{
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA": to.Ptr("true"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("False"),
		// 							"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("False"),
		// 						},
		// 						DeveloperPortalURL: to.Ptr("https://ogf-z3-06162021-standard.developer.azure-api.net"),
		// 						DisableGateway: to.Ptr(false),
		// 						GatewayRegionalURL: to.Ptr("https://ogf-z3-06162021-standard-eastus-01.regional.azure-api.net"),
		// 						GatewayURL: to.Ptr("https://ogf-z3-06162021-standard.azure-api.net"),
		// 						HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 							{
		// 								Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 								CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 								DefaultSSLBinding: to.Ptr(true),
		// 								HostName: to.Ptr("ogf-z3-06162021-standard.azure-api.net"),
		// 								NegotiateClientCertificate: to.Ptr(false),
		// 						}},
		// 						ManagementAPIURL: to.Ptr("https://ogf-z3-06162021-standard.management.azure-api.net"),
		// 						NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 						PortalURL: to.Ptr("https://ogf-z3-06162021-standard.portal.azure-api.net"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						PublicIPAddresses: []*string{
		// 							to.Ptr("13.82.208.32")},
		// 							PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 							ScmURL: to.Ptr("https://ogf-z3-06162021-standard.scm.azure-api.net"),
		// 							TargetProvisioningState: to.Ptr(""),
		// 							VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 							PublisherEmail: to.Ptr("bar@contoso.com"),
		// 							PublisherName: to.Ptr("Test Standard"),
		// 						},
		// 						SKU: &armapimanagement.ServiceSKUProperties{
		// 							Name: to.Ptr(armapimanagement.SKUTypeStandard),
		// 							Capacity: to.Ptr[int32](2),
		// 						},
		// 						SystemData: &armapimanagement.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-16T09:39:58.459Z"); return t}()),
		// 							CreatedBy: to.Ptr("bar@contoso.com"),
		// 							CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-17T15:05:13.549Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("bar@contoso.com"),
		// 							LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("ogf-dev-060921"),
		// 						Type: to.Ptr("Microsoft.ApiManagement/service"),
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/ogf-dev-060921"),
		// 						Tags: map[string]*string{
		// 						},
		// 						Etag: to.Ptr("AAAAAAAWEFg="),
		// 						Identity: &armapimanagement.ServiceIdentity{
		// 							Type: to.Ptr(armapimanagement.ApimIdentityTypeSystemAssigned),
		// 							PrincipalID: to.Ptr("c9bd4c05-205e-4431-b232-112cf2e9e0aa"),
		// 							TenantID: to.Ptr("f686d426-8d16-42db-81b7-ab578e110ccd"),
		// 						},
		// 						Location: to.Ptr("East US"),
		// 						Properties: &armapimanagement.ServiceProperties{
		// 							AdditionalLocations: []*armapimanagement.AdditionalLocation{
		// 								{
		// 									DisableGateway: to.Ptr(false),
		// 									GatewayRegionalURL: to.Ptr("https://ogf-dev-060921-southcentralus-01.regional.azure-api.net"),
		// 									Location: to.Ptr("South Central US"),
		// 									PublicIPAddresses: []*string{
		// 										to.Ptr("13.84.208.29")},
		// 										SKU: &armapimanagement.ServiceSKUProperties{
		// 											Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 											Capacity: to.Ptr[int32](9),
		// 										},
		// 										Zones: []*string{
		// 										},
		// 								}},
		// 								APIVersionConstraint: &armapimanagement.APIVersionConstraint{
		// 									MinAPIVersion: to.Ptr("2019-12-01"),
		// 								},
		// 								Certificates: []*armapimanagement.CertificateConfiguration{
		// 									{
		// 										Certificate: &armapimanagement.CertificateInformation{
		// 											Expiry: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-25T22:51:47.000Z"); return t}()),
		// 											Subject: to.Ptr("CN=*.apim.net"),
		// 											Thumbprint: to.Ptr("4E8234312EC69245D1AE296C4882D46FB84076A3"),
		// 										},
		// 										StoreName: to.Ptr(armapimanagement.CertificateConfigurationStoreNameRoot),
		// 								}},
		// 								CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T10:06:22.213Z"); return t}()),
		// 								CustomProperties: map[string]*string{
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Ssl30": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Ssl30": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10": to.Ptr("false"),
		// 									"Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11": to.Ptr("false"),
		// 								},
		// 								DeveloperPortalURL: to.Ptr("https://ogf-dev-060921.developer.azure-api.net"),
		// 								DisableGateway: to.Ptr(false),
		// 								GatewayRegionalURL: to.Ptr("https://ogf-dev-060921-eastus-01.regional.azure-api.net"),
		// 								GatewayURL: to.Ptr("https://ogf-dev-060921.azure-api.net"),
		// 								HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
		// 									{
		// 										Type: to.Ptr(armapimanagement.HostnameTypeProxy),
		// 										CertificateSource: to.Ptr(armapimanagement.CertificateSourceBuiltIn),
		// 										DefaultSSLBinding: to.Ptr(true),
		// 										HostName: to.Ptr("ogf-dev-060921.azure-api.net"),
		// 										NegotiateClientCertificate: to.Ptr(false),
		// 								}},
		// 								ManagementAPIURL: to.Ptr("https://ogf-dev-060921.management.azure-api.net"),
		// 								NotificationSenderEmail: to.Ptr("apimgmt-noreply@mail.windowsazure.com"),
		// 								PortalURL: to.Ptr("https://ogf-dev-060921.portal.azure-api.net"),
		// 								ProvisioningState: to.Ptr("Succeeded"),
		// 								PublicIPAddresses: []*string{
		// 									to.Ptr("168.62.39.172")},
		// 									PublicNetworkAccess: to.Ptr(armapimanagement.PublicNetworkAccessEnabled),
		// 									ScmURL: to.Ptr("https://ogf-dev-060921.scm.azure-api.net"),
		// 									TargetProvisioningState: to.Ptr(""),
		// 									VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeNone),
		// 									PublisherEmail: to.Ptr("v-ssaiprasan@microsoft.com"),
		// 									PublisherName: to.Ptr("TechM"),
		// 								},
		// 								SKU: &armapimanagement.ServiceSKUProperties{
		// 									Name: to.Ptr(armapimanagement.SKUTypePremium),
		// 									Capacity: to.Ptr[int32](3),
		// 								},
		// 								SystemData: &armapimanagement.SystemData{
		// 									CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T10:06:21.733Z"); return t}()),
		// 									CreatedBy: to.Ptr("v-ssaiprasan@microsoft.com"),
		// 									CreatedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 									LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-10T14:27:05.546Z"); return t}()),
		// 									LastModifiedBy: to.Ptr("v-ssaiprasan@microsoft.com"),
		// 									LastModifiedByType: to.Ptr(armapimanagement.CreatedByTypeUser),
		// 								},
		// 						}},
		// 					}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceGetSsoToken.json
func ExampleServiceClient_GetSsoToken() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServiceClient().GetSsoToken(ctx, "rg1", "apimService1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceGetSsoTokenResult = armapimanagement.ServiceGetSsoTokenResult{
	// 	RedirectURI: to.Ptr("https://apimService1.portal.azure-api.net:443/signin-sso?token=1%26201705301929%26eIkr3%2fnfaLs1GVJ0OVbzkJjAcwPFkEZAPM8VUXvXPf7cJ6lWsB9oUwsk2zln9x0KLkn21txCPJWWheSPq7SNeA%3d%3d"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceCheckNameAvailability.json
func ExampleServiceClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServiceClient().CheckNameAvailability(ctx, armapimanagement.ServiceCheckNameAvailabilityParameters{
		Name: to.Ptr("apimService1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceNameAvailabilityResult = armapimanagement.ServiceNameAvailabilityResult{
	// 	Message: to.Ptr(""),
	// 	NameAvailable: to.Ptr(true),
	// 	Reason: to.Ptr(armapimanagement.NameAvailabilityReasonValid),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementServiceGetDomainOwnershipIdentifier.json
func ExampleServiceClient_GetDomainOwnershipIdentifier() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServiceClient().GetDomainOwnershipIdentifier(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceGetDomainOwnershipIdentifierResult = armapimanagement.ServiceGetDomainOwnershipIdentifierResult{
	// 	DomainOwnershipIdentifier: to.Ptr("KLE1vdMblVeHECAi4nCe3oNaXXXXvNlLrXt2ev84KM="),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementApplyNetworkConfigurationUpdates.json
func ExampleServiceClient_BeginApplyNetworkConfigurationUpdates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServiceClient().BeginApplyNetworkConfigurationUpdates(ctx, "rg1", "apimService1", &armapimanagement.ServiceClientBeginApplyNetworkConfigurationUpdatesOptions{Parameters: &armapimanagement.ServiceApplyNetworkConfigurationParameters{
		Location: to.Ptr("west us"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceResource = armapimanagement.ServiceResource{
	// 	Name: to.Ptr("apimService1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1"),
	// 	Tags: map[string]*string{
	// 		"UID": to.Ptr("52ed5986-717b-45b4-b17c-3df8db372cff"),
	// 	},
	// 	Etag: to.Ptr("AAAAAAAXX6Y="),
	// 	Location: to.Ptr("East Asia"),
	// 	Properties: &armapimanagement.ServiceProperties{
	// 		CreatedAtUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2015-09-22T01:50:34.792Z"); return t}()),
	// 		GatewayURL: to.Ptr("https://apimService1.azure-api.net"),
	// 		HostnameConfigurations: []*armapimanagement.HostnameConfiguration{
	// 		},
	// 		ManagementAPIURL: to.Ptr("https://apimService1.management.azure-api.net"),
	// 		PortalURL: to.Ptr("https://apimService1.portal.azure-api.net"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		PublicIPAddresses: []*string{
	// 			to.Ptr("207.46.155.24")},
	// 			ScmURL: to.Ptr("https://apimService1.scm.azure-api.net"),
	// 			TargetProvisioningState: to.Ptr(""),
	// 			VirtualNetworkConfiguration: &armapimanagement.VirtualNetworkConfiguration{
	// 				SubnetResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/eastUsVirtualNetwork/subnets/apimSubnet"),
	// 			},
	// 			VirtualNetworkType: to.Ptr(armapimanagement.VirtualNetworkTypeExternal),
	// 			PublisherEmail: to.Ptr("admin@live.com"),
	// 			PublisherName: to.Ptr("Contoso"),
	// 		},
	// 		SKU: &armapimanagement.ServiceSKUProperties{
	// 			Name: to.Ptr(armapimanagement.SKUTypePremium),
	// 			Capacity: to.Ptr[int32](1),
	// 		},
	// 	}
}
