//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListTagResources.json
func ExampleTagResourceClient_NewListByServicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTagResourceClient().NewListByServicePager("rg1", "apimService1", &armapimanagement.TagResourceClientListByServiceOptions{Filter: nil,
		Top:  nil,
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TagResourceCollection = armapimanagement.TagResourceCollection{
		// 	Value: []*armapimanagement.TagResourceContract{
		// 		{
		// 			Operation: &armapimanagement.OperationTagResourceContractProperties{
		// 				Name: to.Ptr("Create resource"),
		// 				Method: to.Ptr("POST"),
		// 				Description: to.Ptr("A demonstration of a POST call based on the echo backend above. The request body is expected to contain JSON-formatted data (see example below). A policy is used to automatically transform any request sent in JSON directly to XML. In a real-world scenario this could be used to enable modern clients to speak to a legacy backend."),
		// 				APIName: to.Ptr("Echo API"),
		// 				APIRevision: to.Ptr("1"),
		// 				ID: to.Ptr("/apis/echo-api/operations/create-resource"),
		// 				URLTemplate: to.Ptr("/resource"),
		// 			},
		// 			Tag: &armapimanagement.TagResourceContractProperties{
		// 				Name: to.Ptr("awesomeTag"),
		// 				ID: to.Ptr("/tags/apitag123"),
		// 			},
		// 		},
		// 		{
		// 			API: &armapimanagement.APITagResourceContractProperties{
		// 				APIRevision: to.Ptr("1"),
		// 				IsCurrent: to.Ptr(true),
		// 				Name: to.Ptr("Echo API"),
		// 				Path: to.Ptr("echo"),
		// 				ID: to.Ptr("/apis/echo-api"),
		// 				ServiceURL: to.Ptr("http://echoapi.cloudapp.net/api"),
		// 			},
		// 			Tag: &armapimanagement.TagResourceContractProperties{
		// 				Name: to.Ptr("awesomeTag"),
		// 				ID: to.Ptr("/tags/apitag123"),
		// 			},
		// 		},
		// 		{
		// 			Product: &armapimanagement.ProductTagResourceContractProperties{
		// 				Description: to.Ptr("Subscribers will be able to run 5 calls/minute up to a maximum of 100 calls/week."),
		// 				ApprovalRequired: to.Ptr(false),
		// 				State: to.Ptr(armapimanagement.ProductStatePublished),
		// 				SubscriptionRequired: to.Ptr(true),
		// 				SubscriptionsLimit: to.Ptr[int32](1),
		// 				Terms: to.Ptr(""),
		// 				Name: to.Ptr("Starter"),
		// 				ID: to.Ptr("/products/starter"),
		// 			},
		// 			Tag: &armapimanagement.TagResourceContractProperties{
		// 				Name: to.Ptr("awesomeTag"),
		// 				ID: to.Ptr("/tags/apitag123"),
		// 			},
		// 	}},
		// }
	}
}
