//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v2"
	"net/http"
	"net/url"
	"regexp"
)

// RestorableTimeRangesServer is a fake server for instances of the armdataprotection.RestorableTimeRangesClient type.
type RestorableTimeRangesServer struct {
	// Find is the fake for method RestorableTimeRangesClient.Find
	// HTTP status codes to indicate success: http.StatusOK
	Find func(ctx context.Context, resourceGroupName string, vaultName string, backupInstanceName string, parameters armdataprotection.AzureBackupFindRestorableTimeRangesRequest, options *armdataprotection.RestorableTimeRangesClientFindOptions) (resp azfake.Responder[armdataprotection.RestorableTimeRangesClientFindResponse], errResp azfake.ErrorResponder)
}

// NewRestorableTimeRangesServerTransport creates a new instance of RestorableTimeRangesServerTransport with the provided implementation.
// The returned RestorableTimeRangesServerTransport instance is connected to an instance of armdataprotection.RestorableTimeRangesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRestorableTimeRangesServerTransport(srv *RestorableTimeRangesServer) *RestorableTimeRangesServerTransport {
	return &RestorableTimeRangesServerTransport{srv: srv}
}

// RestorableTimeRangesServerTransport connects instances of armdataprotection.RestorableTimeRangesClient to instances of RestorableTimeRangesServer.
// Don't use this type directly, use NewRestorableTimeRangesServerTransport instead.
type RestorableTimeRangesServerTransport struct {
	srv *RestorableTimeRangesServer
}

// Do implements the policy.Transporter interface for RestorableTimeRangesServerTransport.
func (r *RestorableTimeRangesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RestorableTimeRangesClient.Find":
		resp, err = r.dispatchFind(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RestorableTimeRangesServerTransport) dispatchFind(req *http.Request) (*http.Response, error) {
	if r.srv.Find == nil {
		return nil, &nonRetriableError{errors.New("fake for method Find not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/backupVaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupInstances/(?P<backupInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/findRestorableTimeRanges`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdataprotection.AzureBackupFindRestorableTimeRangesRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
	if err != nil {
		return nil, err
	}
	backupInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Find(req.Context(), resourceGroupNameParam, vaultNameParam, backupInstanceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureBackupFindRestorableTimeRangesResponseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
