//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewCaCertificatesClient creates a new instance of CaCertificatesClient.
func (c *ClientFactory) NewCaCertificatesClient() *CaCertificatesClient {
	subClient, _ := NewCaCertificatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewChannelsClient creates a new instance of ChannelsClient.
func (c *ClientFactory) NewChannelsClient() *ChannelsClient {
	subClient, _ := NewChannelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClientGroupsClient creates a new instance of ClientGroupsClient.
func (c *ClientFactory) NewClientGroupsClient() *ClientGroupsClient {
	subClient, _ := NewClientGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClientsClient creates a new instance of ClientsClient.
func (c *ClientFactory) NewClientsClient() *ClientsClient {
	subClient, _ := NewClientsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDomainEventSubscriptionsClient creates a new instance of DomainEventSubscriptionsClient.
func (c *ClientFactory) NewDomainEventSubscriptionsClient() *DomainEventSubscriptionsClient {
	subClient, _ := NewDomainEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDomainTopicEventSubscriptionsClient creates a new instance of DomainTopicEventSubscriptionsClient.
func (c *ClientFactory) NewDomainTopicEventSubscriptionsClient() *DomainTopicEventSubscriptionsClient {
	subClient, _ := NewDomainTopicEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDomainTopicsClient creates a new instance of DomainTopicsClient.
func (c *ClientFactory) NewDomainTopicsClient() *DomainTopicsClient {
	subClient, _ := NewDomainTopicsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDomainsClient creates a new instance of DomainsClient.
func (c *ClientFactory) NewDomainsClient() *DomainsClient {
	subClient, _ := NewDomainsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEventSubscriptionsClient creates a new instance of EventSubscriptionsClient.
func (c *ClientFactory) NewEventSubscriptionsClient() *EventSubscriptionsClient {
	subClient, _ := NewEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExtensionTopicsClient creates a new instance of ExtensionTopicsClient.
func (c *ClientFactory) NewExtensionTopicsClient() *ExtensionTopicsClient {
	subClient, _ := NewExtensionTopicsClient(c.credential, c.options)
	return subClient
}

// NewNamespaceTopicEventSubscriptionsClient creates a new instance of NamespaceTopicEventSubscriptionsClient.
func (c *ClientFactory) NewNamespaceTopicEventSubscriptionsClient() *NamespaceTopicEventSubscriptionsClient {
	subClient, _ := NewNamespaceTopicEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNamespaceTopicsClient creates a new instance of NamespaceTopicsClient.
func (c *ClientFactory) NewNamespaceTopicsClient() *NamespaceTopicsClient {
	subClient, _ := NewNamespaceTopicsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNamespacesClient creates a new instance of NamespacesClient.
func (c *ClientFactory) NewNamespacesClient() *NamespacesClient {
	subClient, _ := NewNamespacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkSecurityPerimeterConfigurationsClient creates a new instance of NetworkSecurityPerimeterConfigurationsClient.
func (c *ClientFactory) NewNetworkSecurityPerimeterConfigurationsClient() *NetworkSecurityPerimeterConfigurationsClient {
	subClient, _ := NewNetworkSecurityPerimeterConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPartnerConfigurationsClient creates a new instance of PartnerConfigurationsClient.
func (c *ClientFactory) NewPartnerConfigurationsClient() *PartnerConfigurationsClient {
	subClient, _ := NewPartnerConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPartnerDestinationsClient creates a new instance of PartnerDestinationsClient.
func (c *ClientFactory) NewPartnerDestinationsClient() *PartnerDestinationsClient {
	subClient, _ := NewPartnerDestinationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPartnerNamespacesClient creates a new instance of PartnerNamespacesClient.
func (c *ClientFactory) NewPartnerNamespacesClient() *PartnerNamespacesClient {
	subClient, _ := NewPartnerNamespacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPartnerRegistrationsClient creates a new instance of PartnerRegistrationsClient.
func (c *ClientFactory) NewPartnerRegistrationsClient() *PartnerRegistrationsClient {
	subClient, _ := NewPartnerRegistrationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPartnerTopicEventSubscriptionsClient creates a new instance of PartnerTopicEventSubscriptionsClient.
func (c *ClientFactory) NewPartnerTopicEventSubscriptionsClient() *PartnerTopicEventSubscriptionsClient {
	subClient, _ := NewPartnerTopicEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPartnerTopicsClient creates a new instance of PartnerTopicsClient.
func (c *ClientFactory) NewPartnerTopicsClient() *PartnerTopicsClient {
	subClient, _ := NewPartnerTopicsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPermissionBindingsClient creates a new instance of PermissionBindingsClient.
func (c *ClientFactory) NewPermissionBindingsClient() *PermissionBindingsClient {
	subClient, _ := NewPermissionBindingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSystemTopicEventSubscriptionsClient creates a new instance of SystemTopicEventSubscriptionsClient.
func (c *ClientFactory) NewSystemTopicEventSubscriptionsClient() *SystemTopicEventSubscriptionsClient {
	subClient, _ := NewSystemTopicEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSystemTopicsClient creates a new instance of SystemTopicsClient.
func (c *ClientFactory) NewSystemTopicsClient() *SystemTopicsClient {
	subClient, _ := NewSystemTopicsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTopicEventSubscriptionsClient creates a new instance of TopicEventSubscriptionsClient.
func (c *ClientFactory) NewTopicEventSubscriptionsClient() *TopicEventSubscriptionsClient {
	subClient, _ := NewTopicEventSubscriptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTopicSpacesClient creates a new instance of TopicSpacesClient.
func (c *ClientFactory) NewTopicSpacesClient() *TopicSpacesClient {
	subClient, _ := NewTopicSpacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewTopicTypesClient creates a new instance of TopicTypesClient.
func (c *ClientFactory) NewTopicTypesClient() *TopicTypesClient {
	subClient, _ := NewTopicTypesClient(c.credential, c.options)
	return subClient
}

// NewTopicsClient creates a new instance of TopicsClient.
func (c *ClientFactory) NewTopicsClient() *TopicsClient {
	subClient, _ := NewTopicsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVerifiedPartnersClient creates a new instance of VerifiedPartnersClient.
func (c *ClientFactory) NewVerifiedPartnersClient() *VerifiedPartnersClient {
	subClient, _ := NewVerifiedPartnersClient(c.credential, c.options)
	return subClient
}
