//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import "encoding/json"

func unmarshalArtifactAccessCredentialClassification(rawMsg json.RawMessage) (ArtifactAccessCredentialClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ArtifactAccessCredentialClassification
	switch m["credentialType"] {
	case string(CredentialTypeAzureContainerRegistryScopedToken):
		b = &AzureContainerRegistryScopedTokenCredential{}
	case string(CredentialTypeAzureStorageAccountToken):
		b = &AzureStorageAccountCredential{}
	default:
		b = &ArtifactAccessCredential{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureArcKubernetesNetworkFunctionApplicationClassification(rawMsg json.RawMessage) (AzureArcKubernetesNetworkFunctionApplicationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureArcKubernetesNetworkFunctionApplicationClassification
	switch m["artifactType"] {
	case string(AzureArcKubernetesArtifactTypeHelmPackage):
		b = &AzureArcKubernetesHelmApplication{}
	default:
		b = &AzureArcKubernetesNetworkFunctionApplication{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureArcKubernetesNetworkFunctionApplicationClassificationArray(rawMsg json.RawMessage) ([]AzureArcKubernetesNetworkFunctionApplicationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AzureArcKubernetesNetworkFunctionApplicationClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAzureArcKubernetesNetworkFunctionApplicationClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAzureCoreNetworkFunctionApplicationClassification(rawMsg json.RawMessage) (AzureCoreNetworkFunctionApplicationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureCoreNetworkFunctionApplicationClassification
	switch m["artifactType"] {
	case string(AzureCoreArtifactTypeArmTemplate):
		b = &AzureCoreNetworkFunctionArmTemplateApplication{}
	case string(AzureCoreArtifactTypeVhdImageFile):
		b = &AzureCoreNetworkFunctionVhdApplication{}
	default:
		b = &AzureCoreNetworkFunctionApplication{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureCoreNetworkFunctionApplicationClassificationArray(rawMsg json.RawMessage) ([]AzureCoreNetworkFunctionApplicationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AzureCoreNetworkFunctionApplicationClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAzureCoreNetworkFunctionApplicationClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalAzureOperatorNexusNetworkFunctionApplicationClassification(rawMsg json.RawMessage) (AzureOperatorNexusNetworkFunctionApplicationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureOperatorNexusNetworkFunctionApplicationClassification
	switch m["artifactType"] {
	case string(AzureOperatorNexusArtifactTypeArmTemplate):
		b = &AzureOperatorNexusNetworkFunctionArmTemplateApplication{}
	case string(AzureOperatorNexusArtifactTypeImageFile):
		b = &AzureOperatorNexusNetworkFunctionImageApplication{}
	default:
		b = &AzureOperatorNexusNetworkFunctionApplication{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureOperatorNexusNetworkFunctionApplicationClassificationArray(rawMsg json.RawMessage) ([]AzureOperatorNexusNetworkFunctionApplicationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AzureOperatorNexusNetworkFunctionApplicationClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAzureOperatorNexusNetworkFunctionApplicationClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalConfigurationGroupValuePropertiesFormatClassification(rawMsg json.RawMessage) (ConfigurationGroupValuePropertiesFormatClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ConfigurationGroupValuePropertiesFormatClassification
	switch m["configurationType"] {
	case string(ConfigurationGroupValueConfigurationTypeOpen):
		b = &ConfigurationValueWithoutSecrets{}
	case string(ConfigurationGroupValueConfigurationTypeSecret):
		b = &ConfigurationValueWithSecrets{}
	default:
		b = &ConfigurationGroupValuePropertiesFormat{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalContainerizedNetworkFunctionTemplateClassification(rawMsg json.RawMessage) (ContainerizedNetworkFunctionTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ContainerizedNetworkFunctionTemplateClassification
	switch m["nfviType"] {
	case string(ContainerizedNetworkFunctionNFVITypeAzureArcKubernetes):
		b = &AzureArcKubernetesNetworkFunctionTemplate{}
	default:
		b = &ContainerizedNetworkFunctionTemplate{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDeploymentResourceIDReferenceClassification(rawMsg json.RawMessage) (DeploymentResourceIDReferenceClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DeploymentResourceIDReferenceClassification
	switch m["idType"] {
	case string(IDTypeOpen):
		b = &OpenDeploymentResourceReference{}
	case string(IDTypeSecret):
		b = &SecretDeploymentResourceReference{}
	default:
		b = &DeploymentResourceIDReference{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalNFVIsClassification(rawMsg json.RawMessage) (NFVIsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b NFVIsClassification
	switch m["nfviType"] {
	case string(NFVITypeAzureArcKubernetes):
		b = &AzureArcK8SClusterNFVIDetails{}
	case string(NFVITypeAzureCore):
		b = &AzureCoreNFVIDetails{}
	case string(NFVITypeAzureOperatorNexus):
		b = &AzureOperatorNexusClusterNFVIDetails{}
	default:
		b = &NFVIs{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalNFVIsClassificationArray(rawMsg json.RawMessage) ([]NFVIsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]NFVIsClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalNFVIsClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalNetworkFunctionDefinitionVersionPropertiesFormatClassification(rawMsg json.RawMessage) (NetworkFunctionDefinitionVersionPropertiesFormatClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b NetworkFunctionDefinitionVersionPropertiesFormatClassification
	switch m["networkFunctionType"] {
	case string(NetworkFunctionTypeContainerizedNetworkFunction):
		b = &ContainerizedNetworkFunctionDefinitionVersion{}
	case string(NetworkFunctionTypeVirtualNetworkFunction):
		b = &VirtualNetworkFunctionDefinitionVersion{}
	default:
		b = &NetworkFunctionDefinitionVersionPropertiesFormat{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalNetworkFunctionPropertiesFormatClassification(rawMsg json.RawMessage) (NetworkFunctionPropertiesFormatClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b NetworkFunctionPropertiesFormatClassification
	switch m["configurationType"] {
	case string(NetworkFunctionConfigurationTypeOpen):
		b = &NetworkFunctionValueWithoutSecrets{}
	case string(NetworkFunctionConfigurationTypeSecret):
		b = &NetworkFunctionValueWithSecrets{}
	default:
		b = &NetworkFunctionPropertiesFormat{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalResourceElementTemplateClassification(rawMsg json.RawMessage) (ResourceElementTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ResourceElementTemplateClassification
	switch m["type"] {
	case string(TypeArmResourceDefinition):
		b = &ArmResourceDefinitionResourceElementTemplateDetails{}
	case string(TypeNetworkFunctionDefinition):
		b = &NetworkFunctionDefinitionResourceElementTemplateDetails{}
	default:
		b = &ResourceElementTemplate{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalResourceElementTemplateClassificationArray(rawMsg json.RawMessage) ([]ResourceElementTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ResourceElementTemplateClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalResourceElementTemplateClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalVirtualNetworkFunctionTemplateClassification(rawMsg json.RawMessage) (VirtualNetworkFunctionTemplateClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b VirtualNetworkFunctionTemplateClassification
	switch m["nfviType"] {
	case string(VirtualNetworkFunctionNFVITypeAzureCore):
		b = &AzureCoreNetworkFunctionTemplate{}
	case string(VirtualNetworkFunctionNFVITypeAzureOperatorNexus):
		b = &AzureOperatorNexusNetworkFunctionTemplate{}
	default:
		b = &VirtualNetworkFunctionTemplate{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
