//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FirmwareClient contains the methods for the Firmware group.
// Don't use this type directly, use NewFirmwareClient() instead.
type FirmwareClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFirmwareClient creates a new instance of FirmwareClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFirmwareClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FirmwareClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FirmwareClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - The operation to create a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - firmware - Details of the firmware being created or updated.
//   - options - FirmwareClientCreateOptions contains the optional parameters for the FirmwareClient.Create method.
func (client *FirmwareClient) Create(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware Firmware, options *FirmwareClientCreateOptions) (FirmwareClientCreateResponse, error) {
	var err error
	const operationName = "FirmwareClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, firmware, options)
	if err != nil {
		return FirmwareClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *FirmwareClient) createCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware Firmware, options *FirmwareClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, firmware); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *FirmwareClient) createHandleResponse(resp *http.Response) (FirmwareClientCreateResponse, error) {
	result := FirmwareClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Firmware); err != nil {
		return FirmwareClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - The operation to delete a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientDeleteOptions contains the optional parameters for the FirmwareClient.Delete method.
func (client *FirmwareClient) Delete(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientDeleteOptions) (FirmwareClientDeleteResponse, error) {
	var err error
	const operationName = "FirmwareClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientDeleteResponse{}, err
	}
	return FirmwareClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FirmwareClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateBinaryHardeningDetails - The operation to get binary hardening details for a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateBinaryHardeningDetailsOptions contains the optional parameters for the FirmwareClient.GenerateBinaryHardeningDetails
//     method.
func (client *FirmwareClient) GenerateBinaryHardeningDetails(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateBinaryHardeningDetailsOptions) (FirmwareClientGenerateBinaryHardeningDetailsResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateBinaryHardeningDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateBinaryHardeningDetailsCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateBinaryHardeningDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateBinaryHardeningDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateBinaryHardeningDetailsResponse{}, err
	}
	resp, err := client.generateBinaryHardeningDetailsHandleResponse(httpResp)
	return resp, err
}

// generateBinaryHardeningDetailsCreateRequest creates the GenerateBinaryHardeningDetails request.
func (client *FirmwareClient) generateBinaryHardeningDetailsCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateBinaryHardeningDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateBinaryHardeningDetails"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateBinaryHardeningDetailsHandleResponse handles the GenerateBinaryHardeningDetails response.
func (client *FirmwareClient) generateBinaryHardeningDetailsHandleResponse(resp *http.Response) (FirmwareClientGenerateBinaryHardeningDetailsResponse, error) {
	result := FirmwareClientGenerateBinaryHardeningDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BinaryHardening); err != nil {
		return FirmwareClientGenerateBinaryHardeningDetailsResponse{}, err
	}
	return result, nil
}

// GenerateBinaryHardeningSummary - The operation to list the binary hardening summary percentages for a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateBinaryHardeningSummaryOptions contains the optional parameters for the FirmwareClient.GenerateBinaryHardeningSummary
//     method.
func (client *FirmwareClient) GenerateBinaryHardeningSummary(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateBinaryHardeningSummaryOptions) (FirmwareClientGenerateBinaryHardeningSummaryResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateBinaryHardeningSummary"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateBinaryHardeningSummaryCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateBinaryHardeningSummaryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateBinaryHardeningSummaryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateBinaryHardeningSummaryResponse{}, err
	}
	resp, err := client.generateBinaryHardeningSummaryHandleResponse(httpResp)
	return resp, err
}

// generateBinaryHardeningSummaryCreateRequest creates the GenerateBinaryHardeningSummary request.
func (client *FirmwareClient) generateBinaryHardeningSummaryCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateBinaryHardeningSummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateBinaryHardeningSummary"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateBinaryHardeningSummaryHandleResponse handles the GenerateBinaryHardeningSummary response.
func (client *FirmwareClient) generateBinaryHardeningSummaryHandleResponse(resp *http.Response) (FirmwareClientGenerateBinaryHardeningSummaryResponse, error) {
	result := FirmwareClientGenerateBinaryHardeningSummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BinaryHardeningSummary); err != nil {
		return FirmwareClientGenerateBinaryHardeningSummaryResponse{}, err
	}
	return result, nil
}

// GenerateComponentDetails - The operation to get component details for a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateComponentDetailsOptions contains the optional parameters for the FirmwareClient.GenerateComponentDetails
//     method.
func (client *FirmwareClient) GenerateComponentDetails(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateComponentDetailsOptions) (FirmwareClientGenerateComponentDetailsResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateComponentDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateComponentDetailsCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateComponentDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateComponentDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateComponentDetailsResponse{}, err
	}
	resp, err := client.generateComponentDetailsHandleResponse(httpResp)
	return resp, err
}

// generateComponentDetailsCreateRequest creates the GenerateComponentDetails request.
func (client *FirmwareClient) generateComponentDetailsCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateComponentDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateComponentDetails"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateComponentDetailsHandleResponse handles the GenerateComponentDetails response.
func (client *FirmwareClient) generateComponentDetailsHandleResponse(resp *http.Response) (FirmwareClientGenerateComponentDetailsResponse, error) {
	result := FirmwareClientGenerateComponentDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Component); err != nil {
		return FirmwareClientGenerateComponentDetailsResponse{}, err
	}
	return result, nil
}

// GenerateCryptoCertificateSummary - The operation to provide a high level summary of the discovered cryptographic certificates
// reported for the firmware image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateCryptoCertificateSummaryOptions contains the optional parameters for the FirmwareClient.GenerateCryptoCertificateSummary
//     method.
func (client *FirmwareClient) GenerateCryptoCertificateSummary(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateCryptoCertificateSummaryOptions) (FirmwareClientGenerateCryptoCertificateSummaryResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateCryptoCertificateSummary"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateCryptoCertificateSummaryCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateCryptoCertificateSummaryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateCryptoCertificateSummaryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateCryptoCertificateSummaryResponse{}, err
	}
	resp, err := client.generateCryptoCertificateSummaryHandleResponse(httpResp)
	return resp, err
}

// generateCryptoCertificateSummaryCreateRequest creates the GenerateCryptoCertificateSummary request.
func (client *FirmwareClient) generateCryptoCertificateSummaryCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateCryptoCertificateSummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateCryptoCertificateSummary"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateCryptoCertificateSummaryHandleResponse handles the GenerateCryptoCertificateSummary response.
func (client *FirmwareClient) generateCryptoCertificateSummaryHandleResponse(resp *http.Response) (FirmwareClientGenerateCryptoCertificateSummaryResponse, error) {
	result := FirmwareClientGenerateCryptoCertificateSummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CryptoCertificateSummary); err != nil {
		return FirmwareClientGenerateCryptoCertificateSummaryResponse{}, err
	}
	return result, nil
}

// GenerateCryptoKeySummary - The operation to provide a high level summary of the discovered cryptographic keys reported
// for the firmware image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateCryptoKeySummaryOptions contains the optional parameters for the FirmwareClient.GenerateCryptoKeySummary
//     method.
func (client *FirmwareClient) GenerateCryptoKeySummary(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateCryptoKeySummaryOptions) (FirmwareClientGenerateCryptoKeySummaryResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateCryptoKeySummary"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateCryptoKeySummaryCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateCryptoKeySummaryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateCryptoKeySummaryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateCryptoKeySummaryResponse{}, err
	}
	resp, err := client.generateCryptoKeySummaryHandleResponse(httpResp)
	return resp, err
}

// generateCryptoKeySummaryCreateRequest creates the GenerateCryptoKeySummary request.
func (client *FirmwareClient) generateCryptoKeySummaryCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateCryptoKeySummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateCryptoKeySummary"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateCryptoKeySummaryHandleResponse handles the GenerateCryptoKeySummary response.
func (client *FirmwareClient) generateCryptoKeySummaryHandleResponse(resp *http.Response) (FirmwareClientGenerateCryptoKeySummaryResponse, error) {
	result := FirmwareClientGenerateCryptoKeySummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CryptoKeySummary); err != nil {
		return FirmwareClientGenerateCryptoKeySummaryResponse{}, err
	}
	return result, nil
}

// GenerateCveSummary - The operation to provide a high level summary of the CVEs reported for the firmware image.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateCveSummaryOptions contains the optional parameters for the FirmwareClient.GenerateCveSummary
//     method.
func (client *FirmwareClient) GenerateCveSummary(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateCveSummaryOptions) (FirmwareClientGenerateCveSummaryResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateCveSummary"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateCveSummaryCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateCveSummaryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateCveSummaryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateCveSummaryResponse{}, err
	}
	resp, err := client.generateCveSummaryHandleResponse(httpResp)
	return resp, err
}

// generateCveSummaryCreateRequest creates the GenerateCveSummary request.
func (client *FirmwareClient) generateCveSummaryCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateCveSummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateCveSummary"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateCveSummaryHandleResponse handles the GenerateCveSummary response.
func (client *FirmwareClient) generateCveSummaryHandleResponse(resp *http.Response) (FirmwareClientGenerateCveSummaryResponse, error) {
	result := FirmwareClientGenerateCveSummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CveSummary); err != nil {
		return FirmwareClientGenerateCveSummaryResponse{}, err
	}
	return result, nil
}

// GenerateDownloadURL - The operation to a url for file download.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateDownloadURLOptions contains the optional parameters for the FirmwareClient.GenerateDownloadURL
//     method.
func (client *FirmwareClient) GenerateDownloadURL(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateDownloadURLOptions) (FirmwareClientGenerateDownloadURLResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateDownloadURL"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateDownloadURLCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateDownloadURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateDownloadURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateDownloadURLResponse{}, err
	}
	resp, err := client.generateDownloadURLHandleResponse(httpResp)
	return resp, err
}

// generateDownloadURLCreateRequest creates the GenerateDownloadURL request.
func (client *FirmwareClient) generateDownloadURLCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateDownloadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateDownloadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateDownloadURLHandleResponse handles the GenerateDownloadURL response.
func (client *FirmwareClient) generateDownloadURLHandleResponse(resp *http.Response) (FirmwareClientGenerateDownloadURLResponse, error) {
	result := FirmwareClientGenerateDownloadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.URLToken); err != nil {
		return FirmwareClientGenerateDownloadURLResponse{}, err
	}
	return result, nil
}

// GenerateFilesystemDownloadURL - The operation to a url for tar file download.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateFilesystemDownloadURLOptions contains the optional parameters for the FirmwareClient.GenerateFilesystemDownloadURL
//     method.
func (client *FirmwareClient) GenerateFilesystemDownloadURL(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateFilesystemDownloadURLOptions) (FirmwareClientGenerateFilesystemDownloadURLResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateFilesystemDownloadURL"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateFilesystemDownloadURLCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateFilesystemDownloadURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateFilesystemDownloadURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateFilesystemDownloadURLResponse{}, err
	}
	resp, err := client.generateFilesystemDownloadURLHandleResponse(httpResp)
	return resp, err
}

// generateFilesystemDownloadURLCreateRequest creates the GenerateFilesystemDownloadURL request.
func (client *FirmwareClient) generateFilesystemDownloadURLCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateFilesystemDownloadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateFilesystemDownloadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateFilesystemDownloadURLHandleResponse handles the GenerateFilesystemDownloadURL response.
func (client *FirmwareClient) generateFilesystemDownloadURLHandleResponse(resp *http.Response) (FirmwareClientGenerateFilesystemDownloadURLResponse, error) {
	result := FirmwareClientGenerateFilesystemDownloadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.URLToken); err != nil {
		return FirmwareClientGenerateFilesystemDownloadURLResponse{}, err
	}
	return result, nil
}

// GenerateSummary - The operation to get a scan summary.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGenerateSummaryOptions contains the optional parameters for the FirmwareClient.GenerateSummary
//     method.
func (client *FirmwareClient) GenerateSummary(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateSummaryOptions) (FirmwareClientGenerateSummaryResponse, error) {
	var err error
	const operationName = "FirmwareClient.GenerateSummary"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateSummaryCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGenerateSummaryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGenerateSummaryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGenerateSummaryResponse{}, err
	}
	resp, err := client.generateSummaryHandleResponse(httpResp)
	return resp, err
}

// generateSummaryCreateRequest creates the GenerateSummary request.
func (client *FirmwareClient) generateSummaryCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGenerateSummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateSummary"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateSummaryHandleResponse handles the GenerateSummary response.
func (client *FirmwareClient) generateSummaryHandleResponse(resp *http.Response) (FirmwareClientGenerateSummaryResponse, error) {
	result := FirmwareClientGenerateSummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FirmwareSummary); err != nil {
		return FirmwareClientGenerateSummaryResponse{}, err
	}
	return result, nil
}

// Get - Get firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientGetOptions contains the optional parameters for the FirmwareClient.Get method.
func (client *FirmwareClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGetOptions) (FirmwareClientGetResponse, error) {
	var err error
	const operationName = "FirmwareClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwareClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FirmwareClient) getCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FirmwareClient) getHandleResponse(resp *http.Response) (FirmwareClientGetResponse, error) {
	result := FirmwareClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Firmware); err != nil {
		return FirmwareClientGetResponse{}, err
	}
	return result, nil
}

// NewListByWorkspacePager - Lists all of firmwares inside a workspace.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - options - FirmwareClientListByWorkspaceOptions contains the optional parameters for the FirmwareClient.NewListByWorkspacePager
//     method.
func (client *FirmwareClient) NewListByWorkspacePager(resourceGroupName string, workspaceName string, options *FirmwareClientListByWorkspaceOptions) *runtime.Pager[FirmwareClientListByWorkspaceResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListByWorkspaceResponse]{
		More: func(page FirmwareClientListByWorkspaceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListByWorkspaceResponse) (FirmwareClientListByWorkspaceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListByWorkspacePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByWorkspaceCreateRequest(ctx, resourceGroupName, workspaceName, options)
			}, nil)
			if err != nil {
				return FirmwareClientListByWorkspaceResponse{}, err
			}
			return client.listByWorkspaceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByWorkspaceCreateRequest creates the ListByWorkspace request.
func (client *FirmwareClient) listByWorkspaceCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, options *FirmwareClientListByWorkspaceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByWorkspaceHandleResponse handles the ListByWorkspace response.
func (client *FirmwareClient) listByWorkspaceHandleResponse(resp *http.Response) (FirmwareClientListByWorkspaceResponse, error) {
	result := FirmwareClientListByWorkspaceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FirmwareList); err != nil {
		return FirmwareClientListByWorkspaceResponse{}, err
	}
	return result, nil
}

// NewListGenerateBinaryHardeningListPager - The operation to list all binary hardening result for a firmware.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientListGenerateBinaryHardeningListOptions contains the optional parameters for the FirmwareClient.NewListGenerateBinaryHardeningListPager
//     method.
func (client *FirmwareClient) NewListGenerateBinaryHardeningListPager(resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateBinaryHardeningListOptions) *runtime.Pager[FirmwareClientListGenerateBinaryHardeningListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListGenerateBinaryHardeningListResponse]{
		More: func(page FirmwareClientListGenerateBinaryHardeningListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListGenerateBinaryHardeningListResponse) (FirmwareClientListGenerateBinaryHardeningListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListGenerateBinaryHardeningListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listGenerateBinaryHardeningListCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return FirmwareClientListGenerateBinaryHardeningListResponse{}, err
			}
			return client.listGenerateBinaryHardeningListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGenerateBinaryHardeningListCreateRequest creates the ListGenerateBinaryHardeningList request.
func (client *FirmwareClient) listGenerateBinaryHardeningListCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateBinaryHardeningListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateBinaryHardeningList"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGenerateBinaryHardeningListHandleResponse handles the ListGenerateBinaryHardeningList response.
func (client *FirmwareClient) listGenerateBinaryHardeningListHandleResponse(resp *http.Response) (FirmwareClientListGenerateBinaryHardeningListResponse, error) {
	result := FirmwareClientListGenerateBinaryHardeningListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BinaryHardeningList); err != nil {
		return FirmwareClientListGenerateBinaryHardeningListResponse{}, err
	}
	return result, nil
}

// NewListGenerateComponentListPager - The operation to list all components result for a firmware.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientListGenerateComponentListOptions contains the optional parameters for the FirmwareClient.NewListGenerateComponentListPager
//     method.
func (client *FirmwareClient) NewListGenerateComponentListPager(resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateComponentListOptions) *runtime.Pager[FirmwareClientListGenerateComponentListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListGenerateComponentListResponse]{
		More: func(page FirmwareClientListGenerateComponentListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListGenerateComponentListResponse) (FirmwareClientListGenerateComponentListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListGenerateComponentListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listGenerateComponentListCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return FirmwareClientListGenerateComponentListResponse{}, err
			}
			return client.listGenerateComponentListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGenerateComponentListCreateRequest creates the ListGenerateComponentList request.
func (client *FirmwareClient) listGenerateComponentListCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateComponentListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateComponentList"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGenerateComponentListHandleResponse handles the ListGenerateComponentList response.
func (client *FirmwareClient) listGenerateComponentListHandleResponse(resp *http.Response) (FirmwareClientListGenerateComponentListResponse, error) {
	result := FirmwareClientListGenerateComponentListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComponentList); err != nil {
		return FirmwareClientListGenerateComponentListResponse{}, err
	}
	return result, nil
}

// NewListGenerateCryptoCertificateListPager - The operation to list all crypto certificates for a firmware.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientListGenerateCryptoCertificateListOptions contains the optional parameters for the FirmwareClient.NewListGenerateCryptoCertificateListPager
//     method.
func (client *FirmwareClient) NewListGenerateCryptoCertificateListPager(resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateCryptoCertificateListOptions) *runtime.Pager[FirmwareClientListGenerateCryptoCertificateListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListGenerateCryptoCertificateListResponse]{
		More: func(page FirmwareClientListGenerateCryptoCertificateListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListGenerateCryptoCertificateListResponse) (FirmwareClientListGenerateCryptoCertificateListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListGenerateCryptoCertificateListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listGenerateCryptoCertificateListCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return FirmwareClientListGenerateCryptoCertificateListResponse{}, err
			}
			return client.listGenerateCryptoCertificateListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGenerateCryptoCertificateListCreateRequest creates the ListGenerateCryptoCertificateList request.
func (client *FirmwareClient) listGenerateCryptoCertificateListCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateCryptoCertificateListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateCryptoCertificateList"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGenerateCryptoCertificateListHandleResponse handles the ListGenerateCryptoCertificateList response.
func (client *FirmwareClient) listGenerateCryptoCertificateListHandleResponse(resp *http.Response) (FirmwareClientListGenerateCryptoCertificateListResponse, error) {
	result := FirmwareClientListGenerateCryptoCertificateListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CryptoCertificateList); err != nil {
		return FirmwareClientListGenerateCryptoCertificateListResponse{}, err
	}
	return result, nil
}

// NewListGenerateCryptoKeyListPager - The operation to list all crypto keys for a firmware.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientListGenerateCryptoKeyListOptions contains the optional parameters for the FirmwareClient.NewListGenerateCryptoKeyListPager
//     method.
func (client *FirmwareClient) NewListGenerateCryptoKeyListPager(resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateCryptoKeyListOptions) *runtime.Pager[FirmwareClientListGenerateCryptoKeyListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListGenerateCryptoKeyListResponse]{
		More: func(page FirmwareClientListGenerateCryptoKeyListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListGenerateCryptoKeyListResponse) (FirmwareClientListGenerateCryptoKeyListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListGenerateCryptoKeyListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listGenerateCryptoKeyListCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return FirmwareClientListGenerateCryptoKeyListResponse{}, err
			}
			return client.listGenerateCryptoKeyListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGenerateCryptoKeyListCreateRequest creates the ListGenerateCryptoKeyList request.
func (client *FirmwareClient) listGenerateCryptoKeyListCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateCryptoKeyListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateCryptoKeyList"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGenerateCryptoKeyListHandleResponse handles the ListGenerateCryptoKeyList response.
func (client *FirmwareClient) listGenerateCryptoKeyListHandleResponse(resp *http.Response) (FirmwareClientListGenerateCryptoKeyListResponse, error) {
	result := FirmwareClientListGenerateCryptoKeyListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CryptoKeyList); err != nil {
		return FirmwareClientListGenerateCryptoKeyListResponse{}, err
	}
	return result, nil
}

// NewListGenerateCveListPager - The operation to list all cve results for a firmware.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientListGenerateCveListOptions contains the optional parameters for the FirmwareClient.NewListGenerateCveListPager
//     method.
func (client *FirmwareClient) NewListGenerateCveListPager(resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateCveListOptions) *runtime.Pager[FirmwareClientListGenerateCveListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListGenerateCveListResponse]{
		More: func(page FirmwareClientListGenerateCveListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListGenerateCveListResponse) (FirmwareClientListGenerateCveListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListGenerateCveListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listGenerateCveListCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return FirmwareClientListGenerateCveListResponse{}, err
			}
			return client.listGenerateCveListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGenerateCveListCreateRequest creates the ListGenerateCveList request.
func (client *FirmwareClient) listGenerateCveListCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGenerateCveListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateCveList"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGenerateCveListHandleResponse handles the ListGenerateCveList response.
func (client *FirmwareClient) listGenerateCveListHandleResponse(resp *http.Response) (FirmwareClientListGenerateCveListResponse, error) {
	result := FirmwareClientListGenerateCveListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CveList); err != nil {
		return FirmwareClientListGenerateCveListResponse{}, err
	}
	return result, nil
}

// NewListGeneratePasswordHashListPager - The operation to list all password hashes for a firmware.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwareClientListGeneratePasswordHashListOptions contains the optional parameters for the FirmwareClient.NewListGeneratePasswordHashListPager
//     method.
func (client *FirmwareClient) NewListGeneratePasswordHashListPager(resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGeneratePasswordHashListOptions) *runtime.Pager[FirmwareClientListGeneratePasswordHashListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwareClientListGeneratePasswordHashListResponse]{
		More: func(page FirmwareClientListGeneratePasswordHashListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwareClientListGeneratePasswordHashListResponse) (FirmwareClientListGeneratePasswordHashListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwareClient.NewListGeneratePasswordHashListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listGeneratePasswordHashListCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return FirmwareClientListGeneratePasswordHashListResponse{}, err
			}
			return client.listGeneratePasswordHashListHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGeneratePasswordHashListCreateRequest creates the ListGeneratePasswordHashList request.
func (client *FirmwareClient) listGeneratePasswordHashListCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwareClientListGeneratePasswordHashListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generatePasswordHashList"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGeneratePasswordHashListHandleResponse handles the ListGeneratePasswordHashList response.
func (client *FirmwareClient) listGeneratePasswordHashListHandleResponse(resp *http.Response) (FirmwareClientListGeneratePasswordHashListResponse, error) {
	result := FirmwareClientListGeneratePasswordHashListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PasswordHashList); err != nil {
		return FirmwareClientListGeneratePasswordHashListResponse{}, err
	}
	return result, nil
}

// Update - The operation to update firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-08-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - firmware - Details of the firmware being created or updated.
//   - options - FirmwareClientUpdateOptions contains the optional parameters for the FirmwareClient.Update method.
func (client *FirmwareClient) Update(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware FirmwareUpdateDefinition, options *FirmwareClientUpdateOptions) (FirmwareClientUpdateResponse, error) {
	var err error
	const operationName = "FirmwareClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, firmware, options)
	if err != nil {
		return FirmwareClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwareClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FirmwareClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *FirmwareClient) updateCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware FirmwareUpdateDefinition, options *FirmwareClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-08-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, firmware); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *FirmwareClient) updateHandleResponse(resp *http.Response) (FirmwareClientUpdateResponse, error) {
	result := FirmwareClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Firmware); err != nil {
		return FirmwareClientUpdateResponse{}, err
	}
	return result, nil
}
