//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmachinelearning_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/machinelearning/armmachinelearning/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/list.json
func ExampleDatastoresClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatastoresClient().NewListPager("test-rg", "my-aml-workspace", &armmachinelearning.DatastoresClientListOptions{Skip: nil,
		Count:     to.Ptr[int32](1),
		IsDefault: to.Ptr(false),
		Names: []string{
			"string"},
		SearchText: to.Ptr("string"),
		OrderBy:    to.Ptr("string"),
		OrderByAsc: to.Ptr(false),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatastoreResourceArmPaginatedResult = armmachinelearning.DatastoreResourceArmPaginatedResult{
		// 	Value: []*armmachinelearning.Datastore{
		// 		{
		// 			Name: to.Ptr("string"),
		// 			Type: to.Ptr("string"),
		// 			ID: to.Ptr("string"),
		// 			SystemData: &armmachinelearning.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
		// 			},
		// 			Properties: &armmachinelearning.AzureBlobDatastore{
		// 				Description: to.Ptr("string"),
		// 				Tags: map[string]*string{
		// 					"string": to.Ptr("string"),
		// 				},
		// 				Credentials: &armmachinelearning.AccountKeyDatastoreCredentials{
		// 					CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeAccountKey),
		// 				},
		// 				DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureBlob),
		// 				IsDefault: to.Ptr(false),
		// 				AccountName: to.Ptr("string"),
		// 				ContainerName: to.Ptr("string"),
		// 				Endpoint: to.Ptr("core.windows.net"),
		// 				Protocol: to.Ptr("https"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/delete.json
func ExampleDatastoresClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDatastoresClient().Delete(ctx, "test-rg", "my-aml-workspace", "string", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/get.json
func ExampleDatastoresClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatastoresClient().Get(ctx, "test-rg", "my-aml-workspace", "string", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Datastore = armmachinelearning.Datastore{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Properties: &armmachinelearning.AzureBlobDatastore{
	// 		Description: to.Ptr("string"),
	// 		Tags: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Credentials: &armmachinelearning.AccountKeyDatastoreCredentials{
	// 			CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeAccountKey),
	// 		},
	// 		DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureBlob),
	// 		IsDefault: to.Ptr(false),
	// 		AccountName: to.Ptr("string"),
	// 		ContainerName: to.Ptr("string"),
	// 		Endpoint: to.Ptr("core.windows.net"),
	// 		Protocol: to.Ptr("https"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/AzureDataLakeGen1WServicePrincipal/createOrUpdate.json
func ExampleDatastoresClient_CreateOrUpdate_createOrUpdateDatastoreAzureDataLakeGen1WServicePrincipal() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatastoresClient().CreateOrUpdate(ctx, "test-rg", "my-aml-workspace", "string", armmachinelearning.Datastore{
		Properties: &armmachinelearning.AzureDataLakeGen1Datastore{
			Description: to.Ptr("string"),
			Tags: map[string]*string{
				"string": to.Ptr("string"),
			},
			Credentials: &armmachinelearning.ServicePrincipalDatastoreCredentials{
				CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeServicePrincipal),
				AuthorityURL:    to.Ptr("string"),
				ClientID:        to.Ptr("00000000-1111-2222-3333-444444444444"),
				ResourceURL:     to.Ptr("string"),
				Secrets: &armmachinelearning.ServicePrincipalDatastoreSecrets{
					SecretsType:  to.Ptr(armmachinelearning.SecretsTypeServicePrincipal),
					ClientSecret: to.Ptr("string"),
				},
				TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
			},
			DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureDataLakeGen1),
			StoreName:     to.Ptr("string"),
		},
	}, &armmachinelearning.DatastoresClientCreateOrUpdateOptions{SkipValidation: to.Ptr(false)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Datastore = armmachinelearning.Datastore{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Properties: &armmachinelearning.AzureDataLakeGen1Datastore{
	// 		Description: to.Ptr("string"),
	// 		Tags: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Credentials: &armmachinelearning.ServicePrincipalDatastoreCredentials{
	// 			CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeServicePrincipal),
	// 			AuthorityURL: to.Ptr("string"),
	// 			ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			ResourceURL: to.Ptr("string"),
	// 			TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		},
	// 		DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureDataLakeGen1),
	// 		StoreName: to.Ptr("string"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/AzureDataLakeGen2WServicePrincipal/createOrUpdate.json
func ExampleDatastoresClient_CreateOrUpdate_createOrUpdateDatastoreAzureDataLakeGen2WServicePrincipal() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatastoresClient().CreateOrUpdate(ctx, "test-rg", "my-aml-workspace", "string", armmachinelearning.Datastore{
		Properties: &armmachinelearning.AzureDataLakeGen2Datastore{
			Description: to.Ptr("string"),
			Tags: map[string]*string{
				"string": to.Ptr("string"),
			},
			Credentials: &armmachinelearning.ServicePrincipalDatastoreCredentials{
				CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeServicePrincipal),
				AuthorityURL:    to.Ptr("string"),
				ClientID:        to.Ptr("00000000-1111-2222-3333-444444444444"),
				ResourceURL:     to.Ptr("string"),
				Secrets: &armmachinelearning.ServicePrincipalDatastoreSecrets{
					SecretsType:  to.Ptr(armmachinelearning.SecretsTypeServicePrincipal),
					ClientSecret: to.Ptr("string"),
				},
				TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
			},
			DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureDataLakeGen2),
			AccountName:   to.Ptr("string"),
			Endpoint:      to.Ptr("string"),
			Filesystem:    to.Ptr("string"),
			Protocol:      to.Ptr("string"),
		},
	}, &armmachinelearning.DatastoresClientCreateOrUpdateOptions{SkipValidation: to.Ptr(false)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Datastore = armmachinelearning.Datastore{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Properties: &armmachinelearning.AzureDataLakeGen2Datastore{
	// 		Description: to.Ptr("string"),
	// 		Tags: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Credentials: &armmachinelearning.ServicePrincipalDatastoreCredentials{
	// 			CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeServicePrincipal),
	// 			AuthorityURL: to.Ptr("string"),
	// 			ClientID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 			ResourceURL: to.Ptr("string"),
	// 			TenantID: to.Ptr("00000000-1111-2222-3333-444444444444"),
	// 		},
	// 		DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureDataLakeGen2),
	// 		AccountName: to.Ptr("string"),
	// 		Endpoint: to.Ptr("string"),
	// 		Filesystem: to.Ptr("string"),
	// 		Protocol: to.Ptr("string"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/AzureFileWAccountKey/createOrUpdate.json
func ExampleDatastoresClient_CreateOrUpdate_createOrUpdateDatastoreAzureFileStoreWAccountKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatastoresClient().CreateOrUpdate(ctx, "test-rg", "my-aml-workspace", "string", armmachinelearning.Datastore{
		Properties: &armmachinelearning.AzureFileDatastore{
			Description: to.Ptr("string"),
			Tags: map[string]*string{
				"string": to.Ptr("string"),
			},
			Credentials: &armmachinelearning.AccountKeyDatastoreCredentials{
				CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeAccountKey),
				Secrets: &armmachinelearning.AccountKeyDatastoreSecrets{
					SecretsType: to.Ptr(armmachinelearning.SecretsTypeAccountKey),
					Key:         to.Ptr("string"),
				},
			},
			DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureFile),
			AccountName:   to.Ptr("string"),
			Endpoint:      to.Ptr("string"),
			FileShareName: to.Ptr("string"),
			Protocol:      to.Ptr("string"),
		},
	}, &armmachinelearning.DatastoresClientCreateOrUpdateOptions{SkipValidation: to.Ptr(false)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Datastore = armmachinelearning.Datastore{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Properties: &armmachinelearning.AzureFileDatastore{
	// 		Description: to.Ptr("string"),
	// 		Tags: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Credentials: &armmachinelearning.AccountKeyDatastoreCredentials{
	// 			CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeAccountKey),
	// 		},
	// 		DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureFile),
	// 		AccountName: to.Ptr("string"),
	// 		Endpoint: to.Ptr("string"),
	// 		FileShareName: to.Ptr("string"),
	// 		Protocol: to.Ptr("string"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/AzureBlobWAccountKey/createOrUpdate.json
func ExampleDatastoresClient_CreateOrUpdate_createOrUpdateDatastoreAzureBlobWAccountKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatastoresClient().CreateOrUpdate(ctx, "test-rg", "my-aml-workspace", "string", armmachinelearning.Datastore{
		Properties: &armmachinelearning.AzureBlobDatastore{
			Description: to.Ptr("string"),
			Tags: map[string]*string{
				"string": to.Ptr("string"),
			},
			Credentials: &armmachinelearning.AccountKeyDatastoreCredentials{
				CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeAccountKey),
				Secrets: &armmachinelearning.AccountKeyDatastoreSecrets{
					SecretsType: to.Ptr(armmachinelearning.SecretsTypeAccountKey),
					Key:         to.Ptr("string"),
				},
			},
			DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureBlob),
			AccountName:   to.Ptr("string"),
			ContainerName: to.Ptr("string"),
			Endpoint:      to.Ptr("core.windows.net"),
			Protocol:      to.Ptr("https"),
		},
	}, &armmachinelearning.DatastoresClientCreateOrUpdateOptions{SkipValidation: to.Ptr(false)})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Datastore = armmachinelearning.Datastore{
	// 	Name: to.Ptr("string"),
	// 	Type: to.Ptr("string"),
	// 	ID: to.Ptr("string"),
	// 	SystemData: &armmachinelearning.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:34:56.999Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmachinelearning.CreatedByTypeUser),
	// 	},
	// 	Properties: &armmachinelearning.AzureBlobDatastore{
	// 		Description: to.Ptr("string"),
	// 		Tags: map[string]*string{
	// 			"string": to.Ptr("string"),
	// 		},
	// 		Credentials: &armmachinelearning.AccountKeyDatastoreCredentials{
	// 			CredentialsType: to.Ptr(armmachinelearning.CredentialsTypeAccountKey),
	// 		},
	// 		DatastoreType: to.Ptr(armmachinelearning.DatastoreTypeAzureBlob),
	// 		IsDefault: to.Ptr(false),
	// 		AccountName: to.Ptr("string"),
	// 		ContainerName: to.Ptr("string"),
	// 		Endpoint: to.Ptr("core.windows.net"),
	// 		Protocol: to.Ptr("https"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/aafb0944f7ab936e8cfbad8969bd5eb32263fb4f/specification/machinelearningservices/resource-manager/Microsoft.MachineLearningServices/stable/2022-10-01/examples/Datastore/listSecrets.json
func ExampleDatastoresClient_ListSecrets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmachinelearning.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatastoresClient().ListSecrets(ctx, "test-rg", "my-aml-workspace", "string", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armmachinelearning.DatastoresClientListSecretsResponse{
	// 	                            DatastoreSecretsClassification: &armmachinelearning.AccountKeyDatastoreSecrets{
	// 		SecretsType: to.Ptr(armmachinelearning.SecretsTypeAccountKey),
	// 		Key: to.Ptr("string"),
	// 	},
	// 	                        }
}
