//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// MetricDefinitionsServer is a fake server for instances of the armmonitor.MetricDefinitionsClient type.
type MetricDefinitionsServer struct {
	// NewListPager is the fake for method MetricDefinitionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armmonitor.MetricDefinitionsClientListOptions) (resp azfake.PagerResponder[armmonitor.MetricDefinitionsClientListResponse])

	// NewListAtSubscriptionScopePager is the fake for method MetricDefinitionsClient.NewListAtSubscriptionScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtSubscriptionScopePager func(region string, options *armmonitor.MetricDefinitionsClientListAtSubscriptionScopeOptions) (resp azfake.PagerResponder[armmonitor.MetricDefinitionsClientListAtSubscriptionScopeResponse])
}

// NewMetricDefinitionsServerTransport creates a new instance of MetricDefinitionsServerTransport with the provided implementation.
// The returned MetricDefinitionsServerTransport instance is connected to an instance of armmonitor.MetricDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMetricDefinitionsServerTransport(srv *MetricDefinitionsServer) *MetricDefinitionsServerTransport {
	return &MetricDefinitionsServerTransport{
		srv:                             srv,
		newListPager:                    newTracker[azfake.PagerResponder[armmonitor.MetricDefinitionsClientListResponse]](),
		newListAtSubscriptionScopePager: newTracker[azfake.PagerResponder[armmonitor.MetricDefinitionsClientListAtSubscriptionScopeResponse]](),
	}
}

// MetricDefinitionsServerTransport connects instances of armmonitor.MetricDefinitionsClient to instances of MetricDefinitionsServer.
// Don't use this type directly, use NewMetricDefinitionsServerTransport instead.
type MetricDefinitionsServerTransport struct {
	srv                             *MetricDefinitionsServer
	newListPager                    *tracker[azfake.PagerResponder[armmonitor.MetricDefinitionsClientListResponse]]
	newListAtSubscriptionScopePager *tracker[azfake.PagerResponder[armmonitor.MetricDefinitionsClientListAtSubscriptionScopeResponse]]
}

// Do implements the policy.Transporter interface for MetricDefinitionsServerTransport.
func (m *MetricDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MetricDefinitionsClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MetricDefinitionsClient.NewListAtSubscriptionScopePager":
		resp, err = m.dispatchNewListAtSubscriptionScopePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MetricDefinitionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/metricDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		metricnamespaceUnescaped, err := url.QueryUnescape(qp.Get("metricnamespace"))
		if err != nil {
			return nil, err
		}
		metricnamespaceParam := getOptional(metricnamespaceUnescaped)
		var options *armmonitor.MetricDefinitionsClientListOptions
		if metricnamespaceParam != nil {
			options = &armmonitor.MetricDefinitionsClientListOptions{
				Metricnamespace: metricnamespaceParam,
			}
		}
		resp := m.srv.NewListPager(resourceURIParam, options)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MetricDefinitionsServerTransport) dispatchNewListAtSubscriptionScopePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListAtSubscriptionScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtSubscriptionScopePager not implemented")}
	}
	newListAtSubscriptionScopePager := m.newListAtSubscriptionScopePager.get(req)
	if newListAtSubscriptionScopePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/metricDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		regionParam, err := url.QueryUnescape(qp.Get("region"))
		if err != nil {
			return nil, err
		}
		metricnamespaceUnescaped, err := url.QueryUnescape(qp.Get("metricnamespace"))
		if err != nil {
			return nil, err
		}
		metricnamespaceParam := getOptional(metricnamespaceUnescaped)
		var options *armmonitor.MetricDefinitionsClientListAtSubscriptionScopeOptions
		if metricnamespaceParam != nil {
			options = &armmonitor.MetricDefinitionsClientListAtSubscriptionScopeOptions{
				Metricnamespace: metricnamespaceParam,
			}
		}
		resp := m.srv.NewListAtSubscriptionScopePager(regionParam, options)
		newListAtSubscriptionScopePager = &resp
		m.newListAtSubscriptionScopePager.add(req, newListAtSubscriptionScopePager)
	}
	resp, err := server.PagerResponderNext(newListAtSubscriptionScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListAtSubscriptionScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtSubscriptionScopePager) {
		m.newListAtSubscriptionScopePager.remove(req)
	}
	return resp, nil
}
