//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VulnerabilityAssessmentsSettingsClient contains the methods for the SQLVulnerabilityAssessmentsSettings group.
// Don't use this type directly, use NewVulnerabilityAssessmentsSettingsClient() instead.
type VulnerabilityAssessmentsSettingsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVulnerabilityAssessmentsSettingsClient creates a new instance of VulnerabilityAssessmentsSettingsClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVulnerabilityAssessmentsSettingsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VulnerabilityAssessmentsSettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VulnerabilityAssessmentsSettingsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates SQL Vulnerability Assessment policy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - parameters - The requested resource.
//   - options - VulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions contains the optional parameters for the VulnerabilityAssessmentsSettingsClient.CreateOrUpdate
//     method.
func (client *VulnerabilityAssessmentsSettingsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters VulnerabilityAssessment, options *VulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions) (VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentsSettingsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, parameters, options)
	if err != nil {
		return VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VulnerabilityAssessmentsSettingsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, parameters VulnerabilityAssessment, options *VulnerabilityAssessmentsSettingsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *VulnerabilityAssessmentsSettingsClient) createOrUpdateHandleResponse(resp *http.Response) (VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse, error) {
	result := VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessment); err != nil {
		return VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Get - Gets SQL Vulnerability Assessment policy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the SQL Vulnerability Assessment.
//   - options - VulnerabilityAssessmentsSettingsClientGetOptions contains the optional parameters for the VulnerabilityAssessmentsSettingsClient.Get
//     method.
func (client *VulnerabilityAssessmentsSettingsClient) Get(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, options *VulnerabilityAssessmentsSettingsClientGetOptions) (VulnerabilityAssessmentsSettingsClientGetResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentsSettingsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
	if err != nil {
		return VulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VulnerabilityAssessmentsSettingsClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName SQLVulnerabilityAssessmentName, options *VulnerabilityAssessmentsSettingsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VulnerabilityAssessmentsSettingsClient) getHandleResponse(resp *http.Response) (VulnerabilityAssessmentsSettingsClientGetResponse, error) {
	result := VulnerabilityAssessmentsSettingsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessment); err != nil {
		return VulnerabilityAssessmentsSettingsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByServerPager - Lists SQL Vulnerability Assessment policies associated with a server.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - options - VulnerabilityAssessmentsSettingsClientListByServerOptions contains the optional parameters for the VulnerabilityAssessmentsSettingsClient.NewListByServerPager
//     method.
func (client *VulnerabilityAssessmentsSettingsClient) NewListByServerPager(resourceGroupName string, serverName string, options *VulnerabilityAssessmentsSettingsClientListByServerOptions) *runtime.Pager[VulnerabilityAssessmentsSettingsClientListByServerResponse] {
	return runtime.NewPager(runtime.PagingHandler[VulnerabilityAssessmentsSettingsClientListByServerResponse]{
		More: func(page VulnerabilityAssessmentsSettingsClientListByServerResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VulnerabilityAssessmentsSettingsClientListByServerResponse) (VulnerabilityAssessmentsSettingsClientListByServerResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VulnerabilityAssessmentsSettingsClient.NewListByServerPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByServerCreateRequest(ctx, resourceGroupName, serverName, options)
			}, nil)
			if err != nil {
				return VulnerabilityAssessmentsSettingsClientListByServerResponse{}, err
			}
			return client.listByServerHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByServerCreateRequest creates the ListByServer request.
func (client *VulnerabilityAssessmentsSettingsClient) listByServerCreateRequest(ctx context.Context, resourceGroupName string, serverName string, options *VulnerabilityAssessmentsSettingsClientListByServerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByServerHandleResponse handles the ListByServer response.
func (client *VulnerabilityAssessmentsSettingsClient) listByServerHandleResponse(resp *http.Response) (VulnerabilityAssessmentsSettingsClientListByServerResponse, error) {
	result := VulnerabilityAssessmentsSettingsClientListByServerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentListResult); err != nil {
		return VulnerabilityAssessmentsSettingsClientListByServerResponse{}, err
	}
	return result, nil
}
