#!/bin/bash

# Copyright (c) 2019, University of Padova, Dep. of Information Engineering, SIGNET lab
#
# SPDX-License-Identifier: GPL-2.0-only
#
# Author: Michele Polese <michele.polese@gmail.com>

#
#  Plot the traces generated by outdoor-random-walk-example.cc
#

cat mobility-trace-example.mob | awk -F " " '{ print $3 }' | awk -F "=" '{ print $2 }' | awk -F ":" '{ print $1" "$2 }' > pos.txt
cat >aa <<EOL
set terminal postscript eps noenhanced color
set output 'map.eps'
set view map
set xlabel 'X [m]'
set ylabel 'Y [m]'
set xrange [-25:1300]
set yrange [-25:800]
set style fill transparent solid 0.5
unset key
set style fill  transparent solid 0.35 noborder
set style circle radius 5
plot "pos.txt" with circles lc rgb "blue"
EOL
gnuplot buildings.txt aa
rm aa
rm pos.txt
