with Standard_Natural_Numbers;            use Standard_Natural_Numbers;
with Standard_Integer_Numbers;            use Standard_Integer_Numbers;
with Generic_Lists;
with Permutations;                        use Permutations;

package Symmetry_Group is

-- DESCRIPTION :
--   This package offers operations on elements of a symmetry group.

  package Lists_of_Permutations is new Generic_Lists(Link_to_Permutation);
  type List_of_Permutations is new Lists_of_Permutations.List;

-- CONSTRUCTORS :

  procedure Add ( L : in out List_of_Permutations; p : in Permutation );

  -- DESCRIPTION :
  --   Adds the permutation p to the front of the list L.

  procedure Append ( first,last : in out List_Of_Permutations;
                     p : in Permutation );

  -- DESCRIPTION :
  --   appends the permutation p to the list l1

  -- ON ENTRY :
  --   first        a list of permutations;
  --   last         a pointer to the last element of the list first;
  --   p            a permutation.

  -- ON RETURN :
  --   first        the list to which p has been appended;
  --   last         points to the last element of first.

  function Union ( a,b : List_of_Permutations ) return List_of_Permutations;

  -- DESCRIPTION :
  --   Returns the union of the two groups.

  function SymGrp ( n : integer32 ) return List_of_Permutations;

   -- DESCRIPTION :
   --   Return the transpositions that generate the full symmetry group
   --   of all permutations.

  function Generate ( g : List_of_Permutations ) return List_Of_Permutations;
  
  -- DESCRIPTION :
  --   This functions returns all possible permutations generated by g.

-- SELECTORS :

  function Number ( L : List_of_Permutations ) return natural32;

  -- DESCRIPTION :
  --   Returns the number of elements in l.

  function Is_In ( L : List_of_Permutations; p : Permutation ) return boolean;

  -- DESCRIPTION :
  --   Returns true if the permutation p belongs to the list l, returns false
  --   when this is not the case.

  generic

    with procedure Process ( p : in Permutation; continue : in out boolean );

  procedure Iterator ( L : in List_of_Permutations );

  -- DESCRIPTION :
  --   This iterator allows to enumerate all the elements
  --   in the list of permutations.

-- DESTRUCTOR :

  procedure Clear ( L : in out List_of_Permutations );

  -- DESCRIPTION :
  --   Deallocates the memory space occupied by the list of permutations.

end Symmetry_Group;
