; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown               | FileCheck %s

@.str1 = private constant [4 x i8] c"\00\00\00\00", align 1
@.str2 = private constant [4 x i8] c"\ff\ff\ff\ff", align 1

declare i32 @memcmp(i8*, i8*, i64)

define i32 @length4_same() nounwind {
; CHECK-LABEL: length4_same:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s1, i64 4) nounwind
  ret i32 %m
}

define i1 @length4_same_lt() nounwind {
; CHECK-LABEL: length4_same_lt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s1, i64 4) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i1 @length4_same_gt() nounwind {
; CHECK-LABEL: length4_same_gt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s1, i64 4) nounwind
  %c = icmp sgt i32 %m, 0
  ret i1 %c
}

define i1 @length4_same_le() nounwind {
; CHECK-LABEL: length4_same_le:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s1, i64 4) nounwind
  %c = icmp sle i32 %m, 0
  ret i1 %c
}

define i1 @length4_same_ge() nounwind {
; CHECK-LABEL: length4_same_ge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s1, i64 4) nounwind
  %c = icmp sge i32 %m, 0
  ret i1 %c
}


define i32 @length4() nounwind {
; CHECK-LABEL: length4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl $-1, %eax
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %s2 = getelementptr inbounds [4 x i8], [4 x i8]* @.str2, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s2, i64 4) nounwind
  ret i32 %m
}

define i1 @length4_lt() nounwind {
; CHECK-LABEL: length4_lt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %s2 = getelementptr inbounds [4 x i8], [4 x i8]* @.str2, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s2, i64 4) nounwind
  %c = icmp slt i32 %m, 0
  ret i1 %c
}

define i1 @length4_gt() nounwind {
; CHECK-LABEL: length4_gt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %s2 = getelementptr inbounds [4 x i8], [4 x i8]* @.str2, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s2, i64 4) nounwind
  %c = icmp sgt i32 %m, 0
  ret i1 %c
}

define i1 @length4_le() nounwind {
; CHECK-LABEL: length4_le:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %s2 = getelementptr inbounds [4 x i8], [4 x i8]* @.str2, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s2, i64 4) nounwind
  %c = icmp sle i32 %m, 0
  ret i1 %c
}

define i1 @length4_ge() nounwind {
; CHECK-LABEL: length4_ge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %s1 = getelementptr inbounds [4 x i8], [4 x i8]* @.str1, i32 0, i32 0
  %s2 = getelementptr inbounds [4 x i8], [4 x i8]* @.str2, i32 0, i32 0
  %m = tail call i32 @memcmp(i8* %s1, i8* %s2, i64 4) nounwind
  %c = icmp sge i32 %m, 0
  ret i1 %c
}


