// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: bpf-registered-target
// RUN: %clang -cc1 -triple bpfel -disable-llvm-passes -S -emit-llvm -o - %s \
// RUN: | FileCheck %s

// Check that call to preserve.static.offset is generated when bitfield
// from a struct marked with __attribute__((preserve_static_offset)) is
// accessed.

#define __ctx __attribute__((preserve_static_offset))

struct foo {
  unsigned a:1;
} __ctx;

// CHECK-LABEL: define dso_local void @lvalue_bitfield
// CHECK-SAME: (ptr noundef [[P:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.preserve.static.offset(ptr [[TMP0]])
// CHECK-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[TMP1]], align 4
// CHECK-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -2
// CHECK-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 1
// CHECK-NEXT:    store i8 [[BF_SET]], ptr [[TMP1]], align 4
// CHECK-NEXT:    ret void
//
void lvalue_bitfield(struct foo *p) {
  p->a = 1;
}
