% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambientContribSparse.R
\name{ambientContribSparse}
\alias{ambientContribSparse}
\alias{ambientContribSparse,ANY-method}
\alias{ambientContribSparse,SummarizedExperiment-method}
\title{Ambient contribution by assuming sparsity}
\usage{
ambientContribSparse(y, ...)

\S4method{ambientContribSparse}{ANY}(
  y,
  ambient,
  prop = 0.5,
  mode = c("scale", "profile", "proportion"),
  BPPARAM = SerialParam()
)

\S4method{ambientContribSparse}{SummarizedExperiment}(y, ..., assay.type = "counts")
}
\arguments{
\item{y}{A numeric matrix-like object containing counts, where each row represents a feature (usually a conjugated tag) and each column represents a cell or group of cells.

Alternatively, a \linkS4class{SummarizedExperiment} object containing such a matrix.

\code{y} can also be a numeric vector of counts; this is coerced into a one-column matrix.}

\item{...}{For the generic, further arguments to pass to individual methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{ambient}{A numeric vector of length equal to \code{nrow(y)},
containing the proportions of transcripts for each feature in the ambient solution.}

\item{prop}{Numeric scalar specifying the maximum proportion of features that are expected to be present for any cell.}

\item{mode}{String indicating the output to return, see Value.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying how parallelization should be performed.}

\item{assay.type}{Integer or string specifying the assay containing the count matrix.}
}
\value{
If \code{mode="scale"}, a numeric vector is returned quantifying the estimated \dQuote{contribution} of the ambient solution to each column of \code{y}.
Scaling \code{ambient} by each entry yields the estimated ambient profile for the corresponding column of \code{y}.

If \code{mode="profile"}, a numeric matrix is returned containing the estimated ambient profile for each column of \code{y}.
This is computed by scaling as described above; if \code{ambient} is a matrix, each column is scaled by the corresponding entry of the scaling vector.

If \code{mode="proportion"}, a numeric matrix is returned containing the proportion of counts in \code{y} that are attributable to ambient contamination.
This is computed by simply dividing the output of \code{mode="profile"} by \code{y} and capping all values at 1.
}
\description{
Estimate the contribution of the ambient solution to each droplet by assuming that no more than a certain percentage of features are actually present/expressed in the cell.
}
\details{
The assumption here is that of sparsity, i.e., no more than \code{prop * nrow(y)} features should be actually present in each cell with a non-zero number of molecules.
This is reasonable for most tag-based applications where we would expect only 1-2 tags (for cell hashing) or a minority of tags (for general CITE-seq) to be present per cell.
Thus, counts for all other features must be driven by ambient contamination, allowing us to estimate a scaling factor for each cell based on the ratio to the ambient profile.

For gene expression, the sparsity assumption is less justifiable.
Each cell could feasibly express a majority of the transcriptome (once we ignore constitutively silent features in the annotation, like pseudogenes).
The sparsity of gene expression data also yields less precise scale estimates, reducing their utility in downstream applications.
See \code{\link{ambientContribNegative}} or \code{\link{ambientContribMaximum}} instead, which operate from different assumptions.
}
\examples{
amb <- 1:10
y <- matrix(rpois(10000, lambda=amb), nrow=10)
y[sample(length(y), 1000, replace=TRUE)] <- 1000

scaling <- ambientContribSparse(y, ambient=amb)
hist(scaling)

}
\seealso{
\code{\link{ambientProfileBimodal}}, to estimate the ambient profile for use in \code{ambient}.

\code{\link{cleanTagCounts}}, where this function is used to estimate ambient scaling factors.
}
\author{
Aaron Lun
}
