% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\docType{class}
\name{UMAP-class}
\alias{UMAP-class}
\alias{UMAP}
\title{Umap embedding}
\description{
An S4 Class implementing the UMAP algorithm
}
\details{
Uniform Manifold Approximation is a gradient descend based algorithm that
gives results similar to t-SNE, but scales better with the number of points.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{


UMAP can take the follwing parameters:
\describe{
  \item{ndim}{The number of embedding dimensions.}
  \item{knn}{The number of neighbors to be used.}
  \item{d}{The distance metric to use.}
  \item{method}{\code{"naive"} for an R implementation, \code{"python"}
    for the reference implementation.}
}

Other method parameters can also be passed, see
\code{\link[umap]{umap.defaults}} for details. The ones above have been
standardized for the use with \code{dimRed} and will get automatically
translated for \code{\link[umap]{umap}}.
}

\section{Implementation}{


The dimRed package wraps the \code{\link[umap]{umap}} packages which provides
an implementation in pure R and also a wrapper around the original python
package \code{umap-learn} (https://github.com/lmcinnes/umap/). This requires
\code{umap-learn} version 0.4 installed, at the time of writing, there is
already \code{umap-learn} 0.5 but it is not supported by the R package
\code{\link[umap]{umap}}.

The \code{"naive"} implementation is a pure R implementation and considered
experimental at the point of writing this, it is also much slower than the
python implementation.

The \code{"python"} implementation is the reference implementation used by
McInees et. al. (2018). It requires the \code{\link[reticulate]{reticulate}}
package for the interaction with python and the python package
\code{umap-learn} installed (use \code{pip install umap-learn}).
}

\examples{
\dontrun{
dat <- loadDataSet("3D S Curve", n = 300)
emb <- embed(dat, "UMAP", .mute = NULL, knn = 10)
plot(emb, type = "2vars")
}

}
\references{
McInnes, Leland, and John Healy.
"UMAP: Uniform Manifold Approximation and Projection for Dimension Reduction."
https://arxiv.org/abs/1802.03426
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{AutoEncoder-class}},
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{DrL-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{HLLE-class}},
\code{\link{Isomap-class}},
\code{\link{KamadaKawai-class}},
\code{\link{MDS-class}},
\code{\link{NNMF-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{nMDS-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
