---
id: Checkbox
section: components
subsection: forms
cssPrefix: pf-v6-c-check
propComponents: ['Checkbox']
---

import { Fragment, useEffect, useState } from 'react';

## Examples

### Controlled

```ts file='./CheckboxControlled.tsx'

```

### Uncontrolled

```ts file='./CheckboxUncontrolled.tsx'

```

### Reversed

```ts file="./CheckboxReversed.tsx"

```

### Label wraps

You can expand the clickable area of a checkbox so that it spans wider than the checkbox label by adding the `isLabelWrapped` property. This allows users to select a checkbox by clicking the checkbox itself, the label, or the area between the checkbox and the label.

```ts file="./CheckboxLabelWraps.tsx"

```

### Disabled

```ts file='./CheckboxDisabled.tsx'

```

### Checkbox with description

```ts file='./CheckboxWithDescription.tsx'

```

### Checkbox with body

```ts file='./CheckboxWithBody.tsx'

```

### Checkbox with description and body

```ts file='./CheckboxWithDescriptionBody.tsx'

```

### Standalone input

```ts file='./CheckboxStandaloneInput.tsx'

```

### Required input

```ts file='./CheckboxRequired.tsx'

```
