// generated by diplomat-tool
import type { CodePointRangeIterator } from "./CodePointRangeIterator"
import type { CodePointSetData } from "./CodePointSetData"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X Unicode Map Property object, capable of querying whether a code point (key) to obtain the Unicode property value, for a specific Unicode property.
 *
 * For properties whose values fit into 16 bits.
 *
 * See the [Rust documentation for `properties`](https://docs.rs/icu/latest/icu/properties/index.html) for more information.
 *
 * See the [Rust documentation for `CodePointMapData`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapData.html) for more information.
 *
 * See the [Rust documentation for `CodePointMapDataBorrowed`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html) for more information.
 */


export class CodePointMapData16 {
    get ffiValue(): pointer;


    /**
     * Gets the value for a code point.
     *
     * See the [Rust documentation for `get`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.get) for more information.
     */
    get(cp: codepoint): number;

    /**
     * Produces an iterator over ranges of code points that map to `value`
     *
     * See the [Rust documentation for `iter_ranges_for_value`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.iter_ranges_for_value) for more information.
     */
    iterRangesForValue(value: number): CodePointRangeIterator;

    /**
     * Produces an iterator over ranges of code points that do not map to `value`
     *
     * See the [Rust documentation for `iter_ranges_for_value_complemented`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.iter_ranges_for_value_complemented) for more information.
     */
    iterRangesForValueComplemented(value: number): CodePointRangeIterator;

    /**
     * Gets a [`CodePointSetData`] representing all entries in this map that map to the given value
     *
     * See the [Rust documentation for `get_set_for_value`](https://docs.rs/icu/latest/icu/properties/struct.CodePointMapDataBorrowed.html#method.get_set_for_value) for more information.
     */
    getSetForValue(value: number): CodePointSetData;

    /**
     * Create a map for the `Script` property, using compiled data.
     *
     * See the [Rust documentation for `Script`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html) for more information.
     */
    static createScript(): CodePointMapData16;

    /**
     * Create a map for the `Script` property, using a particular data source.
     *
     * See the [Rust documentation for `Script`](https://docs.rs/icu/latest/icu/properties/props/struct.Script.html) for more information.
     */
    static createScriptWithProvider(provider: DataProvider): CodePointMapData16;
}