// generated by diplomat-tool
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import { LocaleFallbackConfig } from "./LocaleFallbackConfig.mjs"
import { LocaleFallbackerWithConfig } from "./LocaleFallbackerWithConfig.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An object that runs the ICU4X locale fallback algorithm.
 *
 * See the [Rust documentation for `LocaleFallbacker`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbacker.html) for more information.
 */
const LocaleFallbacker_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_LocaleFallbacker_destroy_mv1(ptr);
});

export class LocaleFallbacker {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("LocaleFallbacker is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            LocaleFallbacker_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Creates a new `LocaleFallbacker` from compiled data.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbacker.html#method.new) for more information.
     */
    #defaultConstructor() {

        const result = wasm.icu4x_LocaleFallbacker_create_mv1();

        try {
            return new LocaleFallbacker(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Creates a new `LocaleFallbacker` from a data provider.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbacker.html#method.new) for more information.
     */
    static createWithProvider(provider) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_LocaleFallbacker_create_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new LocaleFallbacker(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * Creates a new `LocaleFallbacker` without data for limited functionality.
     *
     * See the [Rust documentation for `new_without_data`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbacker.html#method.new_without_data) for more information.
     */
    static withoutData() {

        const result = wasm.icu4x_LocaleFallbacker_without_data_mv1();

        try {
            return new LocaleFallbacker(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Associates this `LocaleFallbacker` with configuration options.
     *
     * See the [Rust documentation for `for_config`](https://docs.rs/icu/latest/icu/locale/fallback/struct.LocaleFallbacker.html#method.for_config) for more information.
     */
    forConfig(config) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        // This lifetime edge depends on lifetimes 'a
        let aEdges = [this];


        const result = wasm.icu4x_LocaleFallbacker_for_config_mv1(this.ffiValue, ...LocaleFallbackConfig._fromSuppliedValue(diplomatRuntime.internalConstructor, config)._intoFFI(functionCleanupArena, {}));

        try {
            return new LocaleFallbackerWithConfig(diplomatRuntime.internalConstructor, result, [], aEdges);
        }

        finally {
            functionCleanupArena.free();

        }
    }

    constructor() {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}