// Copyright (C) 2011  Internet Systems Consortium, Inc. ("ISC")
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
// REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
// INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
// LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
// OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THIS SOFTWARE.

#ifndef __PYTHON_MESSAGERENDERER_H
#define __PYTHON_MESSAGERENDERER_H 1

#include <Python.h>

#include <util/buffer.h>

namespace isc {
namespace dns {
class MessageRenderer;

namespace python {

extern PyTypeObject messagerenderer_type;

/// \brief Checks if the given python object is a MessageRenderer object
///
/// \exception PyCPPWrapperException if obj is NULL
///
/// \param obj The object to check the type of
/// \return true if the object is of type MessageRenderer, false otherwise
bool PyMessageRenderer_Check(PyObject* obj);

/// \brief Returns a reference to the MessageRenderer object contained within the given
///        Python object.
///
/// \note The given object MUST be of type MessageRenderer; this can be checked with
///       either the right call to ParseTuple("O!"), or with PyMessageRenderer_Check()
///
/// \note This is not a copy; if the MessageRenderer is needed when the PyObject
/// may be destroyed, the caller must copy it itself.
///
/// \param messagerenderer_obj The messagerenderer object to convert
MessageRenderer& PyMessageRenderer_ToMessageRenderer(PyObject* messagerenderer_obj);

} // namespace python
} // namespace dns
} // namespace isc
#endif // __PYTHON_MESSAGERENDERER_H

// Local Variables:
// mode: c++
// End:
