#include "port_before.h"

#include <net/if.h>

#include "port_after.h"


/*
 * Forward Declarations
 */
int GetInterfacesWSAIoctl(struct ifdata *IFData[]);
int GetInterfacesSNMP(struct ifdata *IFData[]);

/*
 * Enumerate the TCP/IP interfaces on this machine.
 * Prefer SNMP since it gives more complete data, 
 * but fallback to WSAIoctl() if SNMP isn't available.
 * - Note that WSAIoctl() often fails to enumerate the
 * loopback interface.
 *
 * GetInterfacesXXXX() will malloc elements in the IFData array
 * It is the caller's responsibility to free this memory
 */
int GetInterfaces(struct ifdata *IFData[])
{
	HANDLE hDLL = LoadLibrary("inetmib1.dll");
	if(hDLL)
	{
		FreeLibrary(hDLL);
		/* snmpmib.c */
		return(GetInterfacesSNMP(IFData));
	}
	/* ioctl_if.c */
	return(GetInterfacesWSAIoctl(IFData));
}