/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.laf.InputBindings;
import org.netbeans.api.visual.laf.LookFeel;
import org.netbeans.api.visual.widget.BirdViewController;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.SceneComponent;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;
import org.netbeans.modules.visual.widget.SatelliteComponent;

public class Scene
extends Widget {
    private double zoomFactor = 1.0;
    private SceneAnimator sceneAnimator;
    private JComponent component = null;
    private Graphics2D graphics = null;
    private boolean viewShowing = false;
    private boolean paintEverything = true;
    private Rectangle repaintRegion = null;
    private HashSet<Widget> repaintWidgets = new HashSet();
    private Font defaultFont;
    private LookFeel lookFeel = LookFeel.createDefaultLookFeel();
    private InputBindings inputBindings = InputBindings.create();
    private String activeTool = null;
    private Rectangle maximumBounds = new Rectangle(-1073741824, -1073741824, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final ArrayList<SceneListener> sceneListeners = new ArrayList();
    private EventProcessingType keyEventProcessingType = EventProcessingType.ALL_WIDGETS;
    private WidgetAction.Chain priorActions = new WidgetAction.Chain();
    private Widget focusedWidget = this;
    private WidgetAction widgetHoverAction;
    boolean extendSceneOnly = false;
    private ResourceTable resourceTable = null;

    public Scene() {
        super(null);
        this.defaultFont = Font.decode(null);
        this.resolveBounds(new Point(), new Rectangle());
        this.setOpaque(true);
        this.setFont(this.defaultFont);
        this.setBackground(this.lookFeel.getBackground());
        this.setForeground(this.lookFeel.getForeground());
        this.sceneAnimator = new SceneAnimator(this);
    }

    public JComponent createView() {
        assert (this.component == null);
        this.component = new SceneComponent(this);
        this.component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Scene.this.repaintSatellite();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                Scene.this.repaintSatellite();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        return this.component;
    }

    public JComponent getView() {
        return this.component;
    }

    public JComponent createSatelliteView() {
        return new SatelliteComponent(this);
    }

    public BirdViewController createBirdView() {
        return new BirdViewController(this);
    }

    void setViewShowing(boolean viewShowing) {
        assert (this.viewShowing != viewShowing) : "Duplicate setViewShowing: " + viewShowing;
        this.viewShowing = viewShowing;
        if (viewShowing) {
            this.dispatchNotifyAddedCore();
        } else {
            this.dispatchNotifyRemovedCore();
        }
    }

    void dispatchNotifyAdded(Widget widget) {
        assert (widget != null);
        Widget w = widget;
        while (w != this) {
            if ((w = w.getParentWidget()) != null) continue;
            return;
        }
        if (!this.viewShowing) {
            return;
        }
        widget.dispatchNotifyAddedCore();
    }

    void dispatchNotifyRemoved(Widget widget) {
        assert (widget != null);
        Widget w = widget;
        do {
            if (w != this) continue;
            if (!this.viewShowing) break;
            return;
        } while ((w = w.getParentWidget()) != null);
        if (!this.viewShowing) {
            return;
        }
        widget.dispatchNotifyRemovedCore();
    }

    @Override
    public final Graphics2D getGraphics() {
        return this.graphics;
    }

    final void setGraphics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    public final void validate(Graphics2D graphics) {
        Graphics2D prevoiusGraphics = this.getGraphics();
        this.setGraphics(graphics);
        this.validate();
        this.setGraphics(prevoiusGraphics);
    }

    public final void paint(Graphics2D graphics) {
        this.validate();
        Graphics2D prevoiusGraphics = this.getGraphics();
        this.setGraphics(graphics);
        this.paint();
        this.setGraphics(prevoiusGraphics);
    }

    public final Rectangle getMaximumBounds() {
        return new Rectangle(this.maximumBounds);
    }

    public final void setMaximumBounds(Rectangle maximumBounds) {
        assert (maximumBounds != null);
        this.maximumBounds = new Rectangle(maximumBounds);
        this.revalidate();
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    @Override
    public boolean isValidated() {
        return super.isValidated() && this.repaintRegion == null && this.repaintWidgets.isEmpty();
    }

    @Override
    protected boolean isRepaintRequiredForRevalidating() {
        return false;
    }

    final void revalidateWidget(Widget widget) {
        Rectangle widgetBounds = widget.getBounds();
        if (widgetBounds != null) {
            Rectangle sceneBounds = widget.convertLocalToScene(widgetBounds);
            if (this.repaintRegion == null) {
                this.repaintRegion = sceneBounds;
            } else {
                this.repaintRegion.add(sceneBounds);
            }
        }
        this.repaintWidgets.add(widget);
    }

    private void layoutScene() {
        Point preLocation = this.getLocation();
        Rectangle preBounds = this.getBounds();
        this.layout(false);
        this.resolveBounds(null, null);
        this.justify();
        Rectangle rect = null;
        for (Widget widget : this.getChildren()) {
            Point location = widget.getLocation();
            Rectangle bounds = widget.getBounds();
            bounds.translate(location.x, location.y);
            if (rect == null) {
                rect = bounds;
                continue;
            }
            rect.add(bounds);
        }
        if (rect != null) {
            Insets insets = this.getBorder().getInsets();
            rect.x -= insets.left;
            rect.y -= insets.top;
            rect.width += insets.left + insets.right;
            rect.height += insets.top + insets.bottom;
            rect = rect.intersection(this.maximumBounds);
        }
        if (this.extendSceneOnly && rect != null && preBounds != null) {
            rect.add(new Rectangle(preBounds.x + preLocation.x, preBounds.y + preLocation.y, preBounds.width, preBounds.height));
        }
        this.resolveBounds(rect != null ? new Point(-rect.x, -rect.y) : new Point(), rect);
        Dimension preferredSize = rect != null ? rect.getSize() : new Dimension();
        preferredSize = new Dimension((int)((double)preferredSize.width * this.zoomFactor), (int)((double)preferredSize.height * this.zoomFactor));
        Rectangle bounds = this.getBounds();
        if (this.component != null) {
            if (!preferredSize.equals(this.component.getPreferredSize())) {
                this.component.setPreferredSize(preferredSize);
                this.component.revalidate();
                bounds = this.getBounds();
            }
            Dimension componentSize = this.component.getSize();
            componentSize.width = (int)((double)componentSize.width / this.zoomFactor);
            componentSize.height = (int)((double)componentSize.height / this.zoomFactor);
            boolean sceneResized = false;
            if (bounds.width < componentSize.width) {
                bounds.width = componentSize.width;
                sceneResized = true;
            }
            if (bounds.height < componentSize.height) {
                bounds.height = componentSize.height;
                sceneResized = true;
            }
            if (sceneResized) {
                this.resolveBounds(this.getLocation(), bounds);
            }
        }
        if (!this.getLocation().equals(preLocation) || !this.getBounds().equals(preBounds)) {
            Rectangle rectangle = this.convertLocalToScene(this.getBounds());
            if (this.repaintRegion == null) {
                this.repaintRegion = rectangle;
            } else {
                this.repaintRegion.add(rectangle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void validate() {
        if (this.graphics == null) {
            return;
        }
        block2: while (!this.isValidated()) {
            SceneListener[] sceneListenerArray = this.sceneListeners;
            // MONITORENTER : this.sceneListeners
            SceneListener[] ls = this.sceneListeners.toArray(new SceneListener[0]);
            // MONITOREXIT : sceneListenerArray
            for (SceneListener listener : ls) {
                listener.sceneValidating();
            }
            this.layoutScene();
            this.resolveRepaints();
            sceneListenerArray = ls;
            int n = sceneListenerArray.length;
            int n2 = 0;
            while (true) {
                SceneListener listener;
                if (n2 >= n) continue block2;
                listener = sceneListenerArray[n2];
                listener.sceneValidated();
                ++n2;
            }
            break;
        }
        return;
    }

    private void resolveRepaints() {
        assert (SwingUtilities.isEventDispatchThread());
        for (Widget widget : this.repaintWidgets) {
            Rectangle repaintBounds = widget.getBounds();
            if (repaintBounds == null) continue;
            repaintBounds = widget.convertLocalToScene(repaintBounds);
            if (this.repaintRegion != null) {
                this.repaintRegion.add(repaintBounds);
                continue;
            }
            this.repaintRegion = repaintBounds;
        }
        this.repaintWidgets.clear();
        if (this.repaintRegion != null) {
            Rectangle r = this.convertSceneToView(this.repaintRegion);
            r.grow(1, 1);
            if (this.component != null) {
                this.component.repaint(r);
            }
            this.repaintSatellite();
            this.repaintRegion = null;
        }
    }

    void setExtendSceneOnly(boolean extendSceneOnly) {
        this.extendSceneOnly = extendSceneOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintSatellite() {
        SceneListener[] sceneListenerArray = this.sceneListeners;
        synchronized (this.sceneListeners) {
            SceneListener[] ls = this.sceneListeners.toArray(new SceneListener[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (SceneListener listener : ls) {
                listener.sceneRepaint();
            }
            return;
        }
    }

    final boolean isPaintEverything() {
        return this.paintEverything;
    }

    final void setPaintEverything(boolean paintEverything) {
        this.paintEverything = paintEverything;
    }

    public final EventProcessingType getKeyEventProcessingType() {
        return this.keyEventProcessingType;
    }

    public final void setKeyEventProcessingType(EventProcessingType keyEventProcessingType) {
        assert (keyEventProcessingType != null);
        this.keyEventProcessingType = keyEventProcessingType;
    }

    public final WidgetAction.Chain getPriorActions() {
        return this.priorActions;
    }

    public final Widget getFocusedWidget() {
        return this.focusedWidget;
    }

    public final void setFocusedWidget(Widget focusedWidget) {
        if (focusedWidget == null) {
            focusedWidget = this;
        } else assert (focusedWidget.getScene() == this);
        this.focusedWidget.setState(this.focusedWidget.getState().deriveWidgetFocused(false));
        this.focusedWidget = focusedWidget;
        this.focusedWidget.setState(this.focusedWidget.getState().deriveWidgetFocused(true));
    }

    public final double getZoomFactor() {
        return this.zoomFactor;
    }

    public final void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.revalidate();
    }

    public final SceneAnimator getSceneAnimator() {
        return this.sceneAnimator;
    }

    public final LookFeel getLookFeel() {
        return this.lookFeel;
    }

    public final void setLookFeel(LookFeel lookFeel) {
        assert (lookFeel != null);
        this.lookFeel = lookFeel;
    }

    public final InputBindings getInputBindings() {
        return this.inputBindings;
    }

    public final String getActiveTool() {
        return this.activeTool;
    }

    public void setActiveTool(String activeTool) {
        this.activeTool = activeTool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSceneListener(SceneListener listener) {
        assert (listener != null);
        ArrayList<SceneListener> arrayList = this.sceneListeners;
        synchronized (arrayList) {
            this.sceneListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSceneListener(SceneListener listener) {
        ArrayList<SceneListener> arrayList = this.sceneListeners;
        synchronized (arrayList) {
            this.sceneListeners.remove(listener);
        }
    }

    public final Point convertSceneToView(Point sceneLocation) {
        Point location = this.getLocation();
        return new Point((int)(this.zoomFactor * (double)(location.x + sceneLocation.x)), (int)(this.zoomFactor * (double)(location.y + sceneLocation.y)));
    }

    public final Rectangle convertSceneToView(Rectangle sceneRectangle) {
        Point location = this.getLocation();
        return GeomUtil.roundRectangle(new Rectangle2D.Double((double)(sceneRectangle.x + location.x) * this.zoomFactor, (double)(sceneRectangle.y + location.y) * this.zoomFactor, (double)sceneRectangle.width * this.zoomFactor, (double)sceneRectangle.height * this.zoomFactor));
    }

    public Rectangle convertViewToScene(Rectangle viewRect) {
        Point pt1 = new Point(viewRect.x, viewRect.y);
        pt1 = this.convertViewToScene(pt1);
        if (viewRect.isEmpty()) {
            return new Rectangle(pt1.x, pt1.y, 0, 0);
        }
        Point pt2 = new Point(viewRect.x + viewRect.width - 1, viewRect.y + viewRect.height - 1);
        pt2 = this.convertViewToScene(pt2);
        Rectangle r = new Rectangle(pt1);
        r.add(pt2);
        return r;
    }

    public Point convertViewToScene(Point viewLocation) {
        return new Point((int)((double)viewLocation.x / this.zoomFactor) - this.getLocation().x, (int)((double)viewLocation.y / this.zoomFactor) - this.getLocation().y);
    }

    public WidgetAction createWidgetHoverAction() {
        if (this.widgetHoverAction == null) {
            this.widgetHoverAction = ActionFactory.createHoverAction(new WidgetHoverAction());
            this.getActions().addAction(this.widgetHoverAction);
        }
        return this.widgetHoverAction;
    }

    @Override
    public void setResourceTable(ResourceTable table) {
        this.resourceTable = table;
    }

    @Override
    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public static interface SceneListener {
        public void sceneRepaint();

        public void sceneValidating();

        public void sceneValidated();
    }

    private class WidgetHoverAction
    implements TwoStateHoverProvider {
        private WidgetHoverAction() {
        }

        @Override
        public void unsetHovering(Widget widget) {
            widget.setState(widget.getState().deriveWidgetHovered(false));
        }

        @Override
        public void setHovering(Widget widget) {
            widget.setState(widget.getState().deriveWidgetHovered(true));
        }
    }
}

