/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.util.BaseUtilities;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class NbBundleProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(NbBundle.Messages.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap<String, HashSet<Element>> annotatedElementsByPackage = new HashMap<String, HashSet<Element>>();
        for (Element element : roundEnv.getElementsAnnotatedWith(NbBundle.Messages.class)) {
            NbBundle.Messages messages = element.getAnnotation(NbBundle.Messages.class);
            if (messages == null) continue;
            String pkg = this.findPackage(element);
            HashSet<Element> annotatedElements = (HashSet<Element>)annotatedElementsByPackage.get(pkg);
            if (annotatedElements == null) {
                annotatedElements = new HashSet<Element>();
                annotatedElementsByPackage.put(pkg, annotatedElements);
            }
            annotatedElements.add(element);
        }
        block23: for (Map.Entry entry : annotatedElementsByPackage.entrySet()) {
            String pkg = (String)entry.getKey();
            Set annotatedElements = (Set)entry.getValue();
            PackageElement pkgE = this.processingEnv.getElementUtils().getPackageElement(pkg);
            if (pkgE != null) {
                HashSet<? extends Element> unscannedTopElements = new HashSet<Element>();
                unscannedTopElements.add(pkgE);
                try {
                    unscannedTopElements.addAll(pkgE.getEnclosedElements());
                }
                catch (RuntimeException x) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "#196556: reading " + pkg + " failed with " + x + " in " + x.getStackTrace()[0] + "; do a clean build!");
                }
                unscannedTopElements.removeAll(roundEnv.getRootElements());
                this.addToAnnotatedElements(unscannedTopElements, annotatedElements);
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not check for other source files in " + pkg);
            }
            HashMap<String, String> pairs = new HashMap<String, String>();
            HashMap<String, Element> identifiers = new HashMap<String, Element>();
            HashMap<String, String> compilationUnits = new HashMap<String, String>();
            HashMap<String, String[]> comments = new HashMap<String, String[]>();
            for (Element e : annotatedElements) {
                String simplename = this.findCompilationUnitName(e);
                ArrayList<String> runningComments = new ArrayList<String>();
                for (String keyValue : e.getAnnotation(NbBundle.Messages.class).value()) {
                    if (keyValue.startsWith("#")) {
                        runningComments.add(keyValue);
                        if (!keyValue.matches("# +(PART)?(NO)?I18N *")) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "#NOI18N and related keywords must not include spaces", e);
                        continue;
                    }
                    int i = keyValue.indexOf(61);
                    if (i == -1) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Bad key=value: " + keyValue, e);
                        continue;
                    }
                    String key = keyValue.substring(0, i);
                    if (key.isEmpty() || !key.equals(key.trim())) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Whitespace not permitted in key: " + keyValue, e);
                        continue;
                    }
                    Element original = identifiers.put(this.toIdentifier(key), e);
                    if (original != null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + key, e);
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + key, original);
                        continue block23;
                    }
                    String value = keyValue.substring(i + 1);
                    pairs.put(key, value);
                    compilationUnits.put(key, simplename);
                    if (runningComments.isEmpty()) continue;
                    comments.put(key, runningComments.toArray(new String[0]));
                    runningComments.clear();
                }
                if (runningComments.isEmpty()) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Comments must precede keys", e);
            }
            Element[] elements = new HashSet(identifiers.values()).toArray(new Element[0]);
            try {
                EditableProperties p = new EditableProperties(true);
                try (InputStream is22 = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, pkg, "Bundle.properties").openInputStream();){
                    p.load(is22);
                }
                catch (IOException is22) {
                    // empty catch block
                }
                for (String key : p.keySet()) {
                    if (!pairs.containsKey(key)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Key " + key + " is a duplicate of one from Bundle.properties", (Element)identifiers.get(this.toIdentifier(key)));
                }
                try (InputStream is32 = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, "Bundle.properties").openInputStream();){
                    EditableProperties p2 = new EditableProperties(true);
                    p2.load(is32);
                    p.putAll(p2);
                }
                catch (IOException is32) {
                    // empty catch block
                }
                p.putAll(pairs);
                for (Map.Entry entry2 : comments.entrySet()) {
                    p.setComment((String)entry2.getKey(), (String[])entry2.getValue(), false);
                }
                try (OutputStream os = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, pkg, "Bundle.properties", elements).openOutputStream();){
                    p.store(os);
                }
                TreeMap<String, String> methods = new TreeMap<String, String>();
                for (Map.Entry entry2 : pairs.entrySet()) {
                    String key = (String)entry2.getKey();
                    String value = (String)entry2.getValue();
                    StringBuilder method = new StringBuilder();
                    method.append("    /**\n");
                    ArrayList<String> params = new ArrayList<String>();
                    int i = 0;
                    while (value.contains("{" + i)) {
                        params.add("arg" + i++);
                    }
                    String[] commentLines = (String[])comments.get(key);
                    if (commentLines != null) {
                        for (String comment : commentLines) {
                            Matcher m = Pattern.compile("# [{](\\d+)[}] - (.+)").matcher(comment);
                            if (!m.matches()) continue;
                            i = Integer.parseInt(m.group(1));
                            while (i >= params.size()) {
                                params.add("arg" + params.size());
                            }
                            String desc = m.group(2);
                            params.set(i, this.toIdentifier(desc));
                            method.append("     * @param ").append((String)params.get(i)).append(" ").append(this.toJavadoc(desc)).append("\n");
                        }
                    }
                    StringBuffer annotatedValue = new StringBuffer("<i>");
                    Matcher m = Pattern.compile("[{](\\d+)[}]").matcher(this.toJavadoc(value));
                    while (m.find()) {
                        i = Integer.parseInt(m.group(1));
                        m.appendReplacement(annotatedValue, i < params.size() ? "</i>{@code " + (String)params.get(i) + "}<i>" : m.group());
                    }
                    m.appendTail(annotatedValue);
                    annotatedValue.append("</i>");
                    method.append("     * @return ").append(annotatedValue.toString().replace("<i></i>", "")).append('\n');
                    method.append("     * @see ").append((String)compilationUnits.get(key)).append('\n');
                    method.append("     */\n");
                    String name = this.toIdentifier(key);
                    method.append("    static String ").append(name).append("(");
                    boolean first = true;
                    i = 0;
                    for (String param : params) {
                        if (param.equals("arg" + i)) {
                            this.warnUndocumented(i, (Element)identifiers.get(name), key);
                        }
                        ++i;
                        if (first) {
                            first = false;
                        } else {
                            method.append(", ");
                        }
                        method.append("Object ").append(param);
                    }
                    method.append(") {\n");
                    method.append("        return org.openide.util.NbBundle.getMessage(Bundle.class, \"").append(key).append("\"");
                    for (String param : params) {
                        method.append(", ").append(param);
                    }
                    method.append(");\n");
                    method.append("    }\n");
                    methods.put(name, method.toString());
                }
                try {
                    TreeSet<String> restored = new TreeSet<String>();
                    Matcher matcher = Pattern.compile("    /[*][*]\r?\n(?:     [*].+\r?\n)+     [*] @see (?:[\\w-]+)\r?\n     [*]/\r?\n    static String (\\w+).+\r?\n        .+\r?\n    [}]\r?\n").matcher(this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, pkg, "Bundle.java").getCharContent(false));
                    while (matcher.find()) {
                        String identifier = matcher.group(1);
                        if (methods.containsKey(identifier)) continue;
                        methods.put(identifier, matcher.group());
                        restored.add(identifier);
                    }
                }
                catch (IOException restored) {
                    // empty catch block
                }
                String fqn = pkg + ".Bundle";
                try (Writer writer = this.processingEnv.getFiler().createSourceFile(fqn, elements).openWriter();){
                    PrintWriter pw = new PrintWriter(writer);
                    pw.println("package " + pkg + ";");
                    pw.println("/** Localizable strings for {@link " + pkg + "}. */");
                    pw.println("class Bundle {");
                    for (String method : methods.values()) {
                        pw.print(method);
                    }
                    pw.println("    private Bundle() {}");
                    pw.println("}");
                    pw.flush();
                    pw.close();
                }
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate files: " + x, elements[0]);
            }
        }
        return true;
    }

    private String findPackage(Element e) {
        switch (e.getKind()) {
            case PACKAGE: {
                return ((PackageElement)e).getQualifiedName().toString();
            }
        }
        return this.findPackage(e.getEnclosingElement());
    }

    private String findCompilationUnitName(Element e) {
        switch (e.getKind()) {
            case PACKAGE: {
                return "package-info";
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                if (e.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                return e.getSimpleName().toString();
            }
        }
        if ("RECORD".equals(e.getKind().name()) && e.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return e.getSimpleName().toString();
        }
        return this.findCompilationUnitName(e.getEnclosingElement());
    }

    private String toIdentifier(String key) {
        if (BaseUtilities.isJavaIdentifier(key)) {
            return key;
        }
        String i = key.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_");
        if (BaseUtilities.isJavaIdentifier(i)) {
            return i;
        }
        return "_" + i;
    }

    private String toJavadoc(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace("*/", "&#x2A;/").replace("\n", "<br>").replace("@", "&#64;");
    }

    private void addToAnnotatedElements(Collection<? extends Element> unscannedElements, Set<Element> annotatedElements) {
        for (Element element : unscannedElements) {
            if (element.getAnnotation(NbBundle.Messages.class) != null) {
                annotatedElements.add(element);
            }
            if (element.getKind() == ElementKind.PACKAGE) continue;
            this.addToAnnotatedElements(element.getEnclosedElements(), annotatedElements);
        }
    }

    private void warnUndocumented(int i, Element e, String key) {
        AnnotationMirror mirror = null;
        AnnotationValue value = null;
        if (e != null) {
            block0: for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(NbBundle.Messages.class.getCanonicalName())) continue;
                mirror = annotationMirror;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                    Object v = entry.getValue().getValue();
                    if (v instanceof String) {
                        if (!((String)v).startsWith(key + "=")) break block0;
                        value = entry.getValue();
                        break block0;
                    }
                    for (AnnotationValue subentry : NbCollections.checkedListByCopy((List)v, AnnotationValue.class, true)) {
                        v = subentry.getValue();
                        if (!(v instanceof String) || !((String)v).startsWith(key + "=")) continue;
                        value = subentry;
                        break block0;
                    }
                }
            }
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Undocumented format parameter {" + i + "} prepend line: # {" + i + "} - some text,", e, mirror, value);
    }
}

